/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ExplodingOutputtingInputStream;
import org.apache.felix.deploymentadmin.FileDeploymentPackage;
import org.apache.felix.deploymentadmin.Semaphore;
import org.apache.felix.deploymentadmin.StreamDeploymentPackage;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.DropBundleCommand;
import org.apache.felix.deploymentadmin.spi.DropResourceCommand;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.apache.felix.deploymentadmin.spi.ProcessResourceCommand;
import org.apache.felix.deploymentadmin.spi.SnapshotCommand;
import org.apache.felix.deploymentadmin.spi.StartBundleCommand;
import org.apache.felix.deploymentadmin.spi.StartCustomizerCommand;
import org.apache.felix.deploymentadmin.spi.StopBundleCommand;
import org.apache.felix.deploymentadmin.spi.UpdateCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DeploymentAdminImpl
implements DeploymentAdmin {
    public static final String PACKAGE_DIR = "packages";
    public static final String TEMP_DIR = "temp";
    public static final String PACKAGECONTENTS_DIR = "contents";
    public static final String PACKAGEINDEX_FILE = "index.txt";
    public static final String TEMP_PREFIX = "pkg";
    public static final String TEMP_POSTFIX = "";
    private static final long TIMEOUT = 10000L;
    private BundleContext m_context;
    private PackageAdmin m_packageAdmin;
    private EventAdmin m_eventAdmin;
    private LogService m_log;
    private DeploymentSessionImpl m_session = null;
    private final Map m_packages = new HashMap();
    private final List m_commandChain = new ArrayList();
    private final Semaphore m_semaphore = new Semaphore();

    public DeploymentAdminImpl() {
        GetStorageAreaCommand getStorageAreaCommand = new GetStorageAreaCommand();
        this.m_commandChain.add(getStorageAreaCommand);
        this.m_commandChain.add(new StopBundleCommand());
        this.m_commandChain.add(new SnapshotCommand(getStorageAreaCommand));
        this.m_commandChain.add(new UpdateCommand());
        this.m_commandChain.add(new StartCustomizerCommand());
        CommitResourceCommand commitCommand = new CommitResourceCommand();
        this.m_commandChain.add(new ProcessResourceCommand(commitCommand));
        this.m_commandChain.add(new DropResourceCommand(commitCommand));
        this.m_commandChain.add(new DropBundleCommand());
        this.m_commandChain.add(commitCommand);
        this.m_commandChain.add(new StartBundleCommand());
    }

    public void start() throws DeploymentException {
        File packageDir = this.m_context.getDataFile(PACKAGE_DIR);
        if (packageDir == null) {
            throw new DeploymentException(463, "Could not create directories needed for deployment package persistence");
        }
        packageDir.mkdirs();
        File[] packages = packageDir.listFiles();
        for (int i = 0; i < packages.length; ++i) {
            if (!packages[i].isDirectory()) continue;
            try {
                File index = new File(packages[i], PACKAGEINDEX_FILE);
                File contents = new File(packages[i], PACKAGECONTENTS_DIR);
                FileDeploymentPackage dp = new FileDeploymentPackage(index, contents, this.m_context);
                this.m_packages.put(dp.getName(), dp);
                continue;
            }
            catch (IOException e) {
                this.m_log.log(2, "Could not read deployment package from disk, skipping: '" + packages[i].getAbsolutePath() + "'");
            }
        }
    }

    public void stop() {
        this.cancel();
    }

    public boolean cancel() {
        if (this.m_session != null) {
            this.m_session.cancel();
            return true;
        }
        return false;
    }

    public DeploymentPackage getDeploymentPackage(String symbName) {
        if (symbName == null) {
            throw new IllegalArgumentException("Symbolic name may not be null");
        }
        return (DeploymentPackage)this.m_packages.get(symbName);
    }

    public DeploymentPackage getDeploymentPackage(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle can not be null");
        }
        Iterator i = this.m_packages.values().iterator();
        while (i.hasNext()) {
            DeploymentPackage dp = (DeploymentPackage)i.next();
            if (dp.getBundle(bundle.getSymbolicName()) == null) continue;
            return dp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentPackage installDeploymentPackage(InputStream input) throws DeploymentException {
        if (input == null) {
            throw new IllegalArgumentException("Inputstream may not be null");
        }
        try {
            if (!this.m_semaphore.tryAcquire(10000L)) {
                throw new DeploymentException(465, "Timeout exceeded while waiting to install deployment package (10000msec)");
            }
        }
        catch (InterruptedException ie) {
            throw new DeploymentException(465, "Thread interrupted");
        }
        File tempPackage = null;
        AbstractDeploymentPackage source = null;
        boolean succeeded = false;
        try {
            boolean newPackage;
            JarInputStream jarInput = null;
            File tempIndex = null;
            File tempContents = null;
            try {
                File tempDir = this.m_context.getDataFile(TEMP_DIR);
                tempDir.mkdirs();
                tempPackage = File.createTempFile(TEMP_PREFIX, TEMP_POSTFIX, tempDir);
                tempPackage.delete();
                tempPackage.mkdirs();
                tempIndex = new File(tempPackage, PACKAGEINDEX_FILE);
                tempContents = new File(tempPackage, PACKAGECONTENTS_DIR);
                tempContents.mkdirs();
                input = new ExplodingOutputtingInputStream(input, tempIndex, tempContents);
            }
            catch (IOException e) {
                this.m_log.log(1, "Error writing package to disk", (Throwable)e);
                throw new DeploymentException(463, "Error writing package to disk", e);
            }
            try {
                jarInput = new JarInputStream(input);
            }
            catch (IOException e) {
                this.m_log.log(1, "Stream does not contain a valid Jar", (Throwable)e);
                throw new DeploymentException(404, "Stream does not contain a valid Jar", e);
            }
            source = new StreamDeploymentPackage(jarInput, this.m_context);
            this.sendStartedEvent(source.getName());
            AbstractDeploymentPackage target = (AbstractDeploymentPackage)this.getDeploymentPackage(source.getName());
            boolean bl = newPackage = target == null;
            if (newPackage) {
                target = AbstractDeploymentPackage.emptyPackage;
            }
            if (source.isFixPackage() && (newPackage || !source.getVersionRange().isInRange(target.getVersion()))) {
                succeeded = false;
                this.m_log.log(1, "Target package version '" + target.getVersion() + "' is not in source range '" + source.getVersionRange() + "'");
                throw new DeploymentException(463, "Target package version '" + target.getVersion() + "' is not in source range '" + source.getVersionRange() + "'");
            }
            try {
                this.m_session = new DeploymentSessionImpl(source, target, this.m_commandChain, this);
                this.m_session.call();
            }
            catch (DeploymentException de) {
                succeeded = false;
                throw de;
            }
            try {
                jarInput.close();
            }
            catch (IOException e) {
                this.m_log.log(2, "Could not close stream properly", (Throwable)e);
            }
            File targetContents = this.m_context.getDataFile(PACKAGE_DIR + File.separator + source.getName() + File.separator + PACKAGECONTENTS_DIR);
            File targetIndex = this.m_context.getDataFile(PACKAGE_DIR + File.separator + source.getName() + File.separator + PACKAGEINDEX_FILE);
            if (source.isFixPackage()) {
                try {
                    ExplodingOutputtingInputStream.merge(targetIndex, targetContents, tempIndex, tempContents);
                }
                catch (IOException e) {
                    succeeded = false;
                    this.m_log.log(1, "Could not merge source fix package with target deployment package", (Throwable)e);
                    throw new DeploymentException(463, "Could not merge source fix package with target deployment package", e);
                }
            } else {
                File targetPackage = this.m_context.getDataFile(PACKAGE_DIR + File.separator + source.getName());
                targetPackage.mkdirs();
                ExplodingOutputtingInputStream.replace(targetPackage, tempPackage);
            }
            FileDeploymentPackage fileDeploymentPackage = null;
            try {
                fileDeploymentPackage = new FileDeploymentPackage(targetIndex, targetContents, this.m_context);
                this.m_packages.put(source.getName(), fileDeploymentPackage);
            }
            catch (IOException e) {
                succeeded = false;
                this.m_log.log(1, "Could not create installed deployment package from disk", (Throwable)e);
                throw new DeploymentException(463, "Could not create installed deployment package from disk", e);
            }
            succeeded = true;
            FileDeploymentPackage fileDeploymentPackage2 = fileDeploymentPackage;
            if (tempPackage != null) {
                this.delete(tempPackage);
            }
            if (source != null) {
                this.sendCompleteEvent(source.getName(), succeeded);
            }
            this.m_semaphore.release();
            return fileDeploymentPackage2;
        }
        catch (Throwable throwable) {
            if (tempPackage != null) {
                this.delete(tempPackage);
            }
            if (source != null) {
                this.sendCompleteEvent(source.getName(), succeeded);
            }
            this.m_semaphore.release();
            throw throwable;
        }
    }

    private void delete(File target) {
        if (target.isDirectory()) {
            File[] childs = target.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                this.delete(childs[i]);
            }
        }
        target.delete();
    }

    public DeploymentPackage[] listDeploymentPackages() {
        Collection packages = this.m_packages.values();
        return packages.toArray(new DeploymentPackage[packages.size()]);
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    public LogService getLog() {
        return this.m_log;
    }

    public PackageAdmin getPackageAdmin() {
        return this.m_packageAdmin;
    }

    private void sendStartedEvent(String name) {
        Properties props = new Properties();
        ((Dictionary)props).put("deploymentpackage.name", name);
        Event completeEvent = new Event("org/osgi/service/deployment/INSTALL", (Dictionary)props);
        this.m_eventAdmin.postEvent(completeEvent);
    }

    private void sendCompleteEvent(String name, boolean success) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("deploymentpackage.name", name);
        ((Dictionary)props).put("successful", new Boolean(success));
        Event completeEvent = new Event("org/osgi/service/deployment/COMPLETE", props);
        this.m_eventAdmin.postEvent(completeEvent);
    }
}

