/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.deploymentadmin.OutputtingInputStream;

class ExplodingOutputtingInputStream
extends OutputtingInputStream
implements Runnable {
    private final Thread m_task;
    private final File m_contentDir;
    private final File m_indexFile;
    private final PipedInputStream m_input;

    public ExplodingOutputtingInputStream(InputStream inputStream, File indexFile, File contentDir) throws IOException {
        this(inputStream, new PipedOutputStream(), indexFile, contentDir);
    }

    public void close() throws IOException {
        super.close();
        this.waitFor();
    }

    private ExplodingOutputtingInputStream(InputStream inputStream, PipedOutputStream output, File index, File root) throws IOException {
        super(inputStream, output);
        this.m_contentDir = root;
        this.m_indexFile = index;
        this.m_input = new PipedInputStream(output);
        this.m_task = new Thread((Runnable)this, "Apache Felix DeploymentAdmin - ExplodingOutputtingInputStream");
        this.m_task.start();
    }

    public void waitFor() {
        try {
            this.m_task.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ZipInputStream input = null;
        PrintWriter writer = null;
        try {
            input = new ZipInputStream(this.m_input);
            writer = new PrintWriter(new FileWriter(this.m_indexFile));
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                File current = new File(this.m_contentDir, entry.getName());
                if (entry.isDirectory()) {
                    current.mkdirs();
                } else {
                    writer.println(entry.getName());
                    File parent = current.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    OutputStream output = null;
                    try {
                        output = new GZIPOutputStream(new FileOutputStream(current));
                        byte[] buffer = new byte[4096];
                        int i = input.read(buffer);
                        while (i > -1) {
                            output.write(buffer, 0, i);
                            i = input.read(buffer);
                        }
                    }
                    finally {
                        output.close();
                    }
                }
                input.closeEntry();
                writer.flush();
                entry = input.getNextEntry();
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void replace(File target, File source) {
        ExplodingOutputtingInputStream.delete(target, true);
        source.renameTo(target);
    }

    private static void delete(File root, boolean deleteRoot) {
        if (root.isDirectory()) {
            File[] childs = root.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                ExplodingOutputtingInputStream.delete(childs[i], true);
            }
        }
        if (deleteRoot) {
            root.delete();
        }
    }

    public static void merge(File targetIndex, File target, File sourceIndex, File source) throws IOException {
        String path;
        List targetFiles = ExplodingOutputtingInputStream.readIndex(targetIndex);
        List sourceFiles = ExplodingOutputtingInputStream.readIndex(sourceIndex);
        ArrayList<String> result = new ArrayList<String>(targetFiles);
        File manifestFile = new File(source, (String)sourceFiles.remove(0));
        Manifest resultManifest = new Manifest(new GZIPInputStream(new FileInputStream(manifestFile)));
        resultManifest.getMainAttributes().remove(new Attributes.Name("DeploymentPackage-FixPack"));
        Iterator i = result.iterator();
        while (i.hasNext()) {
            String targetFile = (String)i.next();
            if (resultManifest.getEntries().containsKey(targetFile) || targetFile.equals("META-INF/MANIFEST.MF")) continue;
            i.remove();
        }
        Iterator<Object> iter = sourceFiles.iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            if (targetFiles.contains(path)) {
                new File(target, path).delete();
            } else {
                result.add(path);
            }
            new File(source, path).renameTo(new File(target, path));
        }
        targetFiles.removeAll(sourceFiles);
        iter = resultManifest.getEntries().keySet().iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            Attributes sourceAttribute = resultManifest.getEntries().get(path);
            if (!"true".equals(sourceAttribute.remove(new Attributes.Name("DeploymentPackage-Missing")))) continue;
            targetFiles.remove(path);
        }
        iter = targetFiles.iterator();
        while (iter.hasNext()) {
            path = (String)iter.next();
            new File(target, path).delete();
        }
        GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(new File(target, "META-INF/MANIFEST.MF")));
        resultManifest.write(outputStream);
        outputStream.close();
        ExplodingOutputtingInputStream.writeIndex(targetIndex, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readIndex(File index) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(index));
            ArrayList<String> result = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIndex(File index, List input) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(index));
            Iterator iterator = input.iterator();
            while (iterator.hasNext()) {
                writer.println(iterator.next());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

