/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.NonCloseableStream;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;

class StreamDeploymentPackage
extends AbstractDeploymentPackage {
    private final JarInputStream m_input;
    private final List m_names = new ArrayList();

    public StreamDeploymentPackage(JarInputStream input, BundleContext bundleContext) throws DeploymentException {
        super(input.getManifest(), bundleContext);
        this.m_input = input;
    }

    public InputStream getBundleStream(String symbolicName) {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }

    public BundleInfoImpl[] getOrderedBundleInfos() {
        ArrayList<BundleInfoImpl> result = new ArrayList<BundleInfoImpl>();
        Iterator i = this.m_names.iterator();
        while (i.hasNext()) {
            String indexEntry = (String)i.next();
            BundleInfoImpl bundleInfo = this.getBundleInfoByPath(indexEntry);
            if (bundleInfo == null) continue;
            result.add(bundleInfo);
        }
        BundleInfoImpl[] bundleInfoImpls = this.getBundleInfoImpls();
        for (int i2 = 0; i2 < bundleInfoImpls.length; ++i2) {
            if (!bundleInfoImpls[i2].isMissing()) continue;
            result.add(bundleInfoImpls[i2]);
        }
        return result.toArray(new BundleInfoImpl[result.size()]);
    }

    public ResourceInfoImpl[] getOrderedResourceInfos() {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }

    public AbstractInfo getNextEntry() throws IOException {
        JarEntry nextEntry = this.m_input.getNextJarEntry();
        if (nextEntry == null) {
            return null;
        }
        String name = nextEntry.getName();
        this.m_names.add(name);
        AbstractInfo abstractInfoByPath = this.getAbstractInfoByPath(name);
        return abstractInfoByPath;
    }

    public InputStream getCurrentEntryStream() {
        return new NonCloseableStream(this.m_input);
    }
}

