/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class CommitResourceCommand
extends Command
implements Runnable {
    private final List m_processors = new ArrayList();

    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        ResourceProcessor processor;
        ListIterator i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            processor = (ResourceProcessor)i.previous();
            try {
                processor.prepare();
            }
            catch (ResourceProcessorException e) {
                session.getLog().log(1, "Preparing commit for resource processor failed", (Throwable)e);
                throw new DeploymentException(463, "Preparing commit for resource processor failed", e);
            }
        }
        i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            processor = (ResourceProcessor)i.previous();
            try {
                processor.commit();
            }
            catch (Exception e) {
                session.getLog().log(1, "Committing resource processor '" + processor + "' failed", (Throwable)e);
            }
        }
        this.m_processors.clear();
    }

    public void rollback() {
        ListIterator i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            ResourceProcessor processor = (ResourceProcessor)i.previous();
            try {
                processor.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            i.remove();
        }
    }

    public boolean addResourceProcessor(ResourceProcessor processor) {
        Iterator i = this.m_processors.iterator();
        while (i.hasNext()) {
            ResourceProcessor proc = (ResourceProcessor)i.next();
            if (proc != processor) continue;
            return false;
        }
        this.m_processors.add(processor);
        return true;
    }

    public void run() {
        this.rollback();
    }
}

