/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class DropBundleCommand
extends Command {
    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        LogService log = session.getLog();
        BundleInfoImpl[] orderedTargetBundles = target.getOrderedBundleInfos();
        for (int i = orderedTargetBundles.length - 1; i >= 0; --i) {
            BundleInfoImpl bundleInfo = orderedTargetBundles[i];
            if (bundleInfo.isCustomizer() || source.getBundleInfoByName(bundleInfo.getSymbolicName()) != null) continue;
            String symbolicName = bundleInfo.getSymbolicName();
            try {
                Bundle bundle = target.getBundle(symbolicName);
                bundle.uninstall();
                this.addRollback(new InstallBundleRunnable(bundle, target.getBundleStream(symbolicName), log));
                continue;
            }
            catch (BundleException be) {
                log.log(2, "Bundle '" + symbolicName + "' could not be uninstalled", (Throwable)be);
                continue;
            }
            catch (IOException e) {
                log.log(2, "Could not get bundle data stream for bundle '" + symbolicName + "'", (Throwable)e);
                throw new DeploymentException(463, "Could not prepare rollback for uninstalling bundle '" + symbolicName + "'");
            }
        }
    }

    private static class InstallBundleRunnable
    implements Runnable {
        private final InputStream m_bundleStream;
        private final Bundle m_bundle;
        private final LogService m_log;

        public InstallBundleRunnable(Bundle bundle, InputStream bundleStream, LogService log) {
            this.m_bundle = bundle;
            this.m_bundleStream = bundleStream;
            this.m_log = log;
        }

        public void run() {
            try {
                this.m_bundle.update(this.m_bundleStream);
            }
            catch (BundleException e) {
                this.m_log.log(2, "Could not rollback uninstallation of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
            }
        }
    }
}

