/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;

public abstract class Command {
    private final List m_rollback = new ArrayList();
    private final List m_commit = new ArrayList();
    private volatile boolean m_cancelled;

    public final void execute(DeploymentSessionImpl session) throws DeploymentException {
        try {
            this.doExecute(session);
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(463, "Command failed!", e);
        }
    }

    protected abstract void doExecute(DeploymentSessionImpl var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(DeploymentSessionImpl session) {
        try {
            ListIterator i = this.m_rollback.listIterator(this.m_rollback.size());
            while (i.hasPrevious()) {
                Runnable runnable = (Runnable)i.previous();
                runnable.run();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commit(DeploymentSessionImpl session) {
        try {
            ListIterator i = this.m_commit.listIterator();
            while (i.hasNext()) {
                Runnable runnable = (Runnable)i.next();
                runnable.run();
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.m_rollback.clear();
        this.m_commit.clear();
        this.m_cancelled = false;
    }

    protected boolean isCancelled() {
        return this.m_cancelled;
    }

    protected void addRollback(AbstractAction runnable) {
        this.m_rollback.add(runnable);
    }

    protected void addCommit(AbstractAction runnable) {
        this.m_commit.add(runnable);
    }

    public void cancel() {
        this.m_cancelled = true;
    }

    static final boolean isFragmentBundle(Bundle bundle) {
        Object fragmentHost = bundle.getHeaders().get("Fragment-Host");
        return fragmentHost != null;
    }

    static final void closeSilently(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

