/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class StartBundleCommand
extends Command {
    private final RefreshPackagesMonitor m_refreshMonitor = new RefreshPackagesMonitor();

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        PackageAdmin packageAdmin = session.getPackageAdmin();
        RefreshPackagesListener listener = new RefreshPackagesListener();
        LogService log = session.getLog();
        session.getBundleContext().addFrameworkListener((FrameworkListener)listener);
        packageAdmin.refreshPackages(null);
        this.m_refreshMonitor.waitForRefresh();
        session.getBundleContext().removeFrameworkListener((FrameworkListener)listener);
        BundleInfoImpl[] bundleInfos = source.getOrderedBundleInfos();
        for (int i = 0; i < bundleInfos.length; ++i) {
            BundleInfoImpl bundleInfoImpl = bundleInfos[i];
            if (bundleInfoImpl.isCustomizer()) continue;
            String symbolicName = bundleInfoImpl.getSymbolicName();
            Bundle bundle = source.getBundle(symbolicName);
            if (bundle != null) {
                if (StartBundleCommand.isFragmentBundle(bundle)) {
                    log.log(3, "Skipping fragment bundle '" + symbolicName + "'");
                    continue;
                }
                try {
                    bundle.start();
                }
                catch (Exception be) {
                    log.log(2, "Could not start bundle '" + symbolicName + "'", (Throwable)be);
                }
                continue;
            }
            log.log(2, "Could not start bundle '" + symbolicName + "' because it is not present in the framework");
        }
    }

    private static class RefreshPackagesMonitor {
        private static final int REFRESH_TIMEOUT = 10000;
        private volatile boolean m_alreadyNotified = false;

        private RefreshPackagesMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void waitForRefresh() {
            if (!this.m_alreadyNotified) {
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.m_alreadyNotified = false;
                }
            } else {
                this.m_alreadyNotified = false;
            }
        }

        public synchronized void proceed() {
            this.m_alreadyNotified = true;
            this.notifyAll();
        }
    }

    private class RefreshPackagesListener
    implements FrameworkListener {
        private RefreshPackagesListener() {
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 4) {
                StartBundleCommand.this.m_refreshMonitor.proceed();
            }
        }
    }
}

