/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;

public class StartCustomizerCommand
extends Command {
    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        Bundle bundle;
        int i;
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        HashSet<String> sourceBundlePaths = new HashSet<String>();
        BundleInfoImpl[] targetInfos = target.getBundleInfoImpls();
        BundleInfoImpl[] sourceInfos = source.getBundleInfoImpls();
        for (i = 0; i < sourceInfos.length; ++i) {
            if (!sourceInfos[i].isCustomizer()) continue;
            sourceBundlePaths.add(sourceInfos[i].getPath());
            bundle = source.getBundle(sourceInfos[i].getSymbolicName());
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        for (i = 0; i < targetInfos.length; ++i) {
            if (!targetInfos[i].isCustomizer() || sourceBundlePaths.contains(targetInfos[i].getPath()) || (bundle = target.getBundle(targetInfos[i].getSymbolicName())) == null) continue;
            bundles.add(bundle);
        }
        Iterator i2 = bundles.iterator();
        while (i2.hasNext()) {
            bundle = (Bundle)i2.next();
            try {
                bundle.start();
            }
            catch (Exception be) {
                throw new DeploymentException(463, "Could not start customizer bundle '" + bundle.getSymbolicName() + "'", be);
            }
            this.addRollback(new StopCustomizerRunnable(session, bundle));
        }
    }

    private static class StopCustomizerRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final Bundle m_bundle;

        public StopCustomizerRunnable(DeploymentSessionImpl session, Bundle bundle) {
            this.m_session = session;
            this.m_bundle = bundle;
        }

        protected void doRun() throws Exception {
            this.m_bundle.stop();
        }

        protected void onFailure(Exception e) {
            this.m_session.getLog().log(2, "Failed to stop bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
        }
    }
}

