/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.DeploymentPackageManifest;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public abstract class AbstractDeploymentPackage
implements DeploymentPackage {
    protected static final AbstractDeploymentPackage EMPTY_PACKAGE = new EmptyDeploymentPackage();
    private final BundleContext m_bundleContext;
    private final DeploymentAdminImpl m_deploymentAdmin;
    private final DeploymentPackageManifest m_manifest;
    private final Map m_nameToBundleInfo = new HashMap();
    private final Map m_pathToEntry = new HashMap();
    private final BundleInfoImpl[] m_bundleInfos;
    private final ResourceInfoImpl[] m_resourceInfos;
    private final String[] m_resourcePaths;
    private final boolean m_isFixPackage;
    private boolean m_isStale;
    static /* synthetic */ Class class$org$osgi$service$deploymentadmin$spi$ResourceProcessor;

    private AbstractDeploymentPackage() {
        this.m_bundleContext = null;
        this.m_manifest = null;
        this.m_bundleInfos = null;
        this.m_resourceInfos = null;
        this.m_resourcePaths = null;
        this.m_isFixPackage = false;
        this.m_deploymentAdmin = null;
    }

    public AbstractDeploymentPackage(Manifest manifest, BundleContext bundleContext, DeploymentAdminImpl deploymentAdmin) throws DeploymentException {
        String path;
        this.m_manifest = new DeploymentPackageManifest(manifest);
        this.m_isFixPackage = this.m_manifest.getFixPackage() != null;
        this.m_bundleContext = bundleContext;
        this.m_deploymentAdmin = deploymentAdmin;
        List bundleInfos = this.m_manifest.getBundleInfos();
        this.m_bundleInfos = bundleInfos.toArray(new BundleInfoImpl[bundleInfos.size()]);
        for (int i = 0; i < this.m_bundleInfos.length; ++i) {
            String bsn = this.m_bundleInfos[i].getSymbolicName();
            if (this.m_nameToBundleInfo.put(bsn, this.m_bundleInfos[i]) != null) {
                throw new DeploymentException(463, "Duplicate bundle present in deployment package: " + bsn);
            }
            path = this.m_bundleInfos[i].getPath();
            if (this.m_pathToEntry.put(path, this.m_bundleInfos[i]) == null) continue;
            throw new DeploymentException(463, "Non-unique path present in deployment package: " + path);
        }
        List resourceInfos = this.m_manifest.getResourceInfos();
        this.m_resourceInfos = resourceInfos.toArray(new ResourceInfoImpl[resourceInfos.size()]);
        for (int i = 0; i < this.m_resourceInfos.length; ++i) {
            path = this.m_resourceInfos[i].getPath();
            if (this.m_pathToEntry.put(path, this.m_resourceInfos[i]) == null) continue;
            throw new DeploymentException(463, "Non-unique path present in deployment package: " + path);
        }
        this.m_resourcePaths = this.m_pathToEntry.keySet().toArray(new String[this.m_pathToEntry.size()]);
    }

    public Bundle getBundle(String symbolicName) {
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        BundleInfo bundleInfo = (BundleInfo)this.m_nameToBundleInfo.get(symbolicName);
        if (bundleInfo != null) {
            Version version = bundleInfo.getVersion();
            Bundle[] bundles = this.m_bundleContext.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (!symbolicName.equals(bundles[i].getSymbolicName()) || !version.equals((Object)bundles[i].getVersion())) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public BundleInfo[] getBundleInfos() {
        return (BundleInfo[])this.m_bundleInfos.clone();
    }

    public BundleInfoImpl[] getBundleInfoImpls() {
        return (BundleInfoImpl[])this.m_bundleInfos.clone();
    }

    public ResourceInfoImpl[] getResourceInfos() {
        return (ResourceInfoImpl[])this.m_resourceInfos.clone();
    }

    public boolean isFixPackage() {
        return this.m_isFixPackage;
    }

    public String getHeader(String header) {
        return this.m_manifest.getHeader(header);
    }

    public String getName() {
        return this.m_manifest.getSymbolicName();
    }

    public String getDisplayName() {
        return this.getHeader("DeploymentPackage-Name");
    }

    public URL getIcon() {
        String icon = this.getHeader("DeploymentPackage-Icon");
        if (icon == null) {
            return null;
        }
        try {
            return new URL(icon);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getResourceHeader(String resource, String header) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(resource);
        if (info != null) {
            return info.getHeader(header);
        }
        return null;
    }

    public ServiceReference getResourceProcessor(String resource) {
        String processor;
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(resource);
        if (info instanceof ResourceInfoImpl && (processor = ((ResourceInfoImpl)info).getResourceProcessor()) != null) {
            try {
                ServiceReference[] services = this.m_bundleContext.getServiceReferences((class$org$osgi$service$deploymentadmin$spi$ResourceProcessor == null ? (class$org$osgi$service$deploymentadmin$spi$ResourceProcessor = AbstractDeploymentPackage.class$("org.osgi.service.deploymentadmin.spi.ResourceProcessor")) : class$org$osgi$service$deploymentadmin$spi$ResourceProcessor).getName(), "(service.pid=" + processor + ")");
                if (services != null && services.length > 0) {
                    return services[0];
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public String[] getResources() {
        return (String[])this.m_resourcePaths.clone();
    }

    public Version getVersion() {
        return this.m_manifest.getVersion();
    }

    public VersionRange getVersionRange() {
        return this.m_manifest.getFixPackage();
    }

    public boolean isStale() {
        return this.m_isStale;
    }

    public boolean isNew() {
        return this == EMPTY_PACKAGE;
    }

    public void setStale(boolean isStale) {
        this.m_isStale = isStale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws DeploymentException {
        if (this.isStale()) {
            throw new IllegalStateException("Deployment package is stale, cannot uninstall.");
        }
        try {
            this.m_deploymentAdmin.uninstallDeploymentPackage(this, false);
        }
        finally {
            this.setStale(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninstallForced() throws DeploymentException {
        if (this.isStale()) {
            throw new IllegalStateException("Deployment package is stale, cannot uninstall.");
        }
        try {
            this.m_deploymentAdmin.uninstallDeploymentPackage(this, true);
        }
        finally {
            this.setStale(true);
        }
        return true;
    }

    public abstract BundleInfoImpl[] getOrderedBundleInfos();

    public abstract ResourceInfoImpl[] getOrderedResourceInfos();

    public ResourceInfoImpl getResourceInfoByPath(String path) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(path);
        if (info instanceof ResourceInfoImpl) {
            return (ResourceInfoImpl)info;
        }
        return null;
    }

    protected AbstractInfo getAbstractInfoByPath(String path) {
        return (AbstractInfo)this.m_pathToEntry.get(path);
    }

    public BundleInfoImpl getBundleInfoByPath(String path) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(path);
        if (info instanceof BundleInfoImpl) {
            return (BundleInfoImpl)info;
        }
        return null;
    }

    public BundleInfoImpl getBundleInfoByName(String symbolicName) {
        return (BundleInfoImpl)this.m_nameToBundleInfo.get(symbolicName);
    }

    public abstract InputStream getBundleStream(String var1) throws IOException;

    public abstract AbstractInfo getNextEntry() throws IOException;

    public abstract InputStream getCurrentEntryStream();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class EmptyDeploymentPackage
    extends AbstractDeploymentPackage {
        private static final String[] STRINGS = new String[0];
        private static final ResourceInfoImpl[] RESOURCE_INFO_IMPLS = new ResourceInfoImpl[0];
        private static final BundleInfoImpl[] BUNDLE_INFO_IMPLS = new BundleInfoImpl[0];

        private EmptyDeploymentPackage() {
        }

        public String getHeader(String header) {
            if ("DeploymentPackage-SymbolicName".equals(header)) {
                return "";
            }
            if ("DeploymentPackage-Version".equals(header)) {
                return Version.emptyVersion.toString();
            }
            return null;
        }

        public Bundle getBundle(String symbolicName) {
            return null;
        }

        public BundleInfo[] getBundleInfos() {
            return BUNDLE_INFO_IMPLS;
        }

        public BundleInfoImpl[] getBundleInfoImpls() {
            return BUNDLE_INFO_IMPLS;
        }

        public ResourceInfoImpl[] getResourceInfos() {
            return RESOURCE_INFO_IMPLS;
        }

        public String getName() {
            return "";
        }

        public String getResourceHeader(String resource, String header) {
            return null;
        }

        public ServiceReference getResourceProcessor(String resource) {
            return null;
        }

        public String[] getResources() {
            return STRINGS;
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public boolean isStale() {
            return true;
        }

        public void uninstall() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }

        public boolean uninstallForced() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }

        public InputStream getBundleStream(String symbolicName) throws IOException {
            return null;
        }

        public BundleInfoImpl[] getOrderedBundleInfos() {
            return BUNDLE_INFO_IMPLS;
        }

        public ResourceInfoImpl[] getOrderedResourceInfos() {
            return RESOURCE_INFO_IMPLS;
        }

        public InputStream getCurrentEntryStream() {
            throw new UnsupportedOperationException();
        }

        public AbstractInfo getNextEntry() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getDisplayName() {
            return "";
        }

        public URL getIcon() {
            return null;
        }
    }
}

