/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class CommitResourceCommand
extends Command {
    private final List m_processors = new ArrayList();

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        ResourceProcessor processor;
        ListIterator i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            processor = (ResourceProcessor)i.previous();
            try {
                processor.prepare();
            }
            catch (ResourceProcessorException e) {
                session.getLog().log(1, "Preparing commit for resource processor failed", (Throwable)e);
                if (e.getCode() == 1) {
                    throw new DeploymentException(462, "Preparing commit for resource processor failed!", e);
                }
                throw new DeploymentException(e.getCode(), "Preparing commit for resource processor failed!", e);
            }
            catch (Exception e) {
                session.getLog().log(1, "Preparing commit for resource processor failed", (Throwable)e);
                throw new DeploymentException(463, "Preparing commit for resource processor failed", e);
            }
        }
        i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            processor = (ResourceProcessor)i.previous();
            try {
                processor.commit();
            }
            catch (Exception e) {
                session.getLog().log(1, "Committing resource processor '" + processor + "' failed", (Throwable)e);
            }
        }
        this.m_processors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(DeploymentSessionImpl session) {
        ListIterator i = this.m_processors.listIterator(this.m_processors.size());
        while (i.hasPrevious()) {
            ResourceProcessor processor = (ResourceProcessor)i.previous();
            try {
                processor.rollback();
            }
            catch (Exception e) {
                session.getLog().log(1, "Rollback of resource processor '" + processor + "' failed", (Throwable)e);
            }
            finally {
                i.remove();
            }
        }
    }

    public boolean addResourceProcessor(ResourceProcessor processor) {
        Iterator i = this.m_processors.iterator();
        while (i.hasNext()) {
            ResourceProcessor proc = (ResourceProcessor)i.next();
            if (proc != processor) continue;
            return false;
        }
        this.m_processors.add(processor);
        return true;
    }
}

