/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.InputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class DropBundleCommand
extends Command {
    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        LogService log = session.getLog();
        BundleInfoImpl[] orderedTargetBundles = target.getOrderedBundleInfos();
        for (int i = orderedTargetBundles.length - 1; i >= 0; --i) {
            BundleInfoImpl bundleInfo = orderedTargetBundles[i];
            String symbolicName = bundleInfo.getSymbolicName();
            if (bundleInfo.isCustomizer() || source.getBundleInfoByName(symbolicName) != null) continue;
            try {
                Bundle bundle = target.getBundle(symbolicName);
                bundle.uninstall();
                this.addRollback(new InstallBundleRunnable(bundle, target, log));
                continue;
            }
            catch (Exception be) {
                log.log(2, "Bundle '" + symbolicName + "' could not be uninstalled", (Throwable)be);
            }
        }
    }

    private static class InstallBundleRunnable
    extends AbstractAction {
        private final AbstractDeploymentPackage m_target;
        private final Bundle m_bundle;
        private final LogService m_log;

        public InstallBundleRunnable(Bundle bundle, AbstractDeploymentPackage target, LogService log) {
            this.m_bundle = bundle;
            this.m_target = target;
            this.m_log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            InputStream is = null;
            try {
                is = this.m_target.getBundleStream(this.m_bundle.getSymbolicName());
                if (is == null) {
                    throw new RuntimeException("Unable to get Inputstream for bundle '" + this.m_bundle.getSymbolicName() + "'");
                }
                this.m_bundle.update(is);
            }
            catch (Throwable throwable) {
                Command.closeSilently(is);
                throw throwable;
            }
            Command.closeSilently(is);
        }

        protected void onFailure(Exception e) {
            this.m_log.log(2, "Could not rollback uninstallation of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
        }
    }
}

