/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.log.LogService;

public class DropResourceCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public DropResourceCommand(CommitResourceCommand commitCommand) {
        this.m_commitCommand = commitCommand;
    }

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        this.addRollback(new RollbackCommitAction(session));
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        LogService log = session.getLog();
        ResourceInfoImpl[] orderedTargetResources = target.getOrderedResourceInfos();
        for (int i = orderedTargetResources.length - 1; i >= 0; --i) {
            ResourceProcessor resourceProcessor;
            ServiceReference ref;
            ResourceInfoImpl resourceInfo = orderedTargetResources[i];
            String path = resourceInfo.getPath();
            if (source.getResourceInfoByPath(path) != null || (ref = target.getResourceProcessor(path)) == null || (resourceProcessor = (ResourceProcessor)context.getService(ref)) == null) continue;
            try {
                if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                    resourceProcessor.begin(session);
                }
                resourceProcessor.dropped(path);
                continue;
            }
            catch (Exception e) {
                log.log(2, "Not allowed to drop resource '" + path + "'", (Throwable)e);
            }
        }
    }

    private class RollbackCommitAction
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl session) {
            this.m_session = session;
        }

        protected void doRun() {
            DropResourceCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

