/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class SnapshotCommand
extends Command {
    private final GetStorageAreaCommand m_getStorageAreaCommand;

    public SnapshotCommand(GetStorageAreaCommand getStorageAreaCommand) {
        this.m_getStorageAreaCommand = getStorageAreaCommand;
    }

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        BundleInfo[] infos = target.getBundleInfos();
        Map storageAreas = this.m_getStorageAreaCommand.getStorageAreas();
        for (int i = 0; i < infos.length; ++i) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            String symbolicName = infos[i].getSymbolicName();
            Bundle bundle = target.getBundle(symbolicName);
            if (bundle == null) continue;
            File root = (File)storageAreas.get(symbolicName);
            if (root != null) {
                File snapshot = context.getDataFile("snapshots");
                snapshot.mkdirs();
                snapshot = new File(snapshot, infos[i].getSymbolicName());
                try {
                    snapshot.createNewFile();
                    this.store(root, snapshot);
                    this.addRollback(new RestoreSnapshotRunnable(session, snapshot, root));
                    this.addCommit(new DeleteSnapshotRunnable(session, snapshot));
                }
                catch (Exception e) {
                    session.getLog().log(2, "Could not access storage area of bundle '" + symbolicName + "'!", (Throwable)e);
                    snapshot.delete();
                }
                continue;
            }
            session.getLog().log(2, "Could not retrieve storage area of bundle '" + symbolicName + "', skipping it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(File source, File target) throws IOException {
        ZipOutputStream output = null;
        try {
            File[] children = source.listFiles();
            output = new ZipOutputStream(new FileOutputStream(target));
            for (int i = 0; i < children.length; ++i) {
                this.storeRecursive(source, new File(children[i].getName()), output);
            }
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(output);
            throw throwable;
        }
        SnapshotCommand.closeSilently(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeRecursive(File current, File path, ZipOutputStream output) throws IOException {
        output.putNextEntry(new ZipEntry(path.getPath()));
        if (current.isDirectory()) {
            output.closeEntry();
            File[] childs = current.listFiles();
            int i = 0;
            while (i < childs.length) {
                this.storeRecursive(childs[i], new File(path, childs[i].getName()), output);
                ++i;
            }
            return;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(current);
            byte[] buffer = new byte[4096];
            int i = ((InputStream)input).read(buffer);
            while (i != -1) {
                output.write(buffer, 0, i);
                i = ((InputStream)input).read(buffer);
            }
            output.closeEntry();
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(input);
            throw throwable;
        }
        SnapshotCommand.closeSilently(input);
    }

    private static class RestoreSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;
        private final File m_root;

        private RestoreSnapshotRunnable(DeploymentSessionImpl session, File snapshot, File root) {
            this.m_session = session;
            this.m_snapshot = snapshot;
            this.m_root = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            try {
                this.delete(this.m_root, false);
                this.unpack(this.m_snapshot, this.m_root);
            }
            finally {
                this.m_snapshot.delete();
            }
        }

        protected void onFailure(Exception e) {
            this.m_session.getLog().log(2, "Failed to restore snapshot!", (Throwable)e);
        }

        private void delete(File root, boolean deleteRoot) {
            if (root.isDirectory()) {
                File[] childs = root.listFiles();
                for (int i = 0; i < childs.length; ++i) {
                    this.delete(childs[i], true);
                }
            }
            if (deleteRoot) {
                root.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void unpack(File source, File target) throws IOException {
            ZipInputStream input = null;
            try {
                input = new ZipInputStream(new FileInputStream(source));
                ZipEntry entry = input.getNextEntry();
                while (entry != null) {
                    if (entry.isDirectory()) {
                        new File(target, entry.getName()).mkdirs();
                    } else {
                        FileOutputStream output = null;
                        try {
                            output = new FileOutputStream(target);
                            byte[] buffer = new byte[4096];
                            int i = input.read(buffer);
                            while (i > -1) {
                                ((OutputStream)output).write(buffer, 0, i);
                                i = input.read(buffer);
                            }
                        }
                        catch (Throwable throwable) {
                            Command.closeSilently(output);
                            throw throwable;
                        }
                        Command.closeSilently(output);
                    }
                    input.closeEntry();
                    entry = input.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                Command.closeSilently(input);
                throw throwable;
            }
            Command.closeSilently(input);
        }
    }

    private static class DeleteSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;

        private DeleteSnapshotRunnable(DeploymentSessionImpl session, File snapshot) {
            this.m_session = session;
            this.m_snapshot = snapshot;
        }

        protected void doRun() {
            if (!this.m_snapshot.delete()) {
                this.m_session.getLog().log(2, "Failed to delete snapshot in " + this.m_snapshot + "!");
            }
        }
    }
}

