/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import org.apache.felix.eventadmin.impl.dispatch.Scheduler;
import org.apache.felix.eventadmin.impl.dispatch.TaskProducer;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.tasks.HandoverTask;

public class DispatchTask
implements Runnable {
    private static final Scheduler NULL_SCHEDULER = new Scheduler(){

        public void schedule(Runnable task) {
        }

        public void schedule(Runnable task, int nice) {
        }
    };
    private static final TaskProducer NULL_PRODUCER = new TaskProducer(){

        public HandlerTask next() {
            return null;
        }
    };
    private static final HandoverTask NULL_HANDOVER = new HandoverTask(){

        public void execute(DispatchTask task) {
        }
    };
    final Object m_lock = new Object();
    private volatile TaskProducer m_producer;
    private Scheduler m_scheduler;
    private HandoverTask m_handover;
    private BlackListTask m_blackListTask = null;
    private boolean m_isHolding = false;

    public DispatchTask(TaskProducer producer, Scheduler scheduler, HandoverTask handover) {
        this.m_producer = producer;
        this.m_scheduler = scheduler;
        this.m_handover = handover;
    }

    private DispatchTask(DispatchTask old) {
        this(old.m_producer, old.m_scheduler, old.m_handover);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HandlerTask manager = this.m_producer.next();
        while (null != manager) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_blackListTask = new BlackListTask(manager);
                this.m_scheduler.schedule(this.m_blackListTask);
            }
            manager.execute();
            object = this.m_lock;
            synchronized (object) {
                this.m_blackListTask.cancel();
            }
            manager = this.m_producer.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handover() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_blackListTask.cancel();
            this.m_handover.execute(new DispatchTask(this));
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_blackListTask.cancel();
            this.m_handover = NULL_HANDOVER;
            this.m_producer = NULL_PRODUCER;
            this.m_scheduler = NULL_SCHEDULER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_blackListTask.cancel();
            int pastTime = (int)(System.currentTimeMillis() - this.m_blackListTask.getTime());
            this.m_handover.execute(new DispatchTask(this));
            this.m_isHolding = true;
            while (this.m_isHolding) {
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_blackListTask = new BlackListTask(this.m_blackListTask, System.currentTimeMillis() - (long)pastTime);
            this.m_scheduler.schedule(this.m_blackListTask, pastTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_isHolding = false;
            this.m_lock.notifyAll();
        }
    }

    private class BlackListTask
    implements Runnable {
        private boolean m_canceled = false;
        private final long m_time;
        private final HandlerTask m_manager;

        BlackListTask(HandlerTask manager) {
            this(manager, System.currentTimeMillis());
        }

        BlackListTask(HandlerTask manager, long time) {
            this.m_manager = manager;
            this.m_time = time;
        }

        BlackListTask(BlackListTask old, long time) {
            this(old.m_manager, time);
        }

        public long getTime() {
            return this.m_time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = DispatchTask.this.m_lock;
            synchronized (object) {
                if (!this.m_canceled) {
                    this.m_manager.blackListHandler();
                    DispatchTask.this.handover();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = DispatchTask.this.m_lock;
            synchronized (object) {
                this.m_canceled = true;
            }
        }
    }
}

