/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.feature.FeatureBundle;
import org.osgi.service.feature.FeatureBundleBuilder;
import org.osgi.service.feature.ID;

class BundleBuilderImpl
implements FeatureBundleBuilder {
    private final ID id;
    private final Map<String, Object> metadata = new LinkedHashMap<String, Object>();

    BundleBuilderImpl(ID id) {
        this.id = id;
    }

    public FeatureBundleBuilder addMetadata(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Metadata key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Metadata value cannot be null");
        }
        if ("id".equalsIgnoreCase(key)) {
            throw new IllegalArgumentException("Key cannot be 'id'");
        }
        this.checkMetadataValue(value);
        this.metadata.put(key, value);
        return this;
    }

    public FeatureBundleBuilder addMetadata(Map<String, Object> md) {
        if (md.keySet().contains(null)) {
            throw new IllegalArgumentException("Metadata key cannot be null");
        }
        if (md.values().contains(null)) {
            throw new IllegalArgumentException("Metadata value cannot be null");
        }
        if (md.keySet().stream().map(String::toLowerCase).anyMatch(s -> "id".equals(s))) {
            throw new IllegalArgumentException("Key cannot be 'id'");
        }
        md.values().stream().forEach(this::checkMetadataValue);
        this.metadata.putAll(md);
        return this;
    }

    private void checkMetadataValue(Object value) {
        if (value instanceof String) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Number) {
            return;
        }
        throw new IllegalArgumentException("Illegal metadata value: " + value);
    }

    public FeatureBundle build() {
        return new BundleImpl(this.id, this.metadata);
    }

    private static class BundleImpl
    implements FeatureBundle {
        private final ID id;
        private final Map<String, Object> metadata;

        private BundleImpl(ID id, Map<String, Object> metadata) {
            this.id = id;
            this.metadata = Collections.unmodifiableMap(metadata);
        }

        public ID getID() {
            return this.id;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.metadata);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BundleImpl other = (BundleImpl)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.metadata, other.metadata);
        }

        public String toString() {
            return "BundleImpl [getID()=" + this.getID() + "]";
        }
    }
}

