/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.framework.Bundle;

class Jar {
    private String path;
    private long length = -1L;
    private long lastModified = -1L;
    private long bundleId = -1L;

    Jar(File file) {
        this.path = file.toURI().normalize().getPath();
        this.lastModified = file.lastModified();
        this.length = file.length();
    }

    Jar(Bundle b) throws URISyntaxException {
        URI uri = new URI(b.getLocation()).normalize();
        this.path = uri.getPath();
        this.lastModified = b.getLastModified();
        this.bundleId = b.getBundleId();
    }

    public String getPath() {
        return this.path;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public boolean isNewer(Jar other) {
        return this.getLastModified() > other.getLastModified();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jar) {
            return this.path.equals(((Jar)obj).path);
        }
        return false;
    }
}

