/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.fileinstall.FileInstall;
import org.apache.felix.fileinstall.Jar;
import org.apache.felix.fileinstall.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class DirectoryWatcher
extends Thread {
    public static final String FILENAME = "felix.fileinstall.filename";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String DEBUG = "felix.fileinstall.debug";
    public static final String START_NEW_BUNDLES = "felix.fileinstall.bundles.new.start";
    File watchedDirectory;
    long poll = 2000L;
    long debug;
    boolean startBundles = true;
    BundleContext context;
    boolean reported;
    String originatingFileName;
    Map currentManagedBundles = new HashMap();
    Map installationFailures = new HashMap();
    Set startupFailures = new HashSet();
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        super(properties.toString());
        this.context = context;
        this.poll = this.getLong(properties, POLL, this.poll);
        this.debug = this.getLong(properties, DEBUG, -1L);
        this.originatingFileName = (String)properties.get(FILENAME);
        String dir = (String)properties.get(DIR);
        if (dir == null) {
            dir = "./load";
        }
        this.watchedDirectory = new File(dir);
        this.prepareWatchedDir(this.watchedDirectory);
        Object value = properties.get(START_NEW_BUNDLES);
        if (value != null) {
            this.startBundles = "true".equalsIgnoreCase((String)value);
        }
    }

    public void run() {
        this.log("felix.fileinstall.poll  (ms)   " + this.poll, null);
        this.log("felix.fileinstall.dir            " + this.watchedDirectory.getAbsolutePath(), null);
        this.log("felix.fileinstall.debug          " + this.debug, null);
        this.log("felix.fileinstall.bundles.new.start          " + this.startBundles, null);
        this.initializeCurrentManagedBundles();
        HashMap currentManagedConfigs = new HashMap();
        while (!DirectoryWatcher.interrupted()) {
            try {
                HashMap installed = new HashMap();
                HashSet configs = new HashSet();
                this.traverse(installed, configs, this.watchedDirectory);
                this.doInstalled(installed);
                this.doConfigs(currentManagedConfigs, configs);
                Thread.sleep(this.poll);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                this.log("In main loop, we have serious trouble", e);
            }
        }
    }

    private void prepareWatchedDir(File watchedDirectory) {
        if (!watchedDirectory.exists() && !watchedDirectory.mkdirs()) {
            this.log("Cannot create folder " + watchedDirectory + ". Is the folder write-protected?", null);
            throw new RuntimeException("Cannot create folder: " + watchedDirectory);
        }
        if (!watchedDirectory.isDirectory()) {
            this.log("Cannot watch " + watchedDirectory + " because it's not a directory", null);
            throw new RuntimeException("Cannot start FileInstall to watch something that is not a directory");
        }
    }

    void doConfigs(Map current, Set discovered) {
        try {
            File f;
            String path;
            HashSet inactive = new HashSet(current.keySet());
            Iterator e = discovered.iterator();
            while (e.hasNext()) {
                path = (String)e.next();
                f = new File(path);
                if (!current.containsKey(path)) {
                    Long l = new Long(f.lastModified());
                    if (this.setConfig(f)) {
                        current.put(path, l);
                    }
                } else {
                    long lastModified = f.lastModified();
                    long oldTime = (Long)current.get(path);
                    if (oldTime < lastModified && this.setConfig(f)) {
                        current.put(path, new Long(lastModified));
                    }
                }
                inactive.remove(path);
            }
            e = inactive.iterator();
            while (e.hasNext()) {
                path = (String)e.next();
                f = new File(path);
                if (!this.deleteConfig(f)) continue;
                current.remove(path);
            }
        }
        catch (Exception ee) {
            this.log("Processing config: ", ee);
        }
    }

    boolean setConfig(File f) throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)FileInstall.cmTracker.getService();
        if (cm == null) {
            if (this.debug != 0L && !this.reported) {
                this.log("Can't find a Configuration Manager, configurations do not work", null);
                this.reported = true;
            }
            return false;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(f);
        p.load(in);
        ((InputStream)in).close();
        String[] pid = this.parsePid(f.getName());
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ht.putAll(p);
        ht.put(FILENAME, f.getName());
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        if (config.getBundleLocation() != null) {
            config.setBundleLocation(null);
        }
        config.update(ht);
        return true;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(pid[0], pid[1]);
        config.delete();
        return true;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - 4);
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(pid, factoryPid);
        if (oldConfiguration != null) {
            this.log("Updating configuration from " + pid + (factoryPid == null ? "" : "-" + factoryPid) + ".cfg", null);
            return oldConfiguration;
        }
        ConfigurationAdmin cm = (ConfigurationAdmin)FileInstall.cmTracker.getService();
        Configuration newConfiguration = null;
        newConfiguration = factoryPid != null ? cm.createFactoryConfiguration(pid, null) : cm.getConfiguration(pid, null);
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String pid, String factoryPid) throws Exception {
        String filter;
        String suffix = factoryPid == null ? ".cfg" : "-" + factoryPid + ".cfg";
        ConfigurationAdmin cm = (ConfigurationAdmin)FileInstall.cmTracker.getService();
        Configuration[] configurations = cm.listConfigurations(filter = "(felix.fileinstall.filename=" + pid + suffix + ")");
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    void doInstalled(Map discovered) {
        HashSet newBundles = new HashSet(discovered.values());
        newBundles.removeAll(this.currentManagedBundles.values());
        HashSet deletedBundles = new HashSet(this.currentManagedBundles.values());
        deletedBundles.removeAll(discovered.values());
        HashSet existingBundles = new HashSet(discovered.values());
        existingBundles.retainAll(this.currentManagedBundles.values());
        Collection uninstalledBundles = this.uninstall(deletedBundles);
        Collection updatedBundles = this.update(existingBundles);
        Collection installedBundles = this.install(newBundles);
        if (uninstalledBundles.size() > 0 || updatedBundles.size() > 0) {
            this.refresh();
        }
        this.start(new HashSet(this.startupFailures));
        if (this.startBundles && (uninstalledBundles.size() > 0 || updatedBundles.size() > 0 || installedBundles.size() > 0)) {
            this.startAllBundles();
        }
    }

    void log(String message, Throwable e) {
        LogService log = this.getLogService();
        if (log == null) {
            System.out.println(message + (e == null ? "" : ": " + e));
            if (this.debug > 0L && e != null) {
                e.printStackTrace(System.out);
            }
        } else if (e != null) {
            log.log(1, message, e);
            if (this.debug > 0L && e != null) {
                e.printStackTrace();
            }
        } else {
            log.log(3, message);
        }
    }

    LogService getLogService() {
        ServiceReference ref = this.context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = DirectoryWatcher.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        if (ref != null) {
            LogService log = (LogService)this.context.getService(ref);
            return log;
        }
        return null;
    }

    void traverse(Map jars, Set configs, File jardir) {
        String[] list = jardir.list();
        if (list == null) {
            this.prepareWatchedDir(jardir);
            list = jardir.list();
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            File file = new File(jardir, list[i]);
            if (list[i].endsWith(".cfg")) {
                configs.add(file.getAbsolutePath());
                continue;
            }
            if (!Util.isValidJar(file.getAbsolutePath())) continue;
            Jar jar = new Jar(file);
            jars.put(jar.getPath(), jar);
        }
    }

    boolean isFragment(Bundle bundle) {
        if (FileInstall.padmin == null) {
            return false;
        }
        try {
            PackageAdmin padmin = (PackageAdmin)FileInstall.padmin.waitForService(10000L);
            if (padmin != null) {
                return padmin.getBundleType(bundle) == 1;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    void refresh() {
        try {
            PackageAdmin padmin = (PackageAdmin)FileInstall.padmin.waitForService(10000L);
            padmin.refreshPackages(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    long getLong(Dictionary properties, String property, long dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    public void close() {
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.watchedDirectory.toURI().normalize().getPath();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                int index;
                Jar jar = new Jar(bundles[i]);
                String path = jar.getPath();
                if (path == null || (index = path.lastIndexOf(47)) == -1 || !path.substring(0, index + 1).equals(watchedDirPath)) continue;
                this.currentManagedBundles.put(path, jar);
                continue;
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    private Collection install(Collection jars) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = jars.iterator();
        while (iter.hasNext()) {
            Jar jar = (Jar)iter.next();
            Bundle bundle = this.install(jar);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection uninstall(Collection jars) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = jars.iterator();
        while (iter.hasNext()) {
            Jar jar = (Jar)iter.next();
            Bundle b = this.uninstall(jar);
            if (b == null) continue;
            bundles.add(b);
        }
        return bundles;
    }

    private void start(Collection bundles) {
        Iterator b = bundles.iterator();
        while (b.hasNext()) {
            this.start((Bundle)b.next());
        }
    }

    private Collection update(Collection jars) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = jars.iterator();
        while (iter.hasNext()) {
            Bundle b;
            Jar c;
            Jar e = (Jar)iter.next();
            if (!e.isNewer(c = (Jar)this.currentManagedBundles.get(e.getPath())) || (b = this.update(c)) == null) continue;
            bundles.add(b);
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle install(Jar jar) {
        Bundle bundle = null;
        try {
            String path = jar.getPath();
            Jar badJar = (Jar)this.installationFailures.get(jar.getPath());
            if (badJar != null && badJar.getLastModified() == jar.getLastModified()) {
                return null;
            }
            File file = new File(path);
            FileInputStream in = new FileInputStream(file);
            try {
                bundle = this.context.installBundle(path, (InputStream)in);
            }
            finally {
                ((InputStream)in).close();
            }
            this.installationFailures.remove(path);
            this.currentManagedBundles.put(path, new Jar(bundle));
            this.log("Installed " + file.getAbsolutePath(), null);
        }
        catch (Exception e) {
            this.log("Failed to install bundle: " + jar.getPath(), e);
            this.installationFailures.put(jar.getPath(), jar);
        }
        return bundle;
    }

    private Bundle uninstall(Jar jar) {
        try {
            Jar old = (Jar)this.currentManagedBundles.remove(jar.getPath());
            Bundle bundle = this.context.getBundle(old.getBundleId());
            if (bundle == null) {
                this.log("Failed to uninstall bundle: " + jar.getPath() + " with id: " + old.getBundleId() + ". The bundle has already been uninstalled", null);
                return null;
            }
            bundle.uninstall();
            this.startupFailures.remove(bundle);
            this.log("Uninstalled " + jar.getPath(), null);
            return bundle;
        }
        catch (Exception e) {
            this.log("Failed to uninstall bundle: " + jar.getPath(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle update(Jar jar) {
        block16: {
            Bundle bundle;
            InputStream in = null;
            try {
                File file = new File(jar.getPath());
                in = new FileInputStream(file);
                Bundle bundle2 = this.context.getBundle(jar.getBundleId());
                if (bundle2 == null) {
                    this.log("Failed to update bundle: " + jar.getPath() + " with ID " + jar.getBundleId() + ". The bundle has been uninstalled", null);
                    Bundle bundle3 = null;
                    return bundle3;
                }
                bundle2.update(in);
                this.startupFailures.remove(bundle2);
                jar.setLastModified(bundle2.getLastModified());
                jar.setLength(file.length());
                this.log("Updated " + jar.getPath(), null);
                bundle = bundle2;
            }
            catch (Exception e) {
                this.log("Failed to update bundle " + jar.getPath(), e);
                break block16;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bundle;
        }
        return null;
    }

    private void start(Bundle bundle) {
        if (!this.isFragment(bundle)) {
            try {
                bundle.start();
                this.startupFailures.remove(bundle);
                this.log("Started bundle: " + bundle.getLocation(), null);
            }
            catch (BundleException e) {
                this.log("Error while starting bundle: " + bundle.getLocation(), e);
                this.startupFailures.add(bundle);
            }
        }
    }

    private void startAllBundles() {
        Iterator jars = this.currentManagedBundles.values().iterator();
        while (jars.hasNext()) {
            Jar jar = (Jar)jars.next();
            Bundle bundle = this.context.getBundle(jar.getBundleId());
            this.start(bundle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

