/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Logger
implements ServiceListener {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private int m_logLevel = 1;
    private BundleContext m_context = null;
    private static final int LOGGER_OBJECT_IDX = 0;
    private static final int LOGGER_METHOD_IDX = 1;
    private ServiceReference m_logRef = null;
    private Object[] m_logger = null;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    public final synchronized void setLogLevel(int i) {
        this.m_logLevel = i;
    }

    public final synchronized int getLogLevel() {
        return this.m_logLevel;
    }

    protected void setSystemBundleContext(BundleContext context) {
        this.m_context = context;
        this.startListeningForLogService();
    }

    public final void log(int level, String msg) {
        this._log(null, level, msg, null);
    }

    public final void log(int level, String msg, Throwable throwable) {
        this._log(null, level, msg, throwable);
    }

    public final void log(ServiceReference sr, int level, String msg) {
        this._log(sr, level, msg, null);
    }

    public final void log(ServiceReference sr, int level, String msg, Throwable throwable) {
        this._log(sr, level, msg, throwable);
    }

    protected void doLog(ServiceReference sr, int level, String msg, Throwable throwable) {
        String s = sr == null ? null : "SvcRef " + sr;
        s = s == null ? msg : s + " " + msg;
        s = throwable == null ? s : s + " (" + throwable + ")";
        switch (level) {
            case 4: {
                System.out.println("DEBUG: " + s);
                break;
            }
            case 1: {
                System.out.println("ERROR: " + s);
                if (throwable == null) break;
                if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                    throwable = ((BundleException)throwable).getNestedException();
                }
                throwable.printStackTrace();
                break;
            }
            case 3: {
                System.out.println("INFO: " + s);
                break;
            }
            case 2: {
                System.out.println("WARNING: " + s);
                break;
            }
            default: {
                System.out.println("UNKNOWN[" + level + "]: " + s);
            }
        }
    }

    private void _log(ServiceReference sr, int level, String msg, Throwable throwable) {
        Object[] logger = this.m_logger;
        if (this.m_logLevel >= level) {
            if (logger != null) {
                this._logReflectively(logger, sr, level, msg, throwable);
            } else {
                this.doLog(sr, level, msg, throwable);
            }
        }
    }

    private void _logReflectively(Object[] logger, ServiceReference sr, int level, String msg, Throwable throwable) {
        if (logger != null) {
            Object[] params = new Object[]{sr, new Integer(level), msg, throwable};
            try {
                ((Method)logger[1]).invoke(logger[0], params);
            }
            catch (InvocationTargetException ex) {
                System.err.println("Logger: " + ex);
            }
            catch (IllegalAccessException ex) {
                System.err.println("Logger: " + ex);
            }
        }
    }

    private synchronized void startListeningForLogService() {
        try {
            this.m_context.addServiceListener(this, "(objectClass=org.osgi.service.log.LogService)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.m_logRef = this.m_context.getServiceReference("org.osgi.service.log.LogService");
        if (this.m_logRef != null) {
            this.setLogger(this.m_context.getService(this.m_logRef));
        }
    }

    public final synchronized void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && this.m_logRef == null) {
            this.m_logRef = event.getServiceReference();
            this.setLogger(this.m_context.getService(this.m_logRef));
        } else if (event.getType() == 1 && this.m_logRef != null) {
            ServiceReference ref = this.m_context.getServiceReference("org.osgi.service.log.LogService");
            if (!ref.equals(this.m_logRef)) {
                this.m_context.ungetService(this.m_logRef);
                this.m_logRef = ref;
                this.setLogger(this.m_context.getService(this.m_logRef));
            }
        } else if (event.getType() == 4 && this.m_logRef.equals(event.getServiceReference())) {
            this.m_context.ungetService(this.m_logRef);
            this.m_logRef = this.m_context.getServiceReference("org.osgi.service.log.LogService");
            if (this.m_logRef != null) {
                this.setLogger(this.m_context.getService(this.m_logRef));
            } else {
                this.setLogger(null);
            }
        }
    }

    private void setLogger(Object logObj) {
        if (logObj == null) {
            this.m_logger = null;
        } else {
            Class[] formalParams = new Class[]{class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = Logger.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable};
            try {
                Method logMethod = logObj.getClass().getMethod("log", formalParams);
                logMethod.setAccessible(true);
                this.m_logger = new Object[]{logObj, logMethod};
            }
            catch (NoSuchMethodException ex) {
                System.err.println("Logger: " + ex);
                this.m_logger = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

