/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.moduleloader.ContentDirectoryContent;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.JarContent;
import org.apache.felix.moduleloader.JarFileX;

class JarRevision
extends BundleRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private static final transient String EMBEDDED_DIRECTORY = "embedded";
    private static final transient String LIBRARY_DIRECTORY = "lib";
    private File m_bundleFile = null;
    private Map m_header = null;

    public JarRevision(Logger logger, File revisionRootDir, String location, boolean byReference) throws Exception {
        this(logger, revisionRootDir, location, byReference, null);
    }

    public JarRevision(Logger logger, File revisionRootDir, String location, boolean byReference, InputStream is) throws Exception {
        super(logger, revisionRootDir, location);
        this.m_bundleFile = byReference ? new File(location.substring(location.indexOf("file:") + "file:".length())) : new File(this.getRevisionRootDir(), BUNDLE_JAR_FILE);
        this.initialize(byReference, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getManifestHeader() throws Exception {
        if (this.m_header != null) {
            return this.m_header;
        }
        JarFileX jarFile = null;
        try {
            jarFile = BundleCache.getSecureAction().openJAR(this.m_bundleFile);
            if (jarFile == null) {
                throw new IOException("No JAR file found.");
            }
            Manifest mf = jarFile.getManifest();
            Map map = this.m_header = new StringMap(mf.getMainAttributes(), false);
            return map;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public IContent getContent() throws Exception {
        return new JarContent(this.m_bundleFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IContent[] getContentPath() throws Exception {
        File embedDir = new File(this.getRevisionRootDir(), EMBEDDED_DIRECTORY);
        Map map = this.getManifestHeader();
        String classPath = map == null ? null : (String)map.get("Bundle-ClassPath");
        String[] classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new String[]{};
        }
        JarFileX bundleJar = null;
        try {
            bundleJar = BundleCache.getSecureAction().openJAR(this.m_bundleFile);
            JarContent self = new JarContent(this.m_bundleFile);
            ArrayList<IContent> contentList = new ArrayList<IContent>();
            for (int i = 0; i < classPathStrings.length; ++i) {
                String string = classPathStrings[i] = classPathStrings[i].startsWith("/") ? classPathStrings[i].substring(1) : classPathStrings[i];
                if (classPathStrings[i].equals(".")) {
                    contentList.add(self);
                    continue;
                }
                ZipEntry entry = ((JarFile)bundleJar).getEntry(classPathStrings[i]);
                if (entry != null && entry.isDirectory()) {
                    contentList.add(new ContentDirectoryContent(self, classPathStrings[i]));
                    continue;
                }
                File extractedJar = new File(embedDir, classPathStrings[i]);
                if (!BundleCache.getSecureAction().fileExists(extractedJar)) continue;
                contentList.add(new JarContent(extractedJar));
            }
            if (contentList.size() == 0) {
                contentList.add(self);
            }
            IContent[] iContentArray = contentList.toArray(new IContent[contentList.size()]);
            return iContentArray;
        }
        finally {
            if (bundleJar != null) {
                bundleJar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String findLibrary(String libName) throws Exception {
        File libDir = new File(this.getRevisionRootDir(), LIBRARY_DIRECTORY);
        File libFile = new File(libDir, File.separatorChar + libName);
        libDir = libFile.getParentFile();
        if (!BundleCache.getSecureAction().fileExists(libDir) && !BundleCache.getSecureAction().mkdirs(libDir)) {
            throw new IOException("Unable to create library directory.");
        }
        if (!BundleCache.getSecureAction().fileExists(libFile)) {
            InputStream is;
            block9: {
                JarFileX bundleJar = null;
                is = null;
                try {
                    bundleJar = BundleCache.getSecureAction().openJAR(this.m_bundleFile);
                    ZipEntry ze = ((JarFile)bundleJar).getEntry(libName);
                    if (ze == null) {
                        throw new IOException("No JAR entry: " + libName);
                    }
                    is = new BufferedInputStream(bundleJar.getInputStream(ze), BundleCache.BUFSIZE);
                    if (is == null) {
                        throw new IOException("No input stream: " + libName);
                    }
                    BundleCache.copyStreamToFile(is, libFile);
                    Object var8_7 = null;
                    if (bundleJar == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (bundleJar != null) {
                        bundleJar.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                bundleJar.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return BundleCache.getSecureAction().getAbsolutePath(libFile);
    }

    public void dispose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean byReference, InputStream is) throws Exception {
        try {
            if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
                return;
            }
            if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
                this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
                throw new IOException("Unable to create archive directory.");
            }
            if (!byReference) {
                if (is == null) {
                    URL url = new URL(this.getLocation());
                    URLConnection conn = url.openConnection();
                    String auth = BundleCache.getSecureAction().getSystemProperty("http.proxyAuth", null);
                    if (auth != null && auth.length() > 0 && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                        String base64 = Util.base64Encode(auth);
                        conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
                    }
                    is = BundleCache.getSecureAction().getURLConnectionInputStream(conn);
                }
                BundleCache.copyStreamToFile(is, this.m_bundleFile);
            }
            this.preprocessBundleJar();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void preprocessBundleJar() throws Exception {
        File embedDir = new File(this.getRevisionRootDir(), EMBEDDED_DIRECTORY);
        if (!BundleCache.getSecureAction().fileExists(embedDir) && !BundleCache.getSecureAction().mkdir(embedDir)) {
            throw new IOException("Could not create embedded JAR directory.");
        }
        File libDir = new File(this.getRevisionRootDir(), LIBRARY_DIRECTORY);
        if (!BundleCache.getSecureAction().fileExists(libDir) && !BundleCache.getSecureAction().mkdir(libDir)) {
            throw new IOException("Unable to create native library directory.");
        }
        try {
            Map map = this.getManifestHeader();
            String classPath = map == null ? null : (String)map.get("Bundle-ClassPath");
            String[] classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
            if (classPathStrings == null) {
                classPathStrings = new String[]{};
            }
            for (int i = 0; i < classPathStrings.length; ++i) {
                if (classPathStrings[i].equals(".")) continue;
                this.extractEmbeddedJar(classPathStrings[i]);
            }
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractEmbeddedJar(String jarPath) throws Exception {
        InputStream is;
        JarFileX bundleJar;
        block10: {
            block8: {
                block9: {
                    jarPath = jarPath.length() > 0 && jarPath.charAt(0) == '/' ? jarPath.substring(1) : jarPath;
                    File jarFile = new File(this.getRevisionRootDir(), EMBEDDED_DIRECTORY + File.separatorChar + jarPath);
                    if (BundleCache.getSecureAction().fileExists(jarFile)) return;
                    bundleJar = null;
                    is = null;
                    try {
                        bundleJar = BundleCache.getSecureAction().openJAR(this.m_bundleFile);
                        ZipEntry ze = ((JarFile)bundleJar).getEntry(jarPath);
                        if (ze == null) {
                            this.getLogger().log(3, "Class path entry not found: " + jarPath);
                            Object var8_6 = null;
                            if (bundleJar == null) break block8;
                            break block9;
                        }
                        if (!ze.isDirectory()) {
                            File jarDir = jarFile.getParentFile();
                            if (!BundleCache.getSecureAction().fileExists(jarDir) && !BundleCache.getSecureAction().mkdirs(jarDir)) {
                                throw new IOException("Unable to create embedded JAR directory.");
                            }
                            is = new BufferedInputStream(bundleJar.getInputStream(ze), BundleCache.BUFSIZE);
                            if (is == null) {
                                throw new IOException("No input stream: " + jarPath);
                            }
                            BundleCache.copyStreamToFile(is, jarFile);
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (bundleJar != null) {
                            bundleJar.close();
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                }
                bundleJar.close();
            }
            if (is == null) return;
            is.close();
            return;
        }
        Object var8_7 = null;
        if (bundleJar != null) {
            bundleJar.close();
        }
        if (is == null) return;
        is.close();
    }
}

