/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.searchpolicy.PackageSource;
import org.apache.felix.framework.searchpolicy.R4Wire;
import org.apache.felix.framework.searchpolicy.R4WireModule;
import org.apache.felix.framework.searchpolicy.ResolveException;
import org.apache.felix.framework.util.CompoundEnumeration;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.SecurityManagerEx;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ModuleImpl
implements IModule {
    private final Logger m_logger;
    private final Map m_configMap;
    private final Felix.FelixResolver m_resolver;
    private final String m_id;
    private final IContent m_content;
    private final Map m_headerMap;
    private final URLStreamHandler m_streamHandler;
    private final String m_manifestVersion;
    private final boolean m_isExtension;
    private final String m_symbolicName;
    private final Version m_version;
    private final ICapability[] m_capabilities;
    private final IRequirement[] m_requirements;
    private final IRequirement[] m_dynamicRequirements;
    private final R4Library[] m_nativeLibraries;
    private final Bundle m_bundle;
    private IModule[] m_fragments = null;
    private IWire[] m_wires = null;
    private IModule[] m_dependentHosts = new IModule[0];
    private IModule[] m_dependentImporters = new IModule[0];
    private IModule[] m_dependentRequirers = new IModule[0];
    private volatile boolean m_isResolved = false;
    private IContent[] m_contentPath;
    private IContent[] m_fragmentContents = null;
    private ModuleClassLoader m_classLoader;
    private ProtectionDomain m_protectionDomain = null;
    private static SecureAction m_secureAction = new SecureAction();
    private final String[] m_bootPkgs;
    private final boolean[] m_bootPkgWildcards;
    private static SecurityManagerEx m_sm = new SecurityManagerEx();
    private final ThreadLocal m_cycleCheck = new ThreadLocal();
    private static volatile Method getEnclosingClassMethod = null;
    private static volatile boolean getEnclosingClassMethodInitialized = false;
    private static final Constructor m_dexFileClassConstructor;
    private static final Method m_dexFileClassLoadClass;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public ModuleImpl(Logger logger, Bundle bundle, String id, String[] bootPkgs, boolean[] bootPkgWildcards) {
        this.m_logger = logger;
        this.m_configMap = null;
        this.m_resolver = null;
        this.m_bundle = bundle;
        this.m_id = id;
        this.m_headerMap = null;
        this.m_content = null;
        this.m_streamHandler = null;
        this.m_bootPkgs = bootPkgs;
        this.m_bootPkgWildcards = bootPkgWildcards;
        this.m_manifestVersion = null;
        this.m_symbolicName = null;
        this.m_isExtension = false;
        this.m_version = null;
        this.m_capabilities = null;
        this.m_requirements = null;
        this.m_dynamicRequirements = null;
        this.m_nativeLibraries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleImpl(Logger logger, Map configMap, Felix.FelixResolver resolver, Bundle bundle, String id, Map headerMap, IContent content, URLStreamHandler streamHandler, String[] bootPkgs, boolean[] bootPkgWildcards) throws BundleException {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_resolver = resolver;
        this.m_bundle = bundle;
        this.m_id = id;
        this.m_headerMap = headerMap;
        this.m_content = content;
        this.m_streamHandler = streamHandler;
        this.m_bootPkgs = bootPkgs;
        this.m_bootPkgWildcards = bootPkgWildcards;
        ManifestParser mp = new ManifestParser(this.m_logger, this.m_configMap, this.m_headerMap);
        this.m_manifestVersion = mp.getManifestVersion();
        this.m_version = mp.getBundleVersion();
        this.m_capabilities = mp.isExtension() ? null : mp.getCapabilities();
        this.m_requirements = mp.getRequirements();
        this.m_dynamicRequirements = mp.getDynamicRequirements();
        this.m_nativeLibraries = mp.getLibraries();
        this.m_symbolicName = mp.getSymbolicName();
        this.m_isExtension = mp.isExtension();
        try {
            for (int i = 0; this.m_nativeLibraries != null && i < this.m_nativeLibraries.length; ++i) {
                String entryName = this.m_nativeLibraries[i].getEntryName();
                if (entryName == null || this.m_content.getEntryAsNativeLibrary(entryName) != null) continue;
                throw new BundleException("Native library does not exist: " + entryName);
            }
        }
        finally {
            this.m_content.close();
        }
    }

    public Map getHeaders() {
        return this.m_headerMap;
    }

    public boolean isExtension() {
        return this.m_isExtension;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public String getManifestVersion() {
        return this.m_manifestVersion;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public ICapability[] getCapabilities() {
        return this.m_capabilities;
    }

    public IRequirement[] getRequirements() {
        return this.m_requirements;
    }

    public IRequirement[] getDynamicRequirements() {
        return this.m_dynamicRequirements;
    }

    public R4Library[] getNativeLibraries() {
        return this.m_nativeLibraries;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public String getId() {
        return this.m_id;
    }

    public synchronized IWire[] getWires() {
        return this.m_wires;
    }

    public synchronized void setWires(IWire[] wires) {
        int i;
        for (i = 0; this.m_wires != null && i < this.m_wires.length; ++i) {
            if (this.m_wires[i].getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires[i].getExporter()).removeDependentRequirer(this);
                continue;
            }
            if (!this.m_wires[i].getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires[i].getExporter()).removeDependentImporter(this);
        }
        this.m_wires = wires;
        for (i = 0; this.m_wires != null && i < this.m_wires.length; ++i) {
            if (this.m_wires[i].getCapability().getNamespace().equals("module")) {
                ((ModuleImpl)this.m_wires[i].getExporter()).addDependentRequirer(this);
                continue;
            }
            if (!this.m_wires[i].getCapability().getNamespace().equals("package")) continue;
            ((ModuleImpl)this.m_wires[i].getExporter()).addDependentImporter(this);
        }
    }

    public boolean isResolved() {
        return this.m_isResolved;
    }

    public void setResolved() {
        this.m_isResolved = true;
    }

    public IContent getContent() {
        return this.m_content;
    }

    private synchronized IContent[] getContentPath() {
        if (this.m_contentPath == null) {
            try {
                this.m_contentPath = this.initializeContentPath();
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to get module class path.", ex);
            }
        }
        return this.m_contentPath;
    }

    private IContent[] initializeContentPath() throws Exception {
        ArrayList contentList = new ArrayList();
        this.calculateContentPath(this.m_content, contentList, true);
        for (int i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.calculateContentPath(this.m_fragmentContents[i], contentList, false);
        }
        return contentList.toArray(new IContent[contentList.size()]);
    }

    private List calculateContentPath(IContent content, List contentList, boolean searchFragments) throws Exception {
        ArrayList<IContent> localContentList = new ArrayList<IContent>();
        String classPath = (String)this.m_headerMap.get("Bundle-ClassPath");
        String[] classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new String[]{};
        }
        for (int i = 0; i < classPathStrings.length; ++i) {
            String string = classPathStrings[i] = classPathStrings[i].startsWith("/") ? classPathStrings[i].substring(1) : classPathStrings[i];
            if (classPathStrings[i].equals(".")) {
                localContentList.add(content);
                continue;
            }
            IContent embeddedContent = content.getEntryAsContent(classPathStrings[i]);
            for (int fragIdx = 0; searchFragments && embeddedContent == null && this.m_fragmentContents != null && fragIdx < this.m_fragmentContents.length; ++fragIdx) {
                embeddedContent = this.m_fragmentContents[fragIdx].getEntryAsContent(classPathStrings[i]);
            }
            if (embeddedContent != null) {
                localContentList.add(embeddedContent);
                continue;
            }
            this.m_logger.log(3, "Class path entry not found: " + classPathStrings[i]);
        }
        if (localContentList.size() == 0) {
            localContentList.add(content);
        }
        contentList.addAll(localContentList);
        return contentList;
    }

    public Class getClassByDelegation(String name) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(name);
    }

    public URL getResourceByDelegation(String name) {
        try {
            return (URL)this.findClassOrResourceByDelegation(name, false);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (ResourceNotFoundException ex) {
            this.m_logger.log(4, ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findClassOrResourceByDelegation(String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        Object result = null;
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.add(name)) return null;
        try {
            String pkgName;
            block15: {
                this.m_resolver.resolve(this);
                String string = pkgName = isClass ? Util.getClassPackage(name) : Util.getResourcePackage(name);
                if (this.shouldBootDelegate(pkgName)) {
                    try {
                        Object object = result = isClass ? this.getClass().getClassLoader().loadClass(name) : this.getClass().getClassLoader().getResource(name);
                        if (pkgName.startsWith("java.") || result != null) {
                            Serializable serializable = result;
                            return serializable;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!pkgName.startsWith("java.")) break block15;
                        throw classNotFoundException;
                    }
                }
            }
            if ((result = this.searchImports(name, isClass)) == null) {
                Object object = result = isClass ? this.getClassLoader().findClass(name) : this.getResourceLocal(name);
                if (result == null) {
                    result = this.searchDynamicImports(name, pkgName, isClass);
                }
            }
        }
        catch (ResolveException ex) {
            if (isClass) {
                throw new ClassNotFoundException(name + ": cannot resolve package " + ex.getRequirement());
            }
            URL uRL = this.getResourceLocal(name);
            if (uRL == null) throw new ResourceNotFoundException(name + ": cannot resolve package " + ex.getRequirement());
            URL uRL2 = uRL;
            return uRL2;
        }
        finally {
            requestSet.remove(name);
        }
        if (result != null) return result;
        if (!isClass) throw new ResourceNotFoundException(name);
        throw new ClassNotFoundException(name);
    }

    private URL getResourceLocal(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.createURL(1, name);
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        IContent[] contentPath = this.getContentPath();
        for (int i = 0; url == null && i < contentPath.length; ++i) {
            if (!contentPath[i].hasEntry(name)) continue;
            url = this.createURL(i + 1, name);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResourcesByDelegation(String name) {
        HashSet<String> requestSet = (HashSet<String>)this.m_cycleCheck.get();
        if (requestSet == null) {
            requestSet = new HashSet<String>();
            this.m_cycleCheck.set(requestSet);
        }
        if (!requestSet.contains(name)) {
            requestSet.add(name);
            try {
                Enumeration enumeration = this.findResourcesByDelegation(name);
                return enumeration;
            }
            finally {
                requestSet.remove(name);
            }
        }
        return null;
    }

    private Enumeration findResourcesByDelegation(String name) {
        int i;
        Enumeration urls = null;
        ArrayList<Enumeration> completeUrlList = new ArrayList<Enumeration>();
        try {
            this.m_resolver.resolve(this);
        }
        catch (ResolveException ex) {
            urls = this.getResourcesLocal(name);
            return urls;
        }
        String pkgName = Util.getResourcePackage(name);
        if (this.shouldBootDelegate(pkgName)) {
            try {
                urls = this.getClass().getClassLoader().getResources(name);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (pkgName.startsWith("java.")) {
                return urls;
            }
            completeUrlList.add(urls);
        }
        IWire[] wires = this.getWires();
        for (i = 0; wires != null && i < wires.length; ++i) {
            if (!(wires[i] instanceof R4Wire)) continue;
            try {
                urls = wires[i].getResources(name);
            }
            catch (ResourceNotFoundException ex) {
                urls = null;
            }
            if (urls == null) continue;
            completeUrlList.add(urls);
            return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
        }
        for (i = 0; wires != null && i < wires.length; ++i) {
            if (!(wires[i] instanceof R4WireModule)) continue;
            try {
                urls = wires[i].getResources(name);
            }
            catch (ResourceNotFoundException ex) {
                urls = null;
            }
            if (urls == null) continue;
            completeUrlList.add(urls);
        }
        urls = this.getResourcesLocal(name);
        if (urls != null) {
            completeUrlList.add(urls);
        } else {
            IWire wire = null;
            try {
                wire = this.m_resolver.resolveDynamicImport(this, pkgName);
            }
            catch (ResolveException ex) {
                // empty catch block
            }
            if (wire != null) {
                try {
                    urls = wire.getResources(name);
                }
                catch (ResourceNotFoundException ex) {
                    urls = null;
                }
                if (urls != null) {
                    completeUrlList.add(urls);
                }
            }
        }
        return new CompoundEnumeration(completeUrlList.toArray(new Enumeration[completeUrlList.size()]));
    }

    private Enumeration getResourcesLocal(String name) {
        Vector<URL> v = new Vector<URL>();
        IContent[] contentPath = this.getContentPath();
        if (name.equals("/")) {
            for (int i = 0; i < contentPath.length; ++i) {
                v.addElement(this.createURL(i + 1, name));
            }
        } else {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            for (int i = 0; i < contentPath.length; ++i) {
                if (!contentPath[i].hasEntry(name)) continue;
                v.addElement(this.createURL(i + 1, name));
            }
        }
        return v.elements();
    }

    public URL getEntry(String name) {
        URL url = null;
        if (name.equals("/")) {
            url = this.createURL(0, "/");
        }
        if (url == null) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.getContent().hasEntry(name)) {
                url = this.createURL(0, name);
            }
        }
        return url;
    }

    public boolean hasInputStream(int index, String urlPath) {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.hasEntry(urlPath);
        }
        return this.getContentPath()[index - 1].hasEntry(urlPath);
    }

    public InputStream getInputStream(int index, String urlPath) throws IOException {
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (index == 0) {
            return this.m_content.getEntryAsStream(urlPath);
        }
        return this.getContentPath()[index - 1].getEntryAsStream(urlPath);
    }

    private URL createURL(int port, String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            return m_secureAction.createURL("bundle", this.m_id, port, path, this.m_streamHandler);
        }
        catch (MalformedURLException ex) {
            this.m_logger.log(1, "Unable to create resource URL.", ex);
            return null;
        }
    }

    public synchronized IModule[] getFragments() {
        return this.m_fragments;
    }

    public synchronized void attachFragments(IModule[] fragments) throws Exception {
        for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
            ((ModuleImpl)this.m_fragments[i]).removeDependentHost(this);
        }
        this.m_fragments = fragments;
        if (this.m_fragments != null) {
            IContent[] fragmentContents = new IContent[this.m_fragments.length];
            for (int i = 0; this.m_fragments != null && i < this.m_fragments.length; ++i) {
                ((ModuleImpl)this.m_fragments[i]).addDependentHost(this);
                fragmentContents[i] = this.m_fragments[i].getContent().getEntryAsContent(".");
            }
            this.attachFragmentContents(fragmentContents);
        }
    }

    private void attachFragmentContents(IContent[] fragmentContents) throws Exception {
        int i;
        if (this.m_fragmentContents != null) {
            for (i = 0; i < this.m_fragmentContents.length; ++i) {
                this.m_fragmentContents[i].close();
            }
        }
        this.m_fragmentContents = fragmentContents;
        if (this.m_contentPath != null) {
            for (i = 0; i < this.m_contentPath.length; ++i) {
                this.m_contentPath[i].close();
            }
        }
        this.m_contentPath = this.initializeContentPath();
    }

    public synchronized IModule[] getDependentHosts() {
        return this.m_dependentHosts;
    }

    public synchronized void addDependentHost(IModule module) {
        this.m_dependentHosts = ModuleImpl.addDependent(this.m_dependentHosts, module);
    }

    public synchronized void removeDependentHost(IModule module) {
        this.m_dependentHosts = ModuleImpl.removeDependent(this.m_dependentHosts, module);
    }

    public synchronized IModule[] getDependentImporters() {
        return this.m_dependentImporters;
    }

    public synchronized void addDependentImporter(IModule module) {
        this.m_dependentImporters = ModuleImpl.addDependent(this.m_dependentImporters, module);
    }

    public synchronized void removeDependentImporter(IModule module) {
        this.m_dependentImporters = ModuleImpl.removeDependent(this.m_dependentImporters, module);
    }

    public synchronized IModule[] getDependentRequirers() {
        return this.m_dependentRequirers;
    }

    public synchronized void addDependentRequirer(IModule module) {
        this.m_dependentRequirers = ModuleImpl.addDependent(this.m_dependentRequirers, module);
    }

    public synchronized void removeDependentRequirer(IModule module) {
        this.m_dependentRequirers = ModuleImpl.removeDependent(this.m_dependentRequirers, module);
    }

    public synchronized IModule[] getDependents() {
        IModule[] dependents = new IModule[this.m_dependentHosts.length + this.m_dependentImporters.length + this.m_dependentRequirers.length];
        System.arraycopy(this.m_dependentHosts, 0, dependents, 0, this.m_dependentHosts.length);
        System.arraycopy(this.m_dependentImporters, 0, dependents, this.m_dependentHosts.length, this.m_dependentImporters.length);
        System.arraycopy(this.m_dependentRequirers, 0, dependents, this.m_dependentHosts.length + this.m_dependentImporters.length, this.m_dependentRequirers.length);
        return dependents;
    }

    private static IModule[] addDependent(IModule[] modules, IModule module) {
        for (int i = 0; i < modules.length; ++i) {
            if (!modules[i].equals(module)) continue;
            return modules;
        }
        IModule[] tmp = new IModule[modules.length + 1];
        System.arraycopy(modules, 0, tmp, 0, modules.length);
        tmp[modules.length] = module;
        return tmp;
    }

    private static IModule[] removeDependent(IModule[] modules, IModule module) {
        IModule[] tmp = modules;
        for (int i = 0; i < modules.length; ++i) {
            if (!modules[i].equals(module)) continue;
            if (modules.length - 1 == 0) {
                tmp = new IModule[]{};
                break;
            }
            tmp = new IModule[modules.length - 1];
            System.arraycopy(modules, 0, tmp, 0, i);
            if (i >= tmp.length) break;
            System.arraycopy(modules, i + 1, tmp, i, tmp.length - i);
            break;
        }
        return tmp;
    }

    public synchronized void close() {
        int i;
        this.m_content.close();
        for (i = 0; this.m_contentPath != null && i < this.m_contentPath.length; ++i) {
            this.m_contentPath[i].close();
        }
        for (i = 0; this.m_fragmentContents != null && i < this.m_fragmentContents.length; ++i) {
            this.m_fragmentContents[i].close();
        }
        this.m_classLoader = null;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_protectionDomain = (ProtectionDomain)securityContext;
    }

    public synchronized Object getSecurityContext() {
        return this.m_protectionDomain;
    }

    public String toString() {
        return this.m_id;
    }

    private synchronized ModuleClassLoader getClassLoader() {
        if (this.m_classLoader == null) {
            this.m_classLoader = new ModuleClassLoader();
        }
        return this.m_classLoader;
    }

    private Object searchImports(String name, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire[] wires = this.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            Serializable result;
            Serializable serializable = result = isClass ? wires[i].getClass(name) : wires[i].getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Object searchDynamicImports(String name, String pkgName, boolean isClass) throws ClassNotFoundException, ResourceNotFoundException {
        IWire wire = null;
        try {
            wire = this.m_resolver.resolveDynamicImport(this, pkgName);
        }
        catch (ResolveException ex) {
            // empty catch block
        }
        if (wire != null) {
            return isClass ? wire.getClass(name) : wire.getResource(name);
        }
        Class[] classes = m_sm.getClassContext();
        for (int i = 1; i < classes.length && !(class$java$lang$Thread == null ? ModuleImpl.class$("java.lang.Thread") : class$java$lang$Thread).equals(classes[i]); ++i) {
            if (!this.isClassNotLoadedFromBundle(classes[i])) continue;
            boolean delegate = true;
            ClassLoader cl = classes[i].getClassLoader();
            while (cl != null) {
                if ((class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader == null ? ModuleImpl.class$("org.apache.felix.framework.searchpolicy.ModuleImpl$ModuleClassLoader") : class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader).isInstance(cl)) {
                    delegate = false;
                    break;
                }
                cl = cl.getClass().getClassLoader();
            }
            if (!delegate || (class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = ModuleImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).isInstance(classes[i - 1])) break;
            try {
                return isClass ? this.getClass().getClassLoader().loadClass(name) : this.getClass().getClassLoader().getResource(name);
            }
            catch (NoClassDefFoundError ex) {
                break;
            }
        }
        return null;
    }

    private boolean isClassNotLoadedFromBundle(Class clazz) {
        clazz = ModuleImpl.getEnclosingClass(clazz);
        return this.getClass().getClassLoader() != clazz.getClassLoader() && !(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).isAssignableFrom(clazz) && !(class$java$lang$Class == null ? (class$java$lang$Class = ModuleImpl.class$("java.lang.Class")) : class$java$lang$Class).equals(clazz) && !(class$java$lang$reflect$Proxy == null ? (class$java$lang$reflect$Proxy = ModuleImpl.class$("java.lang.reflect.Proxy")) : class$java$lang$reflect$Proxy).equals(clazz);
    }

    private static Class getEnclosingClass(Class clazz) {
        if (!getEnclosingClassMethodInitialized) {
            try {
                getEnclosingClassMethod = (class$java$lang$Class == null ? (class$java$lang$Class = ModuleImpl.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredMethod("getEnclosingClass", null);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            getEnclosingClassMethodInitialized = true;
        }
        if (getEnclosingClassMethod != null) {
            try {
                Class enclosing = (Class)getEnclosingClassMethod.invoke((Object)clazz, null);
                clazz = enclosing != null ? enclosing : clazz;
            }
            catch (Throwable t) {}
        } else {
            int idx = clazz.getName().lastIndexOf(36);
            if (idx > 0) {
                ClassLoader cl = clazz.getClassLoader() != null ? clazz.getClassLoader() : ClassLoader.getSystemClassLoader();
                try {
                    Class enclosing = cl.loadClass(clazz.getName().substring(0, idx));
                    clazz = enclosing != null ? enclosing : clazz;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    private boolean shouldBootDelegate(String pkgName) {
        boolean result = false;
        if (pkgName.length() > 0) {
            for (int i = 0; !result && i < this.m_bootPkgs.length; ++i) {
                if (this.m_bootPkgWildcards[i]) {
                    if (pkgName.startsWith(this.m_bootPkgs[i])) {
                        return true;
                    }
                    if (pkgName.length() != this.m_bootPkgs[i].length() - 1 || !pkgName.regionMatches(0, this.m_bootPkgs[i], 0, this.m_bootPkgs[i].length() - 1)) continue;
                    return true;
                }
                if (!this.m_bootPkgs[i].equals(pkgName)) continue;
                return true;
            }
        }
        return result;
    }

    private static String diagnoseClassLoadError(Felix.FelixResolver resolver, ModuleImpl module, String name) {
        String pkgName = Util.getClassPackage(name);
        long impId = Util.getBundleIdFromModuleId(module.getId());
        IWire[] wires = module.getWires();
        for (int i = 0; wires != null && i < wires.length; ++i) {
            if (!wires[i].getCapability().getNamespace().equals("package") || !wires[i].getCapability().getProperties().get("package").equals(pkgName)) continue;
            long expId = Util.getBundleIdFromModuleId(wires[i].getExporter().getId());
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is imported by bundle ");
            sb.append(impId);
            sb.append(" from bundle ");
            sb.append(expId);
            sb.append(", but the exported package from bundle ");
            sb.append(expId);
            sb.append(" does not contain the requested class '");
            sb.append(name);
            sb.append("'. Please verify that the class name is correct in the importing bundle ");
            sb.append(impId);
            sb.append(" and/or that the exported package is correctly bundled in ");
            sb.append(expId);
            sb.append(". ***");
            return sb.toString();
        }
        IRequirement[] reqs = module.getRequirements();
        Requirement pkgReq = null;
        try {
            pkgReq = new Requirement("package", "(package=" + pkgName + ")");
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        PackageSource[] exporters = resolver.getResolvedCandidates(pkgReq);
        PackageSource[] packageSourceArray = exporters = exporters.length == 0 ? resolver.getUnresolvedCandidates(pkgReq) : exporters;
        if (exporters.length > 0) {
            boolean classpath = false;
            try {
                (class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.searchpolicy.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader).getClassLoader().loadClass(name);
                classpath = true;
            }
            catch (NoClassDefFoundError err) {
            }
            catch (Exception ex) {
                // empty catch block
            }
            long expId = Util.getBundleIdFromModuleId(exporters[0].m_module.getId());
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found because bundle ");
            sb.append(impId);
            sb.append(" does not import '");
            sb.append(pkgName);
            sb.append("' even though bundle ");
            sb.append(expId);
            sb.append(" does export it.");
            if (classpath) {
                sb.append(" Additionally, the class is also available from the system class loader. There are two fixes: 1) Add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append("; imports are necessary for each class directly touched by bundle code or indirectly touched, such as super classes if their methods are used. ");
                sb.append("2) Add package '");
                sb.append(pkgName);
                sb.append("' to the '");
                sb.append("org.osgi.framework.bootdelegation");
                sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            } else {
                sb.append(" To resolve this issue, add an import for '");
                sb.append(pkgName);
                sb.append("' to bundle ");
                sb.append(impId);
                sb.append(".");
            }
            sb.append(" ***");
            return sb.toString();
        }
        try {
            (class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader == null ? (class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader = ModuleImpl.class$("org.apache.felix.framework.searchpolicy.ModuleImpl$ModuleClassLoader")) : class$org$apache$felix$framework$searchpolicy$ModuleImpl$ModuleClassLoader).getClassLoader().loadClass(name);
            StringBuffer sb = new StringBuffer("*** Package '");
            sb.append(pkgName);
            sb.append("' is not imported by bundle ");
            sb.append(impId);
            sb.append(", nor is there any bundle that exports package '");
            sb.append(pkgName);
            sb.append("'. However, the class '");
            sb.append(name);
            sb.append("' is available from the system class loader. There are two fixes: 1) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.system.packages.extra");
            sb.append("' property and modify bundle ");
            sb.append(impId);
            sb.append(" to import this package; this causes the system bundle to export class path packages. 2) Add package '");
            sb.append(pkgName);
            sb.append("' to the '");
            sb.append("org.osgi.framework.bootdelegation");
            sb.append("' property; a library or VM bug can cause classes to be loaded by the wrong class loader. The first approach is preferable for preserving modularity.");
            sb.append(" ***");
            return sb.toString();
        }
        catch (Exception ex2) {
            StringBuffer sb = new StringBuffer("*** Class '");
            sb.append(name);
            sb.append("' was not found. Bundle ");
            sb.append(impId);
            sb.append(" does not import package '");
            sb.append(pkgName);
            sb.append("', nor is the package exported by any other bundle or available from the system class loader.");
            sb.append(" ***");
            return sb.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Constructor<?> dexFileClassConstructor = null;
        Method dexFileClassLoadClass = null;
        try {
            Class<?> dexFileClass;
            try {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            dexFileClassConstructor = dexFileClass.getConstructor(class$java$io$File == null ? (class$java$io$File = ModuleImpl.class$("java.io.File")) : class$java$io$File);
            dexFileClassLoadClass = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = ModuleImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        }
        catch (Exception ex) {
            dexFileClassConstructor = null;
            dexFileClassLoadClass = null;
        }
        m_dexFileClassConstructor = dexFileClassConstructor;
        m_dexFileClassLoadClass = dexFileClassLoadClass;
    }

    public class ModuleClassLoader
    extends SecureClassLoader {
        private final Map m_jarContentToDexFile = ModuleImpl.access$000() != null ? new HashMap() : null;

        public IModule getModule() {
            return ModuleImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz = null;
            ModuleClassLoader moduleClassLoader = this;
            synchronized (moduleClassLoader) {
                clazz = this.findLoadedClass(name);
            }
            if (clazz == null) {
                try {
                    clazz = (Class)ModuleImpl.this.findClassOrResourceByDelegation(name, true);
                }
                catch (ResourceNotFoundException ex) {
                }
                catch (ClassNotFoundException cnfe) {
                    ClassNotFoundException ex = cnfe;
                    String msg = name;
                    if (ModuleImpl.this.m_logger.getLogLevel() >= 4) {
                        msg = ModuleImpl.diagnoseClassLoadError(ModuleImpl.this.m_resolver, ModuleImpl.this, name);
                        ex = new ClassNotFoundException(msg, cnfe);
                    }
                    throw ex;
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            if (clazz == null) {
                String actual = name.replace('.', '/') + ".class";
                byte[] bytes = null;
                IContent[] contentPath = ModuleImpl.this.getContentPath();
                IContent content = null;
                for (int i = 0; bytes == null && i < contentPath.length; ++i) {
                    bytes = contentPath[i].getEntryAsBytes(actual);
                    content = contentPath[i];
                }
                if (bytes != null) {
                    ModuleClassLoader moduleClassLoader = this;
                    synchronized (moduleClassLoader) {
                        clazz = this.findLoadedClass(name);
                        if (clazz == null) {
                            String pkgName = Util.getClassPackage(name);
                            if (pkgName.length() > 0 && this.getPackage(pkgName) == null) {
                                Object[] params = this.definePackage(pkgName);
                                if (params != null) {
                                    this.definePackage(pkgName, (String)params[0], (String)params[1], (String)params[2], (String)params[3], (String)params[4], (String)params[5], null);
                                } else {
                                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                                }
                            }
                            if (content instanceof JarContent) {
                                try {
                                    clazz = this.getDexFileClass((JarContent)content, name, this);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (clazz == null) {
                                clazz = ModuleImpl.this.m_protectionDomain != null ? this.defineClass(name, bytes, 0, bytes.length, ModuleImpl.this.m_protectionDomain) : this.defineClass(name, bytes, 0, bytes.length);
                            }
                        }
                    }
                }
            }
            return clazz;
        }

        private Object[] definePackage(String pkgName) {
            String spectitle = (String)ModuleImpl.this.m_headerMap.get("Specification-Title");
            String specversion = (String)ModuleImpl.this.m_headerMap.get("Specification-Version");
            String specvendor = (String)ModuleImpl.this.m_headerMap.get("Specification-Vendor");
            String impltitle = (String)ModuleImpl.this.m_headerMap.get("Implementation-Title");
            String implversion = (String)ModuleImpl.this.m_headerMap.get("Implementation-Version");
            String implvendor = (String)ModuleImpl.this.m_headerMap.get("Implementation-Vendor");
            if (spectitle != null || specversion != null || specvendor != null || impltitle != null || implversion != null || implvendor != null) {
                return new Object[]{spectitle, specversion, specvendor, impltitle, implversion, implvendor};
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class getDexFileClass(JarContent content, String name, ClassLoader loader) throws Exception {
            if (this.m_jarContentToDexFile == null) {
                return null;
            }
            Object dexFile = null;
            if (!this.m_jarContentToDexFile.containsKey(content)) {
                try {
                    dexFile = m_dexFileClassConstructor.newInstance(content.getFile());
                }
                finally {
                    this.m_jarContentToDexFile.put(content, dexFile);
                }
            } else {
                dexFile = this.m_jarContentToDexFile.get(content);
            }
            if (dexFile != null) {
                return (Class)m_dexFileClassLoadClass.invoke(dexFile, name.replace('.', '/'), loader);
            }
            return null;
        }

        public URL getResource(String name) {
            return ModuleImpl.this.getResourceByDelegation(name);
        }

        protected URL findResource(String name) {
            return ModuleImpl.this.getResourceLocal(name);
        }

        protected Enumeration findResources(String name) {
            return ModuleImpl.this.getResourcesByDelegation(name);
        }

        protected String findLibrary(String name) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            R4Library[] libs = ModuleImpl.this.getNativeLibraries();
            for (int i = 0; libs != null && i < libs.length; ++i) {
                if (!libs[i].match(name)) continue;
                return ModuleImpl.this.getContent().getEntryAsNativeLibrary(libs[i].getEntryName());
            }
            return null;
        }

        public String toString() {
            return ModuleImpl.this.toString();
        }
    }
}

