/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.util.SecureAction;

public class BundleCache {
    public static final String CACHE_BUFSIZE_PROP = "felix.cache.bufsize";
    public static final String CACHE_ROOTDIR_PROP = "felix.cache.rootdir";
    public static final String CACHE_SINGLEBUNDLEFILE_PROP = "felix.cache.singlebundlefile";
    protected static transient int BUFSIZE = 4096;
    protected static final transient String CACHE_DIR_NAME = "felix-cache";
    protected static final transient String CACHE_ROOTDIR_DEFAULT = ".";
    protected static final transient String BUNDLE_DIR_PREFIX = "bundle";
    private static final SecureAction m_secureAction = new SecureAction();
    private final Logger m_logger;
    private final Map m_configMap;

    public BundleCache(Logger logger, Map configMap) {
        this.m_logger = logger;
        this.m_configMap = configMap;
    }

    static SecureAction getSecureAction() {
        return m_secureAction;
    }

    public synchronized void delete() throws Exception {
        File cacheDir = BundleCache.determineCacheDir(this.m_configMap);
        BundleCache.deleteDirectoryTree(cacheDir);
    }

    public BundleArchive[] getArchives() throws Exception {
        try {
            String sBufSize = (String)this.m_configMap.get(CACHE_BUFSIZE_PROP);
            if (sBufSize != null) {
                BUFSIZE = Integer.parseInt(sBufSize);
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        File cacheDir = BundleCache.determineCacheDir(this.m_configMap);
        if (!BundleCache.getSecureAction().fileExists(cacheDir) && !BundleCache.getSecureAction().mkdirs(cacheDir)) {
            this.m_logger.log(1, "Unable to create cache directory: " + cacheDir);
            throw new RuntimeException("Unable to create cache directory.");
        }
        ArrayList<BundleArchive> archiveList = new ArrayList<BundleArchive>();
        File[] children = BundleCache.getSecureAction().listDirectory(cacheDir);
        for (int i = 0; children != null && i < children.length; ++i) {
            if (!children[i].getName().startsWith(BUNDLE_DIR_PREFIX) || children[i].getName().equals(BUNDLE_DIR_PREFIX + Long.toString(0L))) continue;
            try {
                archiveList.add(new BundleArchive(this.m_logger, this.m_configMap, children[i]));
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Error reloading cached bundle, removing it: " + children[i], ex);
                BundleCache.deleteDirectoryTree(children[i]);
            }
        }
        return archiveList.toArray(new BundleArchive[archiveList.size()]);
    }

    public BundleArchive create(long id, int startLevel, String location, InputStream is) throws Exception {
        File cacheDir = BundleCache.determineCacheDir(this.m_configMap);
        File archiveRootDir = new File(cacheDir, BUNDLE_DIR_PREFIX + Long.toString(id));
        try {
            BundleArchive ba = new BundleArchive(this.m_logger, this.m_configMap, archiveRootDir, id, startLevel, location, is);
            return ba;
        }
        catch (Exception ex) {
            if (m_secureAction.fileExists(archiveRootDir) && !BundleCache.deleteDirectoryTree(archiveRootDir)) {
                this.m_logger.log(1, "Unable to delete the archive directory: " + archiveRootDir);
            }
            throw ex;
        }
    }

    public File getSystemBundleDataFile(String fileName) throws Exception {
        File sbDir = new File(BundleCache.determineCacheDir(this.m_configMap), BUNDLE_DIR_PREFIX + Long.toString(0L));
        if (!BundleCache.getSecureAction().fileExists(sbDir) && !BundleCache.getSecureAction().mkdirs(sbDir)) {
            this.m_logger.log(1, "Unable to create system bundle directory.");
            throw new IOException("Unable to create system bundle directory.");
        }
        if (fileName.length() > 0 && fileName.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (fileName.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        return new File(sbDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyStreamToFile(InputStream is, File outputFile) throws IOException {
        OutputStream os = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(outputFile);
            os = new BufferedOutputStream(os, BUFSIZE);
            byte[] b = new byte[BUFSIZE];
            int len = 0;
            while ((len = is.read(b)) != -1) {
                os.write(b, 0, len);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    static boolean deleteDirectoryTree(File target) {
        if (!BundleCache.deleteDirectoryTreeRecursive(target)) {
            System.gc();
            System.gc();
            return BundleCache.deleteDirectoryTreeRecursive(target);
        }
        return true;
    }

    private static File determineCacheDir(Map configMap) {
        File cacheDir;
        String cacheDirStr = (String)configMap.get("org.osgi.framework.storage");
        String rootDirStr = (String)configMap.get(CACHE_ROOTDIR_PROP);
        String string = rootDirStr = rootDirStr == null ? CACHE_ROOTDIR_DEFAULT : rootDirStr;
        if (cacheDirStr != null) {
            cacheDir = new File(cacheDirStr);
            if (!cacheDir.isAbsolute()) {
                cacheDir = new File(rootDirStr, cacheDirStr);
            }
        } else {
            cacheDir = new File(rootDirStr, CACHE_DIR_NAME);
        }
        return cacheDir;
    }

    private static boolean deleteDirectoryTreeRecursive(File target) {
        if (!BundleCache.getSecureAction().fileExists(target)) {
            return true;
        }
        if (BundleCache.getSecureAction().isFileDirectory(target)) {
            File[] files = BundleCache.getSecureAction().listDirectory(target);
            for (int i = 0; i < files.length; ++i) {
                BundleCache.deleteDirectoryTreeRecursive(files[i]);
            }
        }
        return BundleCache.getSecureAction().deleteFile(target);
    }
}

