/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelImpl
implements StartLevel,
Runnable {
    static final String THREAD_NAME = "FelixStartLevel";
    private static final int BUNDLE_IDX = 0;
    private static final int STARTLEVEL_IDX = 1;
    private final Felix m_felix;
    private final List m_requestList = new ArrayList();
    private Thread m_thread = null;

    public StartLevelImpl(Felix felix) {
        this.m_felix = felix;
        this.m_thread = new Thread((Runnable)this, THREAD_NAME);
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        List list = this.m_requestList;
        synchronized (list) {
            if (this.m_thread != null) {
                this.m_thread = null;
                this.m_requestList.notifyAll();
            }
        }
    }

    public int getStartLevel() {
        return this.m_felix.getActiveStartLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartLevel(int startlevel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        if (startlevel <= 0) {
            throw new IllegalArgumentException("Start level must be greater than zero.");
        }
        List list = this.m_requestList;
        synchronized (list) {
            this.m_requestList.add(new Integer(startlevel));
            this.m_requestList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStartLevelAndWait(int startlevel) {
        Integer request;
        Integer n = request = new Integer(startlevel);
        synchronized (n) {
            List list = this.m_requestList;
            synchronized (list) {
                this.m_requestList.add(request);
                this.m_requestList.notifyAll();
            }
            try {
                request.wait();
            }
            catch (InterruptedException ex) {
                this.m_felix.getLogger().log(2, "Wait for start level change during shutdown interrupted.", ex);
            }
        }
    }

    public int getBundleStartLevel(Bundle bundle) {
        return this.m_felix.getBundleStartLevel(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundleStartLevel(Bundle bundle, int startlevel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, "execute"));
        }
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("Cannot change system bundle start level.");
        }
        if (startlevel <= 0) {
            throw new IllegalArgumentException("Start level must be greater than zero.");
        }
        List list = this.m_requestList;
        synchronized (list) {
            ((BundleImpl)bundle).setStartLevel(startlevel);
            this.m_requestList.add(new Object[]{bundle, new Integer(startlevel)});
            this.m_requestList.notifyAll();
        }
    }

    public int getInitialBundleStartLevel() {
        return this.m_felix.getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.m_felix, "startlevel"));
        }
        this.m_felix.setInitialBundleStartLevel(startlevel);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        return this.m_felix.isBundlePersistentlyStarted(bundle);
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        return this.m_felix.isBundleActivationPolicyUsed(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object request = null;
            List list = this.m_requestList;
            synchronized (list) {
                while (this.m_requestList.size() == 0) {
                    if (this.m_thread == null) {
                        return;
                    }
                    try {
                        this.m_requestList.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                request = this.m_requestList.remove(0);
            }
            if (request instanceof Integer) {
                this.m_felix.setActiveStartLevel((Integer)request);
            } else {
                Bundle bundle = (Bundle)((Object[])request)[0];
                int startlevel = (Integer)((Object[])request)[1];
                this.m_felix.setBundleStartLevel(bundle, startlevel);
            }
            list = request;
            synchronized (list) {
                request.notifyAll();
            }
        }
    }
}

