/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteSet<E>
extends AbstractSet<E> {
    Object[] data;

    public CopyOnWriteSet() {
        this.data = new Object[0];
    }

    public CopyOnWriteSet(Collection<E> col) {
        this.data = col instanceof CopyOnWriteSet ? ((CopyOnWriteSet)col).data : col.toArray(new Object[col.size()]);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CopyOnWriteSet.this.data.length;
            }

            @Override
            public E next() {
                return CopyOnWriteSet.this.data[this.idx++];
            }

            @Override
            public void remove() {
                CopyOnWriteSet.this.remove(--this.idx);
            }
        };
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean add(E e) {
        Object[] d = this.data;
        if (d.length == 0) {
            this.data = new Object[]{e};
        } else {
            for (Object o : d) {
                if (!(o == null ? e == null : o.equals(e))) continue;
                return false;
            }
            Object[] a = new Object[d.length + 1];
            System.arraycopy(d, 0, a, 0, d.length);
            a[d.length] = e;
            this.data = a;
        }
        return true;
    }

    private void remove(int index) {
        Object[] d = this.data;
        int len = d.length;
        Object[] a = new Object[len - 1];
        int numMoved = len - index - 1;
        if (index > 0) {
            System.arraycopy(d, 0, a, 0, index);
        }
        if (numMoved > 0) {
            System.arraycopy(d, index + 1, a, index, numMoved);
        }
        this.data = a;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CopyOnWriteSet && ((CopyOnWriteSet)o).data == this.data) {
            return true;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

