/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.condpermadmin;

import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionAdminImpl;
import org.apache.felix.framework.security.util.Permissions;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo {
    private static final Random RANDOM = new Random();
    static final ConditionInfo[] CONDITION_INFO = new ConditionInfo[0];
    static final PermissionInfo[] PERMISSION_INFO = new PermissionInfo[0];
    private final Object m_lock = new Object();
    private final String m_name;
    private final boolean m_allow;
    private volatile ConditionalPermissionAdminImpl m_cpai;
    private ConditionInfo[] m_conditions;
    private PermissionInfo[] m_permissions;

    public ConditionalPermissionInfoImpl(String encoded) {
        StringTokenizer tok = new StringTokenizer(encoded, "\n");
        String access = tok.nextToken().trim();
        if (!access.equals("ALLOW {") && !access.equals("DENY {")) {
            throw new IllegalArgumentException();
        }
        this.m_allow = access.equals("ALLOW {");
        this.m_cpai = null;
        this.m_name = tok.nextToken().trim().substring(1);
        ArrayList<ConditionInfo> conditions = new ArrayList<ConditionInfo>();
        ArrayList<PermissionInfo> permissions = new ArrayList<PermissionInfo>();
        String current = tok.nextToken().trim();
        while (!current.equals("}")) {
            if (current.startsWith("[")) {
                conditions.add(new ConditionInfo(current));
            } else if (current.startsWith("(")) {
                permissions.add(new PermissionInfo(current));
            } else if (!current.startsWith("#")) {
                throw new IllegalArgumentException();
            }
            current = tok.nextToken().trim();
        }
        this.m_conditions = conditions.isEmpty() ? CONDITION_INFO : conditions.toArray(new ConditionInfo[conditions.size()]);
        this.m_permissions = permissions.isEmpty() ? PERMISSION_INFO : permissions.toArray(new PermissionInfo[permissions.size()]);
    }

    public ConditionalPermissionInfoImpl(ConditionalPermissionAdminImpl cpai, String name, boolean access) {
        this.m_allow = access;
        this.m_name = name;
        this.m_cpai = cpai;
        this.m_conditions = CONDITION_INFO;
        this.m_permissions = PERMISSION_INFO;
    }

    public ConditionalPermissionInfoImpl(ConditionInfo[] conditions, PermissionInfo[] permisions, ConditionalPermissionAdminImpl cpai, boolean access) {
        this.m_allow = access;
        this.m_name = Long.toString(RANDOM.nextLong() ^ System.currentTimeMillis());
        this.m_cpai = cpai;
        this.m_conditions = conditions;
        this.m_permissions = permisions;
    }

    public ConditionalPermissionInfoImpl(String name, ConditionInfo[] conditions, PermissionInfo[] permisions, ConditionalPermissionAdminImpl cpai, boolean access) {
        this.m_allow = access;
        this.m_name = name != null ? name : Long.toString(RANDOM.nextLong() ^ System.currentTimeMillis());
        this.m_conditions = conditions;
        this.m_permissions = permisions;
        this.m_cpai = cpai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        Object object = this.m_lock;
        synchronized (object) {
            this.m_cpai.write(this.m_name, null);
            this.m_conditions = CONDITION_INFO;
            this.m_permissions = PERMISSION_INFO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionInfo[] getConditionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return (ConditionInfo[])this.m_conditions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConditionInfo[] _getConditionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_conditions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConditionsAndPermissions(ConditionInfo[] conditions, PermissionInfo[] permissions) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_conditions = conditions;
            this.m_permissions = permissions;
        }
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] getPermissionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return (PermissionInfo[])this.m_permissions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionInfo[] _getPermissionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoded() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_allow ? "ALLOW " : "DENY ");
        buffer.append('{');
        buffer.append('\n');
        buffer.append('#');
        buffer.append(this.m_name);
        buffer.append('\n');
        Object object = this.m_lock;
        synchronized (object) {
            this.writeTo(this.m_conditions, buffer);
            this.writeTo(this.m_permissions, buffer);
        }
        buffer.append('}');
        return buffer.toString();
    }

    private void writeTo(Object[] elements, StringBuffer buffer) {
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i]);
            buffer.append('\n');
        }
    }

    public String toString() {
        return this.getEncoded();
    }

    public String getAccessDecision() {
        return this.m_allow ? "allow" : "deny";
    }

    public boolean isAllow() {
        return this.m_allow;
    }
}

