/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.security.Permission;
import java.security.ProtectionDomain;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionAdminImpl;
import org.apache.felix.framework.security.permissionadmin.PermissionAdminImpl;
import org.apache.felix.framework.security.util.TrustManager;
import org.apache.felix.framework.security.verifier.BundleDNParser;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.Bundle;

public final class SecurityProviderImpl
implements SecurityProvider {
    private final BundleDNParser m_parser;
    private final PermissionAdminImpl m_pai;
    private final ConditionalPermissionAdminImpl m_cpai;
    private final SecureAction m_action;

    SecurityProviderImpl(String crlList, String typeList, String passwdList, String storeList, PermissionAdminImpl pai, ConditionalPermissionAdminImpl cpai, SecureAction action) {
        this.m_pai = pai;
        this.m_cpai = cpai;
        this.m_action = action;
        this.m_parser = new BundleDNParser(new TrustManager(crlList, typeList, passwdList, storeList, this.m_action));
    }

    public void checkBundle(Bundle bundle) throws Exception {
        IModule module = ((BundleImpl)bundle).getCurrentModule();
        this.m_parser.checkDNChains(module, module.getContent(), 2);
    }

    public Object getSignerMatcher(Bundle bundle, int signersType) {
        IModule module = ((BundleImpl)bundle).getCurrentModule();
        return this.m_parser.getDNChains(module, module.getContent(), signersType);
    }

    public boolean hasBundlePermission(ProtectionDomain bundleProtectionDomain, Permission permission, boolean direct) {
        BundleProtectionDomain pd = (BundleProtectionDomain)bundleProtectionDomain;
        BundleImpl bundle = pd.getBundle();
        IModule module = pd.getModule();
        if (bundle.getBundleId() == 0L) {
            return true;
        }
        Boolean result = null;
        if (this.m_pai != null) {
            result = this.m_pai.hasPermission(bundle._getLocation(), (Bundle)pd.getBundle(), permission, this.m_cpai, (ProtectionDomain)pd, bundle.getCurrentModule().getContent());
        }
        if (result != null) {
            if (this.m_cpai != null && !direct) {
                boolean allow = result;
                if (!allow) {
                    this.m_cpai.clearPD();
                    return false;
                }
                return this.m_cpai.handlePAHandle(pd);
            }
            return result;
        }
        if (this.m_cpai != null) {
            try {
                return this.m_cpai.hasPermission(module, module.getContent(), (ProtectionDomain)pd, permission, direct, this.m_pai);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

