/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.felix.framework.security.util.Permissions;
import org.apache.felix.moduleloader.IContent;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class LocalPermissions {
    private static final PermissionInfo[] ALL_PERMISSION = new PermissionInfo[]{new PermissionInfo((class$java$security$AllPermission == null ? (class$java$security$AllPermission = LocalPermissions.class$("java.security.AllPermission")) : class$java$security$AllPermission).getName(), "", "")};
    private final Map m_cache = new WeakHashMap();
    private final Permissions m_permissions;
    static /* synthetic */ Class class$java$security$AllPermission;

    public LocalPermissions(Permissions permissions) throws IOException {
        this.m_permissions = permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(IContent content, Bundle bundle, Permission permission) {
        PermissionInfo[] permissions = null;
        Map map = this.m_cache;
        synchronized (map) {
            if (!this.m_cache.containsKey(content)) {
                InputStream in = null;
                try {
                    in = content.getEntryAsStream("OSGI-INF/permissions.perm");
                    if (in != null) {
                        ArrayList<PermissionInfo> perms = new ArrayList<PermissionInfo>();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                        String line = reader.readLine();
                        while (line != null) {
                            String trim = line.trim();
                            if (!trim.startsWith("#") && !trim.startsWith("//") && trim.length() != 0) {
                                perms.add(new PermissionInfo(line));
                            }
                            line = reader.readLine();
                        }
                        permissions = perms.toArray(new PermissionInfo[perms.size()]);
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (permissions == null) {
                    permissions = ALL_PERMISSION;
                }
                this.m_cache.put(content, permissions);
            } else {
                permissions = (PermissionInfo[])this.m_cache.get(content);
            }
        }
        return this.m_permissions.getPermissions(permissions).implies(permission, bundle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

