/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.condpermadmin;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionInfoImpl;
import org.apache.felix.framework.security.condpermadmin.DomainGripper;
import org.apache.felix.framework.security.permissionadmin.PermissionAdminImpl;
import org.apache.felix.framework.security.util.Conditions;
import org.apache.felix.framework.security.util.LocalPermissions;
import org.apache.felix.framework.security.util.Permissions;
import org.apache.felix.framework.security.util.PropertiesCache;
import org.apache.felix.framework.util.IteratorToEnumeration;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    private static final ConditionInfo[] EMPTY_CONDITION_INFO = new ConditionInfo[0];
    private static final PermissionInfo[] EMPTY_PERMISSION_INFO = new PermissionInfo[0];
    private final Map m_condPermInfos = new OrderedHashMap();
    private final PropertiesCache m_propertiesCache;
    private final Permissions m_permissions;
    private final Conditions m_conditions;
    private final LocalPermissions m_localPermissions;
    private final PermissionAdminImpl m_pai;
    private final ThreadLocal m_stack = new ThreadLocal();

    public ConditionalPermissionAdminImpl(Permissions permissions, Conditions condtions, LocalPermissions localPermissions, PropertiesCache cache, PermissionAdminImpl pai) throws IOException {
        this.m_propertiesCache = cache;
        this.m_permissions = permissions;
        this.m_conditions = condtions;
        this.m_localPermissions = localPermissions;
        OrderedHashMap old = new OrderedHashMap();
        this.m_propertiesCache.read(ConditionalPermissionInfoImpl.class, old);
        Iterator iter = old.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)entry.getValue();
            this.m_condPermInfos.put(name, new ConditionalPermissionInfoImpl(name, cpi._getConditionInfos(), cpi._getPermissionInfos(), this, cpi.isAllow()));
        }
        this.m_pai = pai;
    }

    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conditions, PermissionInfo[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        ConditionalPermissionInfoImpl result = new ConditionalPermissionInfoImpl(this.notNull(conditions), this.notNull(permissions), this, true);
        return this.write(result.getName(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConditionalPermissionInfoImpl write(String name, ConditionalPermissionInfoImpl cpi) {
        Object object = this.m_propertiesCache;
        synchronized (object) {
            OrderedHashMap tmp = null;
            Map map = this.m_condPermInfos;
            synchronized (map) {
                tmp = new OrderedHashMap();
                tmp.putAll(this.m_condPermInfos);
                if (name != null && cpi != null) {
                    this.m_condPermInfos.put(name, cpi);
                } else if (name != null) {
                    this.m_condPermInfos.remove(name);
                } else {
                    tmp = null;
                }
            }
            try {
                this.m_propertiesCache.write(this.m_condPermInfos);
            }
            catch (IOException ex) {
                Map map2 = this.m_condPermInfos;
                synchronized (map2) {
                    if (tmp != null) {
                        this.m_condPermInfos.clear();
                        this.m_condPermInfos.putAll(tmp);
                    }
                }
                ex.printStackTrace();
                throw new IllegalStateException(ex.getMessage());
            }
        }
        object = this.m_condPermInfos;
        synchronized (object) {
            return (ConditionalPermissionInfoImpl)this.m_condPermInfos.get(name);
        }
    }

    public AccessControlContext getAccessControlContext(String[] signers) {
        HashMap certificates = new HashMap();
        for (int i = 0; i < signers.length; ++i) {
            StringTokenizer tok = new StringTokenizer(signers[i], ";");
            ArrayList<String> certsList = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                certsList.add(tok.nextToken());
            }
            String[] certs = certsList.toArray(new String[certsList.size()]);
            FakeCert key = new FakeCert(certs[0]);
            ArrayList<FakeCert> certList = new ArrayList<FakeCert>();
            certificates.put(key, certList);
            certList.add(key);
            for (int j = 1; j < certs.length; ++j) {
                certList.add(new FakeCert(certs[j]));
            }
        }
        final FakeBundle fake = new FakeBundle(certificates);
        ProtectionDomain domain = new ProtectionDomain(null, null){

            public boolean implies(Permission permission) {
                ArrayList posts = new ArrayList();
                Boolean result = ConditionalPermissionAdminImpl.this.m_pai.hasPermission("", fake, permission, ConditionalPermissionAdminImpl.this, this, null);
                if (result != null) {
                    return result;
                }
                if (ConditionalPermissionAdminImpl.this.eval(posts, new Module(){

                    public Bundle getBundle() {
                        return fake;
                    }

                    public List<Capability> getCapabilities() {
                        return null;
                    }

                    public Class getClassByDelegation(String arg0) throws ClassNotFoundException {
                        return null;
                    }

                    public Content getContent() {
                        return null;
                    }

                    public int getDeclaredActivationPolicy() {
                        return 0;
                    }

                    public List<Requirement> getDynamicRequirements() {
                        return null;
                    }

                    public URL getEntry(String arg0) {
                        return null;
                    }

                    public Map getHeaders() {
                        return null;
                    }

                    public String getId() {
                        return null;
                    }

                    public InputStream getInputStream(int arg0, String arg1) throws IOException {
                        return null;
                    }

                    public List<R4Library> getNativeLibraries() {
                        return null;
                    }

                    public List<Requirement> getRequirements() {
                        return null;
                    }

                    public URL getResourceByDelegation(String arg0) {
                        return null;
                    }

                    public Enumeration getResourcesByDelegation(String arg0) {
                        return null;
                    }

                    public Object getSecurityContext() {
                        return null;
                    }

                    public String getSymbolicName() {
                        return null;
                    }

                    public Version getVersion() {
                        return null;
                    }

                    public List<Wire> getWires() {
                        return null;
                    }

                    public boolean hasInputStream(int arg0, String arg1) throws IOException {
                        return false;
                    }

                    public boolean isExtension() {
                        return false;
                    }

                    public boolean isResolved() {
                        return false;
                    }

                    public void setSecurityContext(Object arg0) {
                    }
                }, permission, ConditionalPermissionAdminImpl.this.m_pai)) {
                    if (!posts.isEmpty()) {
                        return ConditionalPermissionAdminImpl.this.m_conditions.evalRecursive(posts);
                    }
                    return true;
                }
                return false;
            }
        };
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo getConditionalPermissionInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        ConditionalPermissionInfoImpl result = null;
        Map map = this.m_condPermInfos;
        synchronized (map) {
            result = (ConditionalPermissionInfoImpl)this.m_condPermInfos.get(name);
        }
        if (result == null) {
            result = new ConditionalPermissionInfoImpl(this, name, true);
            result = this.write(result.getName(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConditionalPermissionInfos() {
        Map map = this.m_condPermInfos;
        synchronized (map) {
            return new IteratorToEnumeration(new ArrayList(this.m_condPermInfos.values()).iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conditions, PermissionInfo[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        ConditionalPermissionInfoImpl result = null;
        conditions = this.notNull(conditions);
        permissions = this.notNull(permissions);
        if (name != null) {
            Map map = this.m_condPermInfos;
            synchronized (map) {
                result = (ConditionalPermissionInfoImpl)this.m_condPermInfos.get(name);
                if (result == null) {
                    result = new ConditionalPermissionInfoImpl(name, conditions, permissions, this, true);
                } else {
                    result.setConditionsAndPermissions(conditions, permissions);
                }
            }
        } else {
            result = new ConditionalPermissionInfoImpl(conditions, permissions, this, true);
        }
        return this.write(result.getName(), result);
    }

    private PermissionInfo[] notNull(PermissionInfo[] permissions) {
        if (permissions == null) {
            return ConditionalPermissionInfoImpl.PERMISSION_INFO;
        }
        return this.notNull((Object[])permissions).toArray(EMPTY_PERMISSION_INFO);
    }

    private ConditionInfo[] notNull(ConditionInfo[] conditions) {
        if (conditions == null) {
            return ConditionalPermissionInfoImpl.CONDITION_INFO;
        }
        return this.notNull((Object[])conditions).toArray(EMPTY_CONDITION_INFO);
    }

    private List notNull(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            result.add(elements[i]);
        }
        return result;
    }

    public boolean hasPermission(Module module, Content content, ProtectionDomain pd, Permission permission, boolean direct, Object admin) {
        List<ProtectionDomain> domains = null;
        List tuples = null;
        Object[] entry = null;
        if (direct) {
            domains = new ArrayList<ProtectionDomain>();
            tuples = new ArrayList();
            domains.add(pd);
        } else {
            entry = (Object[])this.m_stack.get();
            if (entry == null) {
                entry = new Object[]{new ArrayList(DomainGripper.grab()), new ArrayList()};
            } else {
                this.m_stack.set(null);
            }
            domains = (List)entry[0];
            tuples = (List)entry[1];
            if (!domains.contains(pd)) {
                domains.clear();
                domains.add(pd);
            }
        }
        if (!this.impliesLocal(module.getBundle(), content, permission)) {
            return false;
        }
        ArrayList posts = new ArrayList();
        boolean result = this.eval(posts, module, permission, admin);
        domains.remove(pd);
        if (!posts.isEmpty()) {
            tuples.add(posts);
        }
        if (domains.isEmpty()) {
            this.m_stack.set(null);
            if (!tuples.isEmpty()) {
                return this.m_conditions.evalRecursive(tuples);
            }
        } else {
            this.m_stack.set(entry);
        }
        return result;
    }

    public boolean impliesLocal(Bundle felixBundle, Content content, Permission permission) {
        return this.m_localPermissions.implies(content, felixBundle, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map map = this.m_condPermInfos;
        synchronized (map) {
            return this.m_condPermInfos.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eval(List posts, Module module, Permission permission, Object admin) {
        ArrayList condPermInfos = null;
        Map map = this.m_condPermInfos;
        synchronized (map) {
            if (this.isEmpty() && admin == null) {
                return true;
            }
            condPermInfos = new ArrayList(this.m_condPermInfos.values());
        }
        if (this.m_permissions.getPermissions(this.m_permissions.getImplicit(module.getBundle())).implies(permission, module.getBundle())) {
            return true;
        }
        ArrayList<Object[]> pls = new ArrayList<Object[]>();
        Iterator iter = condPermInfos.iterator();
        while (iter.hasNext()) {
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)iter.next();
            ConditionInfo[] conditions = cpi._getConditionInfos();
            ArrayList currentPosts = new ArrayList();
            Conditions conds = this.m_conditions.getConditions(module, conditions);
            if (!conds.isSatisfied(currentPosts, this.m_permissions.getPermissions(cpi._getPermissionInfos()), permission) || !this.m_permissions.getPermissions(cpi._getPermissionInfos()).implies(permission, null)) continue;
            if (currentPosts.isEmpty()) {
                pls.add(new Object[]{cpi, null});
                break;
            }
            pls.add(new Object[]{cpi, currentPosts, conds});
        }
        while (pls.size() > 1 && !((ConditionalPermissionInfoImpl)((Object[])pls.get(pls.size() - 1))[0]).isAllow()) {
            pls.remove(pls.size() - 1);
        }
        if (pls.size() == 1) {
            if (((Object[])pls.get(0))[1] != null) {
                posts.add(pls.get(0));
            }
            return ((ConditionalPermissionInfoImpl)((Object[])pls.get(0))[0]).isAllow();
        }
        iter = pls.iterator();
        while (iter.hasNext()) {
            posts.add(iter.next());
        }
        return !posts.isEmpty();
    }

    public ConditionalPermissionInfo newConditionalPermissionInfo(String encodedConditionalPermissionInfo) {
        return new ConditionalPermissionInfoImpl(encodedConditionalPermissionInfo);
    }

    public ConditionalPermissionInfo newConditionalPermissionInfo(String name, ConditionInfo[] conditions, PermissionInfo[] permissions, String access) {
        return new ConditionalPermissionInfoImpl(name, conditions, permissions, this, access.equals("allow"));
    }

    public ConditionalPermissionUpdate newConditionalPermissionUpdate() {
        return new ConditionalPermissionUpdate(){
            List current = null;
            List out = null;
            {
                Map map = ConditionalPermissionAdminImpl.this.m_condPermInfos;
                synchronized (map) {
                    this.current = new ArrayList(ConditionalPermissionAdminImpl.this.m_condPermInfos.values());
                    this.out = new ArrayList(ConditionalPermissionAdminImpl.this.m_condPermInfos.values());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean commit() {
                Map map = ConditionalPermissionAdminImpl.this.m_condPermInfos;
                synchronized (map) {
                    if (((Object)this.current).equals(new ArrayList(ConditionalPermissionAdminImpl.this.m_condPermInfos.values()))) {
                        ConditionalPermissionAdminImpl.this.m_condPermInfos.clear();
                        ConditionalPermissionAdminImpl.this.write(null, null);
                        Iterator iter = this.out.iterator();
                        while (iter.hasNext()) {
                            ConditionalPermissionInfoImpl cpii = (ConditionalPermissionInfoImpl)iter.next();
                            ConditionalPermissionAdminImpl.this.write(cpii.getName(), cpii);
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }

            public List getConditionalPermissionInfos() {
                return this.out;
            }
        };
    }

    public boolean handlePAHandle(BundleProtectionDomain pd) {
        Object[] entry = (Object[])this.m_stack.get();
        if (entry == null) {
            entry = new Object[]{new ArrayList(DomainGripper.grab()), new ArrayList()};
        }
        ((List)entry[0]).remove(pd);
        if (((List)entry[0]).isEmpty()) {
            this.m_stack.set(null);
            if (!((List)entry[1]).isEmpty()) {
                return this.m_conditions.evalRecursive((List)entry[1]);
            }
        } else {
            this.m_stack.set(entry);
        }
        return true;
    }

    public void clearPD() {
        this.m_stack.set(null);
    }

    private static class FakeCert
    extends X509Certificate {
        private final Principal m_principal;

        public FakeCert(final String principal) {
            this.m_principal = new Principal(){

                public String getName() {
                    return principal;
                }
            };
        }

        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        }

        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        }

        public int getBasicConstraints() {
            return 0;
        }

        public Principal getIssuerDN() {
            return null;
        }

        public boolean[] getIssuerUniqueID() {
            return null;
        }

        public boolean[] getKeyUsage() {
            return null;
        }

        public Date getNotAfter() {
            return null;
        }

        public Date getNotBefore() {
            return null;
        }

        public BigInteger getSerialNumber() {
            return null;
        }

        public String getSigAlgName() {
            return null;
        }

        public String getSigAlgOID() {
            return null;
        }

        public byte[] getSigAlgParams() {
            return null;
        }

        public byte[] getSignature() {
            return null;
        }

        public Principal getSubjectDN() {
            return this.m_principal;
        }

        public boolean[] getSubjectUniqueID() {
            return null;
        }

        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return null;
        }

        public int getVersion() {
            return 0;
        }

        public byte[] getEncoded() throws CertificateEncodingException {
            return null;
        }

        public PublicKey getPublicKey() {
            return null;
        }

        public String toString() {
            return this.m_principal.getName();
        }

        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        public Set getCriticalExtensionOIDs() {
            return null;
        }

        public byte[] getExtensionValue(String arg0) {
            return null;
        }

        public Set getNonCriticalExtensionOIDs() {
            return null;
        }

        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private static class FakeBundle
    implements Bundle {
        private final Map m_certs;

        public FakeBundle(Map certs) {
            this.m_certs = Collections.unmodifiableMap(certs);
        }

        public Enumeration findEntries(String arg0, String arg1, boolean arg2) {
            return null;
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public long getBundleId() {
            return -1L;
        }

        public URL getEntry(String arg0) {
            return null;
        }

        public Enumeration getEntryPaths(String arg0) {
            return null;
        }

        public Dictionary getHeaders() {
            return new Hashtable();
        }

        public Dictionary getHeaders(String arg0) {
            return new Hashtable();
        }

        public long getLastModified() {
            return 0L;
        }

        public String getLocation() {
            return "";
        }

        public ServiceReference[] getRegisteredServices() {
            return null;
        }

        public URL getResource(String arg0) {
            return null;
        }

        public Enumeration getResources(String arg0) throws IOException {
            return null;
        }

        public ServiceReference[] getServicesInUse() {
            return null;
        }

        public Map getSignerCertificates(int arg0) {
            return this.m_certs;
        }

        public int getState() {
            return 1;
        }

        public String getSymbolicName() {
            return null;
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public boolean hasPermission(Object arg0) {
            return false;
        }

        public Class loadClass(String arg0) throws ClassNotFoundException {
            return null;
        }

        public void start() throws BundleException {
            throw new IllegalStateException();
        }

        public void start(int arg0) throws BundleException {
            throw new IllegalStateException();
        }

        public void stop() throws BundleException {
            throw new IllegalStateException();
        }

        public void stop(int arg0) throws BundleException {
            throw new IllegalStateException();
        }

        public void uninstall() throws BundleException {
            throw new IllegalStateException();
        }

        public void update() throws BundleException {
            throw new IllegalStateException();
        }

        public void update(InputStream arg0) throws BundleException {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private static class OrderedHashMap
    extends HashMap {
        private final List m_order = new ArrayList();

        private OrderedHashMap() {
        }

        public Object put(Object key, Object value) {
            Object result = super.put(key, value);
            if (result != value) {
                this.m_order.remove(key);
                this.m_order.add(key);
            }
            return result;
        }

        public void putAll(Map map) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Set keySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return OrderedHashMap.this.m_order.iterator();
                }

                public int size() {
                    return OrderedHashMap.this.m_order.size();
                }
            };
        }

        public Set entrySet() {
            return new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        Iterator m_iter;
                        {
                            this.m_iter = OrderedHashMap.this.m_order.iterator();
                        }

                        public boolean hasNext() {
                            return this.m_iter.hasNext();
                        }

                        public Object next() {
                            final Object key = this.m_iter.next();
                            return new Map.Entry(){

                                public Object getKey() {
                                    return key;
                                }

                                public Object getValue() {
                                    return OrderedHashMap.this.get(key);
                                }

                                public Object setValue(Object arg0) {
                                    throw new IllegalStateException("Not Implemented");
                                }
                            };
                        }

                        public void remove() {
                            throw new IllegalStateException("Not Implemented");
                        }
                    };
                }

                public int size() {
                    return OrderedHashMap.this.m_order.size();
                }
            };
        }

        public Collection values() {
            ArrayList result = new ArrayList();
            Iterator iter = this.m_order.iterator();
            while (iter.hasNext()) {
                result.add(super.get(iter.next()));
            }
            return result;
        }

        public Object remove(Object key) {
            Object result = super.remove(key);
            if (result != null) {
                this.m_order.remove(key);
            }
            return result;
        }

        public void clear() {
            super.clear();
            this.m_order.clear();
        }
    }
}

