/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionInfoImpl;
import org.apache.felix.framework.security.util.Permissions;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public final class Conditions {
    private static final ThreadLocal m_conditionStack = new ThreadLocal();
    private static final Map m_conditionCache = new WeakHashMap();
    private final Map m_cache = new WeakHashMap();
    private final BundleRevisionImpl m_module;
    private final ConditionInfo[] m_conditionInfos;
    private final Condition[] m_conditions;
    private final SecureAction m_action;

    public Conditions(SecureAction action) {
        this(null, null, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Conditions(BundleRevisionImpl module, ConditionInfo[] conditionInfos, SecureAction action) {
        this.m_module = module;
        this.m_conditionInfos = conditionInfos;
        if (module != null && conditionInfos != null) {
            Map map = m_conditionCache;
            synchronized (map) {
                Condition[] conditions;
                HashMap<ConditionInfo[], Condition[]> conditionMap = (HashMap<ConditionInfo[], Condition[]>)m_conditionCache.get(module);
                if (conditionMap == null) {
                    conditionMap = new HashMap<ConditionInfo[], Condition[]>();
                    conditionMap.put(this.m_conditionInfos, new Condition[this.m_conditionInfos.length]);
                    m_conditionCache.put(module, conditionMap);
                }
                if ((conditions = (Condition[])conditionMap.get(this.m_conditionInfos)) == null) {
                    conditions = new Condition[this.m_conditionInfos.length];
                    conditionMap.put(this.m_conditionInfos, conditions);
                }
                this.m_conditions = conditions;
            }
        } else {
            this.m_conditions = null;
        }
        this.m_action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conditions getConditions(BundleRevisionImpl key, ConditionInfo[] conditions) {
        Conditions result = null;
        WeakHashMap<BundleRevisionImpl, Conditions> index = null;
        WeakHashMap<BundleRevisionImpl, Conditions> weakHashMap = this.m_cache;
        synchronized (weakHashMap) {
            index = (WeakHashMap<BundleRevisionImpl, Conditions>)this.m_cache.get(conditions);
            if (index == null) {
                index = new WeakHashMap<BundleRevisionImpl, Conditions>();
                this.m_cache.put(conditions, index);
            }
        }
        weakHashMap = index;
        synchronized (weakHashMap) {
            if (key != null) {
                result = (Conditions)index.get(key);
            }
        }
        if (result == null) {
            result = new Conditions(key, conditions, this.m_action);
            weakHashMap = index;
            synchronized (weakHashMap) {
                index.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean isSatisfied(List posts, Permissions permissions, Permission permission) {
        if (this.m_conditionInfos == null) {
            return true;
        }
        boolean check = true;
        int i = 0;
        while (i < this.m_conditionInfos.length) {
            block27: {
                if (this.m_module == null) {
                    return true;
                }
                try {
                    Condition condition = null;
                    boolean add = false;
                    Class<?> clazz = Class.forName(this.m_conditionInfos[i].getType());
                    Condition[] conditionArray = this.m_conditions;
                    // MONITORENTER : this.m_conditions
                    if (this.m_conditions[i] == null) {
                        this.m_conditions[i] = this.createCondition(this.m_module.getBundle(), clazz, this.m_conditionInfos[i]);
                    }
                    condition = this.m_conditions[i];
                    // MONITOREXIT : conditionArray
                    Object current = m_conditionStack.get();
                    if (current != null && (current instanceof HashSet ? ((HashSet)current).contains(clazz) : current == clazz)) {
                        return false;
                    }
                    if (condition.isPostponed()) {
                        if (check && !permissions.implies(permission, null)) {
                            return false;
                        }
                        check = false;
                        posts.add(new Object[]{condition, new Integer(i)});
                        break block27;
                    }
                    if (current == null) {
                        m_conditionStack.set(clazz);
                    } else if (current instanceof HashSet) {
                        if (((HashSet)current).contains(clazz)) {
                            return false;
                        }
                        ((HashSet)current).add(clazz);
                    } else {
                        if (current == clazz) {
                            return false;
                        }
                        HashSet<Object> frame = new HashSet<Object>();
                        frame.add(current);
                        frame.add(clazz);
                        m_conditionStack.set(frame);
                        current = frame;
                    }
                    try {
                        boolean mutable = condition.isMutable();
                        boolean result = condition.isSatisfied();
                        if (!mutable && condition != Condition.TRUE && condition != Condition.FALSE) {
                            Condition[] conditionArray2 = this.m_conditions;
                            // MONITORENTER : this.m_conditions
                            this.m_conditions[i] = result ? Condition.TRUE : Condition.FALSE;
                            // MONITOREXIT : conditionArray2
                        }
                        if (!result) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    finally {
                        if (current == null) {
                            m_conditionStack.set(null);
                        } else {
                            ((HashSet)current).remove(clazz);
                            if (((HashSet)current).isEmpty()) {
                                m_conditionStack.set(null);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean evalRecursive(List entries) {
        contexts = new HashMap<Class<?>, Hashtable<Object, Object>>();
        iter = entries.iterator();
        do lbl-1000:
        // 3 sources

        {
            if (iter.hasNext() == false) return true;
            tuples = (List)iter.next();
            inner = tuples.iterator();
            block6: while (true) {
                block18: {
                    if (inner.hasNext() == false) return false;
                    entry = (Object[])inner.next();
                    conditions = (List)entry[1];
                    if (conditions != null) break block18;
                    if (((ConditionalPermissionInfoImpl)entry[0]).isAllow()) ** GOTO lbl-1000
                    return false;
                }
                iter2 = conditions.iterator();
                while (iter2.hasNext()) {
                    condEntry = (Object[])iter2.next();
                    cond = (Condition)condEntry[0];
                    context = (Hashtable<Object, Object>)contexts.get(cond.getClass());
                    if (context == null) {
                        context = new Hashtable<Object, Object>();
                        contexts.put(cond.getClass(), context);
                    }
                    if ((current /* !! */  = Conditions.m_conditionStack.get()) == null) {
                        Conditions.m_conditionStack.set(cond.getClass());
                    } else if (current /* !! */  instanceof HashSet) {
                        ((HashSet)current /* !! */ ).add(cond.getClass());
                    } else {
                        frame = new HashSet<Object>();
                        frame.add(current /* !! */ );
                        frame.add(cond.getClass());
                        Conditions.m_conditionStack.set(frame);
                        current /* !! */  = frame;
                    }
                    mutable = cond.isMutable();
                    try {
                        result = cond.isSatisfied(new Condition[]{cond}, context);
                    }
                    finally {
                        if (current /* !! */  == null) {
                            Conditions.m_conditionStack.set(null);
                        } else {
                            ((HashSet)current /* !! */ ).remove(cond.getClass());
                            if (((HashSet)current /* !! */ ).isEmpty()) {
                                Conditions.m_conditionStack.set(null);
                            }
                        }
                    }
                    if (!mutable && cond != Condition.TRUE && cond != Condition.FALSE) {
                        var15_16 = ((Conditions)entry[2]).m_conditions;
                        // MONITORENTER : ((org.apache.felix.framework.security.util.Conditions)entry[2]).m_conditions
                        ((Conditions)entry[2]).m_conditions[((Integer)condEntry[1]).intValue()] = result != false ? Condition.TRUE : Condition.FALSE;
                        // MONITOREXIT : var15_16
                    }
                    if (result) continue;
                    continue block6;
                }
                break;
            }
        } while (((ConditionalPermissionInfoImpl)entry[0]).isAllow());
        return false;
    }

    private Condition createCondition(Bundle bundle, Class clazz, ConditionInfo info) throws Exception {
        try {
            return (Condition)this.m_action.getMethod(clazz, "getCondition", new Class[]{Bundle.class, ConditionInfo.class}).invoke(null, bundle, info);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return (Condition)this.m_action.getConstructor(clazz, new Class[]{Bundle.class, ConditionInfo.class}).newInstance(bundle, info);
        }
    }
}

