/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.util;

import java.io.File;
import java.io.FilePermission;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PropertyPermission;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class Permissions {
    private static final ClassLoader m_classLoader = Permissions.class.getClassLoader();
    private static final Map m_permissionCache = new HashMap();
    private static final Map m_permissions = new HashMap();
    private static final ReferenceQueue m_permissionsQueue = new ReferenceQueue();
    private static final ThreadLocal m_stack = new ThreadLocal();
    private final Map m_cache;
    private final ReferenceQueue m_queue;
    private final BundleContext m_context;
    private final PermissionInfo[] m_permissionInfos;
    private final boolean m_allPermission;
    private final SecureAction m_action;
    public static final AllPermission ALL_PERMISSION = new AllPermission();
    private static final PermissionInfo[] IMPLICIT = new PermissionInfo[]{new PermissionInfo(FilePermission.class.getName(), "-", "read,write,delete")};

    Permissions(PermissionInfo[] permissionInfos, BundleContext context, SecureAction action) {
        this.m_context = context;
        this.m_permissionInfos = permissionInfos;
        this.m_cache = new HashMap();
        this.m_queue = new ReferenceQueue();
        this.m_action = action;
        for (int i = 0; i < this.m_permissionInfos.length; ++i) {
            if (!this.m_permissionInfos[i].getType().equals(AllPermission.class.getName())) continue;
            this.m_allPermission = true;
            return;
        }
        this.m_allPermission = false;
    }

    public Permissions(BundleContext context, SecureAction action) {
        this.m_context = context;
        this.m_permissionInfos = null;
        this.m_cache = null;
        this.m_queue = null;
        this.m_allPermission = true;
        this.m_action = action;
    }

    public PermissionInfo[] getImplicit(Bundle bundle) {
        return new PermissionInfo[]{IMPLICIT[0], new PermissionInfo(PropertyPermission.class.getName(), "org.osgi.framework.*", "read"), new PermissionInfo(AdminPermission.class.getName(), "(id=" + bundle.getBundleId() + ")", "class,metadata,resource,context"), new PermissionInfo(CapabilityPermission.class.getName(), "(|(capability.namespace=osgi.ee)(capability.namespace=osgi.native))", "require"), new PermissionInfo(PackagePermission.class.getName(), "(package.name=java.*)", "import"), new PermissionInfo(ServicePermission.class.getName(), "org.osgi.service.condition.Condition", "get")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions getPermissions(PermissionInfo[] permissionInfos) {
        this.cleanUp(m_permissionsQueue, m_permissions);
        Permissions result = null;
        Map map = m_permissions;
        synchronized (map) {
            result = (Permissions)m_permissions.get(new Entry(permissionInfos));
        }
        if (result == null) {
            PermissionInfo[] permissionInfosClone = new PermissionInfo[permissionInfos.length];
            System.arraycopy(permissionInfos, 0, permissionInfosClone, 0, permissionInfos.length);
            result = new Permissions(permissionInfosClone, this.m_context, this.m_action);
            Map map2 = m_permissions;
            synchronized (map2) {
                m_permissions.put(new Entry(permissionInfos, m_permissionsQueue), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(ReferenceQueue queue, Map cache) {
        Entry entry = (Entry)queue.poll();
        while (entry != null) {
            Map map = cache;
            synchronized (map) {
                cache.remove(entry);
            }
            entry = (Entry)queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission target, final Bundle bundle) {
        if (this.m_allPermission) {
            return true;
        }
        Class<?> targetClass = target.getClass();
        this.cleanUp(this.m_queue, this.m_cache);
        if (bundle != null && targetClass == FilePermission.class) {
            for (int i = 0; i < this.m_permissionInfos.length; ++i) {
                Permission source;
                if (!this.m_permissionInfos[i].getType().equals(FilePermission.class.getName())) continue;
                String postfix = "";
                String name = this.m_permissionInfos[i].getName();
                if (!"<<ALL FILES>>".equals(name)) {
                    if (name.endsWith("*") || name.endsWith("-")) {
                        postfix = name.substring(name.length() - 1);
                        name = name.substring(0, name.length() - 1);
                    }
                    if (!new File(name).isAbsolute()) {
                        BundleContext context = (BundleContext)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return bundle.getBundleContext();
                            }
                        });
                        if (context == null) break;
                        name = this.m_action.getAbsolutePath(new File(context.getDataFile(""), name));
                    }
                    if (postfix.length() > 0) {
                        name = name.length() > 0 && !name.endsWith("/") ? name + "/" + postfix : name + postfix;
                    }
                }
                if (!(source = this.createPermission(new PermissionInfo(FilePermission.class.getName(), name, this.m_permissionInfos[i].getActions()), targetClass)).implies(target)) continue;
                return true;
            }
            return false;
        }
        Object current = m_stack.get();
        if (current == null) {
            m_stack.set(targetClass);
        } else if (current instanceof HashSet) {
            if (((HashSet)current).contains(targetClass)) {
                return false;
            }
            ((HashSet)current).add(targetClass);
        } else {
            if (current == targetClass) {
                return false;
            }
            HashSet<Object> frame = new HashSet<Object>();
            frame.add(current);
            frame.add(targetClass);
            m_stack.set(frame);
            current = frame;
        }
        try {
            SoftReference collectionEntry = null;
            PermissionCollection collection = null;
            Map source = this.m_cache;
            synchronized (source) {
                collectionEntry = (SoftReference)this.m_cache.get(targetClass);
            }
            if (collectionEntry != null) {
                collection = (PermissionCollection)collectionEntry.get();
            }
            if (collection == null) {
                collection = target.newPermissionCollection();
                if (collection == null) {
                    collection = new DefaultPermissionCollection();
                }
                for (int i = 0; i < this.m_permissionInfos.length; ++i) {
                    Permission permission;
                    String permissionType;
                    PermissionInfo permissionInfo = this.m_permissionInfos[i];
                    String infoType = permissionInfo.getType();
                    if (!infoType.equals(permissionType = targetClass.getName()) || (permission = this.createPermission(permissionInfo, targetClass)) == null) continue;
                    collection.add(permission);
                }
                Map map = this.m_cache;
                synchronized (map) {
                    this.m_cache.put(new Entry(target.getClass(), this.m_queue), new SoftReference<PermissionCollection>(collection));
                }
            }
            boolean bl = collection.implies(target);
            return bl;
        }
        finally {
            if (current == null) {
                m_stack.set(null);
            } else {
                ((HashSet)current).remove(targetClass);
                if (((HashSet)current).isEmpty()) {
                    m_stack.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permission addToCache(String encoded, Permission permission) {
        if (permission == null) {
            return null;
        }
        Map map = m_permissionCache;
        synchronized (map) {
            HashMap<Entry, Entry> inner = null;
            SoftReference ref = (SoftReference)m_permissionCache.get(encoded);
            if (ref != null) {
                inner = (HashMap<Entry, Entry>)ref.get();
            }
            if (inner == null) {
                inner = new HashMap<Entry, Entry>();
                m_permissionCache.put(encoded, new SoftReference(inner));
            }
            inner.put(new Entry(permission.getClass()), new Entry(permission));
        }
        return permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permission getFromCache(String encoded, Class target) {
        Map map = m_permissionCache;
        synchronized (map) {
            SoftReference ref = (SoftReference)m_permissionCache.get(encoded);
            if (ref != null) {
                Map inner = (Map)ref.get();
                if (inner != null) {
                    Entry entry = (Entry)inner.get(target);
                    if (entry != null) {
                        Permission result = (Permission)entry.get();
                        if (result != null) {
                            return result;
                        }
                        inner.remove(entry);
                    }
                    if (inner.isEmpty()) {
                        m_permissionCache.remove(encoded);
                    }
                } else {
                    m_permissionCache.remove(encoded);
                }
            }
        }
        return null;
    }

    private Permission createPermission(final PermissionInfo permissionInfo, final Class target) {
        return (Permission)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Permission cached = Permissions.this.getFromCache(permissionInfo.getEncoded(), target);
                if (cached != null) {
                    return cached;
                }
                try {
                    if (m_classLoader.loadClass(target.getName()) == target) {
                        return Permissions.this.addToCache(permissionInfo.getEncoded(), Permissions.this.createPermission(permissionInfo.getName(), permissionInfo.getActions(), target));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ServiceReference[] refs = null;
                try {
                    refs = Permissions.this.m_context.getServiceReferences(PackageAdmin.class.getName(), null);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
                if (refs != null) {
                    for (int i = 0; i < refs.length; ++i) {
                        ExportedPackage[] exports;
                        PackageAdmin admin = (PackageAdmin)Permissions.this.m_context.getService(refs[i]);
                        if (admin == null) continue;
                        Permission result = null;
                        Bundle bundle = admin.getBundle(target);
                        if (bundle != null && (exports = admin.getExportedPackages(bundle)) != null) {
                            String name = target.getName();
                            name = name.substring(0, name.lastIndexOf(46));
                            for (int j = 0; j < exports.length; ++j) {
                                if (!exports[j].getName().equals(name)) continue;
                                result = Permissions.this.createPermission(permissionInfo.getName(), permissionInfo.getActions(), target);
                                break;
                            }
                        }
                        Permissions.this.m_context.ungetService(refs[i]);
                        return Permissions.this.addToCache(permissionInfo.getEncoded(), result);
                    }
                }
                return null;
            }
        });
    }

    private Permission createPermission(String name, String action, Class target) {
        try {
            try {
                return (Permission)this.m_action.getConstructor(target, new Class[]{String.class, String.class}).newInstance(name, action);
            }
            catch (NoSuchMethodException ex) {
                return (Permission)this.m_action.getConstructor(target, new Class[]{String.class}).newInstance(name);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class DefaultPermissionCollection
    extends PermissionCollection {
        private final Map m_perms = new HashMap();

        private DefaultPermissionCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Permission perm) {
            Map map = this.m_perms;
            synchronized (map) {
                this.m_perms.put(perm, perm);
            }
        }

        public Enumeration elements() {
            throw new IllegalStateException("Not implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean implies(Permission perm) {
            Map perms = null;
            Map map = this.m_perms;
            synchronized (map) {
                perms = this.m_perms;
            }
            Permission permission = (Permission)perms.get(perm);
            if (permission != null && permission.implies(perm)) {
                return true;
            }
            for (Permission current : perms.values()) {
                if (current == null || current == permission || !current.implies(perm)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Entry
    extends WeakReference {
        private final int m_hashCode;

        Entry(Object entry, ReferenceQueue queue) {
            super(entry, queue);
            this.m_hashCode = entry.hashCode();
        }

        Entry(Object entry) {
            super(entry);
            this.m_hashCode = entry.hashCode();
        }

        @Override
        public Object get() {
            return super.get();
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Object entry = super.get();
            if (o instanceof Entry) {
                Object otherEntry = ((Entry)o).get();
                if (entry == null) {
                    return otherEntry == null;
                }
                if (otherEntry == null) {
                    return false;
                }
                if (!entry.getClass().equals(otherEntry.getClass())) {
                    return false;
                }
                if (entry instanceof Object[]) {
                    return Arrays.equals((Object[])entry, (Object[])otherEntry);
                }
                return entry.equals(((Entry)o).get());
            }
            return false;
        }
    }
}

