/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.console.stdio;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.command.CommandSession;

public class Console
implements Runnable {
    StringBuilder sb;
    CommandSession session;
    List<CharSequence> history = new ArrayList<CharSequence>();
    int current = 0;
    boolean quit;

    public void setSession(CommandSession session) {
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.quit) {
                try {
                    CharSequence line = this.getLine(this.session.getKeyboard());
                    if (line != null) {
                        Object result;
                        this.history.add(line);
                        if (this.history.size() > 40) {
                            this.history.remove(0);
                        }
                        if ((result = this.session.execute(line)) == null) continue;
                        this.session.getConsole().println(this.session.format(result, 0));
                        continue;
                    }
                    this.quit = true;
                }
                catch (InvocationTargetException ite) {
                    this.session.getConsole().println("E: " + ite.getTargetException());
                    this.session.put("exception", (Object)ite.getTargetException());
                }
                catch (Throwable e) {
                    if (this.quit) continue;
                    this.session.getConsole().println("E: " + e.getMessage());
                    this.session.put("exception", (Object)e);
                }
            }
            return;
        }
        catch (Exception e) {
            if (this.quit) return;
            e.printStackTrace();
        }
    }

    CharSequence getLine(InputStream in) throws IOException {
        this.sb = new StringBuilder();
        this.session.getConsole().print("$ ");
        boolean outer = false;
        block10: while (!this.quit) {
            this.session.getConsole().flush();
            int c = in.read();
            if (c < 0) {
                this.quit = true;
                continue;
            }
            switch (c) {
                case 13: {
                    continue block10;
                }
                case 10: {
                    if (!outer && this.sb.length() > 0) {
                        return this.sb;
                    }
                    this.session.getConsole().print("$ ");
                    continue block10;
                }
                case 27: {
                    c = in.read();
                    if (c != 91) continue block10;
                    c = in.read();
                    this.session.getConsole().print("\b\b\b");
                    switch (c) {
                        case 65: {
                            this.history(this.current - 1);
                            break;
                        }
                        case 66: {
                            this.history(this.current + 1);
                            break;
                        }
                    }
                    continue block10;
                }
                case 8: {
                    if (this.sb.length() <= 0) continue block10;
                    this.session.getConsole().print("\b \b");
                    this.sb.deleteCharAt(this.sb.length() - 1);
                    continue block10;
                }
            }
            this.sb.append((char)c);
        }
        return null;
    }

    void history(int n) {
        if (n < 0 || n > this.history.size()) {
            return;
        }
        this.current = n;
        for (int i = 0; i < this.sb.length(); ++i) {
            this.session.getConsole().print("\b \b");
        }
        this.sb = new StringBuilder(this.history.get(this.current));
        this.session.getConsole().print(this.sb);
    }

    public void close() {
        this.quit = true;
    }

    public void open() {
    }
}

