/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.osgi;

import java.util.List;
import org.apache.felix.gogo.runtime.osgi.OSGiShell;
import org.apache.felix.gogo.runtime.shell.CommandShellImpl;
import org.apache.felix.gogo.runtime.shell.Reflective;
import org.osgi.framework.ServiceReference;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCommand
extends Reflective
implements Function {
    ServiceReference ref;
    OSGiShell shell;
    String name;

    public ServiceCommand(OSGiShell shell, ServiceReference ref, String name) {
        this.shell = shell;
        this.ref = ref;
        this.name = name;
    }

    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
        try {
            Object target = this.shell.bundle.getBundleContext().getService(this.ref);
            if (target instanceof Function) {
                Object object = ((Function)target).execute(session, arguments);
                return object;
            }
            Object result = this.method(session, target, this.name, arguments);
            if (result != CommandShellImpl.NO_SUCH_COMMAND) {
                Object object = result;
                return object;
            }
            throw new IllegalArgumentException("Service does not implement promised command " + this.ref + " " + this.name);
        }
        finally {
            this.shell.bundle.getBundleContext().ungetService(this.ref);
        }
    }
}

