/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.felix.gogo.runtime.shell.CommandSessionImpl;
import org.apache.felix.gogo.runtime.shell.Parser;
import org.apache.felix.gogo.runtime.shell.Pipe;
import org.apache.felix.gogo.runtime.shell.Reflective;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Closure
extends Reflective
implements Function {
    private static final long serialVersionUID = 1L;
    final CharSequence source;
    final Closure parent;
    CommandSessionImpl session;
    List<Object> parms;

    Closure(CommandSessionImpl session, Closure parent, CharSequence source) {
        this.session = session;
        this.parent = parent;
        this.source = source;
    }

    public Object execute(CommandSession x, List<Object> values) throws Exception {
        this.parms = values;
        Parser parser = new Parser(this.source);
        ArrayList<Pipe> pipes = new ArrayList<Pipe>();
        List<List<List<CharSequence>>> program = parser.program();
        for (List<List<CharSequence>> statements : program) {
            Pipe current = new Pipe(this, statements);
            if (pipes.isEmpty()) {
                if (current.out == null) {
                    current.setIn(this.session.in);
                    current.setOut(this.session.out);
                    current.setErr(this.session.err);
                }
            } else {
                Pipe previous = (Pipe)pipes.get(pipes.size() - 1);
                previous.connect(current);
            }
            pipes.add(current);
        }
        if (pipes.size() == 0) {
            return null;
        }
        if (pipes.size() == 1) {
            ((Pipe)pipes.get(0)).run();
        } else {
            for (Pipe pipe : pipes) {
                pipe.start();
            }
            for (Pipe pipe : pipes) {
                pipe.join();
            }
        }
        Pipe last = (Pipe)pipes.remove(pipes.size() - 1);
        for (Pipe pipe : pipes) {
            if (pipe.exception == null) continue;
            this.session.err.println("pipe: " + pipe.exception);
        }
        if (last.exception != null) {
            throw last.exception;
        }
        if (last.result instanceof Object[]) {
            return Arrays.asList((Object[])last.result);
        }
        return last.result;
    }

    Object executeStatement(List<CharSequence> statement) throws Exception {
        if (Boolean.TRUE.equals(this.session.get("echo"))) {
            StringBuilder buf = new StringBuilder("+");
            for (CharSequence token : statement) {
                buf.append(' ');
                buf.append(token);
            }
            this.session.err.println(buf);
        }
        if (statement.size() == 1 && statement.get(0).charAt(0) == '(') {
            return this.eval(statement.get(0));
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (CharSequence token : statement) {
            Object v = this.eval(token);
            if (v != null && v == this.parms) {
                for (Object p : this.parms) {
                    values.add(p);
                }
                continue;
            }
            values.add(v);
        }
        Object result = this.execute(values.remove(0), values);
        return result;
    }

    private Object execute(Object cmd, List<Object> values) throws Exception {
        if (cmd == null) {
            if (values.isEmpty()) {
                return null;
            }
            throw new IllegalArgumentException("Command name evaluates to null");
        }
        if (cmd instanceof CharSequence) {
            String scmd = cmd.toString();
            if (values.size() > 0 && "=".equals(values.get(0))) {
                if (values.size() == 1) {
                    return this.session.variables.remove(scmd);
                }
                if (values.size() == 2) {
                    Object value = values.get(1);
                    if (value instanceof CharSequence) {
                        value = this.eval((CharSequence)value);
                    }
                    return this.assignment(scmd, value);
                }
                Object value = this.execute(values.get(1), values.subList(2, values.size()));
                return this.assignment(scmd, value);
            }
            String scopedFunction = scmd;
            Object x = this.get(scmd);
            if (!(x instanceof Function)) {
                if (scmd.indexOf(58) < 0) {
                    scopedFunction = "*:" + scmd;
                }
                if ((x = this.get(scopedFunction)) == null || !(x instanceof Function)) {
                    throw new IllegalArgumentException("Command not found:  " + scopedFunction);
                }
            }
            return ((Function)x).execute((CommandSession)this.session, values);
        }
        if (values.isEmpty()) {
            return cmd;
        }
        return this.method(this.session, cmd, values.remove(0).toString(), values);
    }

    private Object assignment(String name, Object value) {
        this.session.variables.put(name, value);
        return value;
    }

    private Object eval(CharSequence seq) throws Exception {
        Object res = null;
        StringBuilder sb = null;
        Parser p = new Parser(seq);
        int start = p.current;
        block8: while (!p.eof()) {
            char c = p.peek();
            if (!(p.escaped || c != '$' && c != '(' && c != '\'' && c != '\"' && c != '[' && c != '{')) {
                if (start != p.current || res != null) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    if (res != null) {
                        if (res == this.parms) {
                            for (int i = 0; i < this.parms.size(); ++i) {
                                if (i > 0) {
                                    sb.append(' ');
                                }
                                sb.append(this.parms.get(i));
                            }
                        } else {
                            sb.append(res);
                        }
                        res = null;
                    }
                    if (start != p.current) {
                        sb.append(new Parser(p.text.subSequence(start, p.current)).unescape());
                        start = p.current;
                        continue;
                    }
                }
                switch (c) {
                    case '\'': {
                        p.next();
                        p.quote(c);
                        res = new Parser(p.text.subSequence(start + 1, p.current - 1)).unescape();
                        start = p.current;
                        continue block8;
                    }
                    case '\"': {
                        p.next();
                        p.quote(c);
                        res = this.eval(p.text.subSequence(start + 1, p.current - 1));
                        start = p.current;
                        continue block8;
                    }
                    case '[': {
                        p.next();
                        res = this.array(seq.subSequence(start + 1, p.find(']', '[') - 1));
                        start = p.current;
                        continue block8;
                    }
                    case '(': {
                        p.next();
                        Closure cl = new Closure(this.session, this, p.text.subSequence(start + 1, p.find(')', '(') - 1));
                        res = cl.execute(this.session, this.parms);
                        start = p.current;
                        continue block8;
                    }
                    case '{': {
                        p.next();
                        res = new Closure(this.session, this, p.text.subSequence(start + 1, p.find('}', '{') - 1));
                        start = p.current;
                        continue block8;
                    }
                    case '$': {
                        p.next();
                        res = this.var(p.findVar());
                        start = p.current;
                        continue block8;
                    }
                }
            }
            p.next();
        }
        if (start != p.current) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (res != null) {
                if (res == this.parms) {
                    for (Object v : this.parms) {
                        sb.append(v);
                    }
                } else {
                    sb.append(res);
                }
                res = null;
            }
            sb.append(new Parser(p.text.subSequence(start, p.current)).unescape());
        }
        if (sb != null) {
            if (res != null) {
                if (res == this.parms) {
                    for (int i = 0; i < this.parms.size(); ++i) {
                        if (i > 0) {
                            sb.append(' ');
                        }
                        sb.append(this.parms.get(i));
                    }
                } else {
                    sb.append(res);
                }
            }
            res = sb;
        }
        if (res instanceof CharSequence) {
            String r = res.toString();
            if ("null".equals(r)) {
                return null;
            }
            if ("false".equals(r)) {
                return false;
            }
            if ("true".equals(r)) {
                return true;
            }
            return r;
        }
        return res;
    }

    private Object array(CharSequence array) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Parser p = new Parser(array);
        while (!p.eof()) {
            CharSequence token = p.value();
            p.ws();
            if (p.peek() == '=') {
                p.next();
                p.ws();
                if (!p.eof()) {
                    CharSequence value = p.messy();
                    map.put(this.eval(token), this.eval(value));
                }
            } else {
                list.add(this.eval(token));
            }
            if (p.peek() == ',') {
                p.next();
            }
            p.ws();
        }
        p.ws();
        if (!p.eof()) {
            throw new IllegalArgumentException("Invalid array syntax: " + array);
        }
        if (map.size() != 0 && list.size() != 0) {
            throw new IllegalArgumentException("You can not mix maps and arrays: " + array);
        }
        if (map.size() > 0) {
            return map;
        }
        return list;
    }

    private Object var(CharSequence var) throws Exception {
        if (var.charAt(0) == '{') {
            var = var.subSequence(1, var.length() - 1);
        }
        Object v = this.eval(var);
        String name = v.toString();
        return this.get(name);
    }

    private Object get(String name) {
        if (this.parms != null) {
            if ("it".equals(name)) {
                return this.parms.get(0);
            }
            if ("args".equals(name)) {
                return this.parms;
            }
            if (name.length() == 1 && Character.isDigit(name.charAt(0))) {
                return this.parms.get(name.charAt(0) - 48);
            }
        }
        return this.session.get(name);
    }
}

