/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.shell;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.runtime.shell.Closure;
import org.apache.felix.gogo.runtime.shell.CommandShellImpl;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSessionImpl
implements CommandSession,
Converter {
    public static final String VARIABLES = ".variables";
    public static final String COMMANDS = ".commands";
    private static final String COLUMN = "%-20s %s\n";
    InputStream in;
    PrintStream out;
    PrintStream err;
    CommandShellImpl service;
    final Map<Object, Object> variables = new HashMap<Object, Object>();
    private boolean closed;

    CommandSessionImpl(CommandShellImpl service, InputStream in, PrintStream out, PrintStream err) {
        this.service = service;
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public void close() {
        this.closed = true;
    }

    public Object execute(CharSequence commandline) throws Exception {
        assert (this.service != null);
        assert (this.service.threadIO != null);
        if (this.closed) {
            throw new IllegalStateException("session is closed");
        }
        Closure impl = new Closure(this, null, commandline);
        Object result = impl.execute(this, (List<Object>)null);
        return result;
    }

    public InputStream getKeyboard() {
        return this.in;
    }

    public Object get(String name) {
        if (name == null || VARIABLES.equals(name)) {
            return this.variables.keySet();
        }
        if (COMMANDS.equals(name)) {
            return this.service.get(null);
        }
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (name.startsWith("*:")) {
            String path = this.variables.containsKey("SCOPE") ? this.variables.get("SCOPE").toString() : "osgi:*";
            String func = name.substring(2);
            for (String scope : path.split(":")) {
                Object result = this.service.get(scope + ":" + func);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return this.service.get(name);
    }

    public void put(String name, Object value) {
        this.variables.put(name, value);
    }

    public PrintStream getConsole() {
        return this.out;
    }

    /*
     * WARNING - void declaration
     */
    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        Object c;
        StringBuilder sb;
        if (target == null) {
            return "null";
        }
        if (target instanceof CharSequence) {
            return (CharSequence)target;
        }
        for (Converter converter : this.service.converters) {
            CharSequence s = converter.format(target, level, (Converter)this);
            if (s == null) continue;
            return s;
        }
        if (target.getClass().isArray()) {
            if (target.getClass().getComponentType().isPrimitive()) {
                if (target.getClass().getComponentType() == Boolean.TYPE) {
                    return Arrays.toString((boolean[])target);
                }
                if (target.getClass().getComponentType() == Byte.TYPE) {
                    return Arrays.toString((byte[])target);
                }
                if (target.getClass().getComponentType() == Short.TYPE) {
                    return Arrays.toString((short[])target);
                }
                if (target.getClass().getComponentType() == Integer.TYPE) {
                    return Arrays.toString((int[])target);
                }
                if (target.getClass().getComponentType() == Long.TYPE) {
                    return Arrays.toString((long[])target);
                }
                if (target.getClass().getComponentType() == Float.TYPE) {
                    return Arrays.toString((float[])target);
                }
                if (target.getClass().getComponentType() == Double.TYPE) {
                    return Arrays.toString((double[])target);
                }
                if (target.getClass().getComponentType() == Character.TYPE) {
                    return Arrays.toString((char[])target);
                }
            }
            target = Arrays.asList((Object[])target);
        }
        if (target instanceof Collection) {
            if (level == 0) {
                sb = new StringBuilder();
                Collection collection = (Collection)target;
                for (Object e : collection) {
                    sb.append(this.format(e, level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                String string = "[";
                c = (Collection)target;
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    void var5_8;
                    Object o = iterator.next();
                    sb.append((String)var5_8);
                    sb.append(this.format(o, level + 1, this));
                    String string2 = ", ";
                }
                sb.append("]");
                return sb;
            }
        }
        if (target instanceof Dictionary) {
            HashMap result = new HashMap();
            Enumeration enumeration = ((Dictionary)target).keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                result.put(key, ((Dictionary)target).get(key));
            }
            target = result;
        }
        if (target instanceof Map) {
            if (level == 0) {
                sb = new StringBuilder();
                Map map = (Map)target;
                for (Map.Entry entry : map.entrySet()) {
                    CharSequence key = this.format(entry.getKey(), level + 1, this);
                    sb.append(key);
                    for (int i = key.length(); i < 20; ++i) {
                        sb.append(' ');
                    }
                    sb.append(this.format(entry.getValue(), level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                String string = "[";
                c = (Map)target;
                for (Map.Entry entry : c.entrySet()) {
                    void var5_14;
                    sb.append((String)var5_14);
                    sb.append(this.format(entry, level + 1, this));
                    String string3 = ", ";
                }
                sb.append("]");
                return sb;
            }
        }
        if (level == 0) {
            return this.inspect(target);
        }
        return target.toString();
    }

    CharSequence inspect(Object b) {
        Method[] methods;
        boolean found = false;
        Formatter f = new Formatter();
        for (Method m : methods = b.getClass().getMethods()) {
            try {
                String name = m.getName();
                if (!m.getName().startsWith("get") || m.getName().equals("getClass") || m.getParameterTypes().length != 0 || !Modifier.isPublic(m.getModifiers())) continue;
                found = true;
                name = name.substring(3);
                m.setAccessible(true);
                Object value = m.invoke(b, (Object[])null);
                f.format(COLUMN, name, this.format(value, 1, this));
            }
            catch (IllegalAccessException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (found) {
            return (StringBuilder)f.out();
        }
        return b.toString();
    }

    public Object convert(Class<?> desiredType, Object in) {
        return this.service.convert(desiredType, in);
    }

    public CharSequence format(Object result, int inspect) {
        try {
            return this.format(result, inspect, this);
        }
        catch (Exception e) {
            return "<can not format " + result + ":" + e;
        }
    }
}

