/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.osgi;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.command.CommandSession;
import org.osgi.service.command.Converter;
import org.osgi.service.command.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiCommands
implements Converter {
    Bundle bundle;
    String COLUMN = "%40s %s\n";

    protected OSGiCommands(Bundle bundle) {
        this.bundle = bundle;
    }

    public BundleContext getContext() {
        if (this.bundle.getState() != 32 && this.bundle.getState() != 8 && this.bundle.getState() != 16) {
            throw new IllegalStateException("Framework is not started yet");
        }
        return this.bundle.getBundleContext();
    }

    CharSequence print(Bundle bundle) {
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        return String.format("%06d %s %s-%s", bundle.getBundleId(), this.getState(bundle), bundle.getSymbolicName(), version);
    }

    CharSequence print(ServiceReference ref) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String spid = "";
        Object pid = ref.getProperty("service.pid");
        if (pid != null) {
            spid = pid.toString();
        }
        f.format("%06d %3s %-40s %s", ref.getProperty("service.id"), ref.getBundle().getBundleId(), this.getShortNames((String[])ref.getProperty("objectclass")), spid);
        return sb;
    }

    CharSequence getShortNames(String[] list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (String s : list) {
            sb.append(del + this.getShortName(s));
            del = " | ";
        }
        return sb;
    }

    CharSequence getShortName(String name) {
        int n = name.lastIndexOf(46);
        n = n < 0 ? 0 : ++n;
        return name.subSequence(n, name.length());
    }

    private String getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "ACT";
            }
            case 2: {
                return "INS";
            }
            case 4: {
                return "RES";
            }
            case 8: {
                return "STA";
            }
            case 16: {
                return "STO";
            }
            case 1: {
                return "UNI ";
            }
        }
        return null;
    }

    public void grep(String match) throws IOException {
        Pattern p = Pattern.compile(match);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        String s = rdr.readLine();
        while (s != null) {
            if (p.matcher(s).find()) {
                System.out.println(s);
            }
            s = rdr.readLine();
        }
    }

    public String tac() throws IOException {
        StringWriter sw = new StringWriter();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        String s = rdr.readLine();
        while (s != null) {
            sw.write(s);
            s = rdr.readLine();
        }
        return sw.toString();
    }

    public CharSequence echo(CommandSession session, Object[] args) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object arg : args) {
            sb.append(del);
            if (arg == null) continue;
            sb.append(arg);
            del = " ";
        }
        return sb;
    }

    public void each(CommandSession session, Collection<Object> list, Function closure) throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(null);
        for (Object x : list) {
            args.set(0, x);
            closure.execute(session, args);
        }
    }

    public Bundle bundle(Bundle i) {
        return i;
    }

    public String[] ls(CommandSession session, File f) throws Exception {
        File cwd = (File)session.get("_cwd");
        if (cwd == null) {
            cwd = new File("").getAbsoluteFile();
        }
        if (f == null) {
            f = cwd;
        } else if (!f.isAbsolute()) {
            f = new File(cwd, f.getPath());
        }
        if (f.isDirectory()) {
            return f.list();
        }
        if (f.isFile()) {
            this.cat(session, f);
        }
        return null;
    }

    public Object cat(CommandSession session, File f) throws Exception {
        File cwd = (File)session.get("_cwd");
        if (cwd == null) {
            cwd = new File("").getAbsoluteFile();
        }
        if (!f.isAbsolute()) {
            f = new File(cwd, f.getPath());
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(f);
        byte[] buffer = new byte[(int)(f.length() % 100000L)];
        int size = in.read(buffer);
        while (size > 0) {
            bout.write(buffer, 0, size);
            size = in.read(buffer);
        }
        return new String(bout.toByteArray());
    }

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (desiredType == Bundle.class) {
            return this.convertBundle(in);
        }
        if (desiredType == ServiceReference.class) {
            return this.convertServiceReference(in);
        }
        if (desiredType == Class.class) {
            try {
                return Class.forName(in.toString());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (desiredType.isAssignableFrom(String.class) && in instanceof InputStream) {
            return this.read((InputStream)in);
        }
        return null;
    }

    private Object convertServiceReference(Object in) throws InvalidSyntaxException {
        ServiceReference[] refs;
        String s = in.toString();
        if (s.startsWith("(") && s.endsWith(")") && (refs = this.getContext().getServiceReferences(null, String.format("(|(service.id=%s)(service.pid=%s))", in, in))) != null && refs.length > 0) {
            return refs[0];
        }
        refs = this.getContext().getServiceReferences(null, String.format("(|(service.id=%s)(service.pid=%s))", in, in));
        if (refs != null && refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    private Object convertBundle(Object in) {
        String s = in.toString();
        try {
            long id = Long.parseLong(s);
            return this.getContext().getBundle(id);
        }
        catch (NumberFormatException nfe) {
            Bundle[] bundles;
            for (Bundle b : bundles = this.getContext().getBundles()) {
                if (b.getLocation().equals(s)) {
                    return b;
                }
                if (!b.getSymbolicName().equals(s)) continue;
                return b;
            }
            return null;
        }
    }

    public CharSequence format(Object target, int level, Converter converter) throws IOException {
        if (level == 0 && target instanceof InputStream) {
            return this.read((InputStream)target);
        }
        if (level == 1 && target instanceof Bundle) {
            return this.print((Bundle)target);
        }
        if (level == 1 && target instanceof ServiceReference) {
            return this.print((ServiceReference)target);
        }
        if (level == 2 && target instanceof Bundle) {
            return ((Bundle)target).getSymbolicName();
        }
        if (level == 2 && target instanceof ServiceReference) {
            return this.getShortNames((String[])((ServiceReference)target).getProperty("objectclass"));
        }
        return null;
    }

    public CharSequence read(InputStream in) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = in.read()) > 0) {
            if (c >= 32 && c <= 127 || c == 10 || c == 13) {
                sb.append((char)c);
                continue;
            }
            String s = Integer.toHexString(c).toUpperCase();
            sb.append("\\");
            if (s.length() < 1) {
                sb.append(0);
            }
            sb.append(s);
        }
        return sb;
    }

    public void start(Bundle b) throws BundleException {
        b.start();
    }

    public void stop(Bundle b) throws BundleException {
        b.stop();
    }

    public Object service(String clazz, String filter) throws InvalidSyntaxException {
        ServiceReference[] ref = this.getContext().getServiceReferences(clazz, filter);
        if (ref == null) {
            return null;
        }
        return this.getContext().getService(ref[0]);
    }
}

