/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Process;
import org.jline.builtins.Options;

public class Procedural {
    static final String[] functions = new String[]{"each", "if", "not", "throw", "try", "until", "while", "break", "continue"};

    public Object _main(CommandSession session, Object[] argv) throws Throwable {
        if (argv == null || argv.length < 1) {
            throw new IllegalArgumentException();
        }
        Process process = Process.Utils.current();
        try {
            return this.run(session, process, argv);
        }
        catch (OptionException e) {
            process.err().println(e.getMessage());
            process.error(2);
        }
        catch (HelpException e) {
            process.err().println(e.getMessage());
            process.error(0);
        }
        catch (ThrownException e) {
            process.error(1);
            throw e.getCause();
        }
        return null;
    }

    protected Options parseOptions(CommandSession session, String[] usage, Object[] argv) throws HelpException, OptionException {
        try {
            Options opt = Options.compile((String[])usage, s -> this.get(session, (String)s)).parse(argv, true);
            if (opt.isSet("help")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                opt.usage(new PrintStream(baos));
                throw new HelpException(baos.toString());
            }
            return opt;
        }
        catch (IllegalArgumentException e) {
            throw new OptionException(e.getMessage(), e);
        }
    }

    protected String get(CommandSession session, String name) {
        Object o = session.get(name);
        return o != null ? o.toString() : null;
    }

    protected Object run(CommandSession session, Process process, Object[] argv) throws Throwable {
        switch (argv[0].toString()) {
            case "each": {
                return this.doEach(session, process, argv);
            }
            case "if": {
                return this.doIf(session, process, argv);
            }
            case "not": {
                return this.doNot(session, process, argv);
            }
            case "throw": {
                return this.doThrow(session, process, argv);
            }
            case "try": {
                return this.doTry(session, process, argv);
            }
            case "until": {
                return this.doUntil(session, process, argv);
            }
            case "while": {
                return this.doWhile(session, process, argv);
            }
            case "break": {
                return this.doBreak(session, process, argv);
            }
            case "continue": {
                return this.doContinue(session, process, argv);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected List<Object> doEach(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"each -  loop over the elements", "Usage: each [-r] elements { closure }", "         elements              an array to iterate on", "         closure               a closure to call", "  -? --help                    Show help", "  -r --result                  Return a list containing each iteration result"};
        Options opt = this.parseOptions(session, usage, argv);
        Collection<Object> elements = this.getElements(opt);
        List<Function> functions = this.getFunctions(opt);
        if (elements == null || functions == null || functions.size() != 1) {
            process.err().println("usage: each elements { closure }");
            process.err().println("       elements: an array to iterate on");
            process.err().println("       closure: a function or closure to call");
            process.error(2);
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<Object> results = new ArrayList<Object>();
        args.add(null);
        for (Object x : elements) {
            this.checkInterrupt();
            args.set(0, x);
            try {
                results.add(functions.get(0).execute(session, args));
            }
            catch (BreakException b) {
                break;
            }
            catch (ContinueException c) {
            }
        }
        return opt.isSet("result") ? results : null;
    }

    protected Object doIf(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"if -  if / then / else construct", "Usage: if {condition} {if-action} ... {else-action}", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List<Function> functions = this.getFunctions(opt);
        if (functions == null || functions.size() < 2) {
            process.err().println("usage: if {condition} {if-action} ... {else-action}");
            process.error(2);
            return null;
        }
        int length = functions.size();
        for (int i = 0; i < length; ++i) {
            if (i != length - 1 && !this.isTrue(session, (Function)opt.argObjects().get(i++))) continue;
            return ((Function)opt.argObjects().get(i)).execute(session, null);
        }
        return null;
    }

    protected Boolean doNot(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"not -  return the opposite condition", "Usage: not { condition }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List<Function> functions = this.getFunctions(opt);
        if (functions == null || functions.size() != 1) {
            process.err().println("usage: not { condition }");
            process.error(2);
            return null;
        }
        return !this.isTrue(session, functions.get(0));
    }

    protected Object doThrow(CommandSession session, Process process, Object[] argv) throws ThrownException, HelpException, OptionException {
        String[] usage = new String[]{"throw -  throw an exception", "Usage: throw [ message [ cause ] ]", "       throw exception", "       throw", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        if (opt.argObjects().size() == 0) {
            Object exception = session.get("exception");
            if (exception instanceof Throwable) {
                throw new ThrownException((Throwable)exception);
            }
            throw new ThrownException(new Exception());
        }
        if (opt.argObjects().size() == 1 && opt.argObjects().get(0) instanceof Throwable) {
            throw new ThrownException((Throwable)opt.argObjects().get(0));
        }
        String message = opt.argObjects().get(0).toString();
        Throwable cause = null;
        if (opt.argObjects().size() > 1 && opt.argObjects().get(1) instanceof Throwable) {
            cause = (Throwable)opt.argObjects().get(1);
        }
        throw new ThrownException(new Exception(message).initCause(cause));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTry(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"try -  try / catch / finally construct", "Usage: try { try-action } [ { catch-action } [ { finally-action } ]  ]", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List<Function> functions = this.getFunctions(opt);
        if (functions == null || functions.size() < 1 || functions.size() > 3) {
            process.err().println("usage: try { try-action } [ { catch-action } [ { finally-action } ] ]");
            process.error(2);
            return null;
        }
        try {
            Object object = functions.get(0).execute(session, null);
            return object;
        }
        catch (BreakException b) {
            throw b;
        }
        catch (Exception e) {
            session.put("exception", (Object)e);
            if (functions.size() > 1) {
                functions.get(1).execute(session, null);
            }
            Object var8_10 = null;
            return var8_10;
        }
        finally {
            if (functions.size() > 2) {
                functions.get(2).execute(session, null);
            }
        }
    }

    protected Object doWhile(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"while -  while loop", "Usage: while { condition } { action }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List<Function> functions = this.getFunctions(opt);
        if (functions == null || functions.size() != 2) {
            process.err().println("usage: while { condition } { action }");
            process.error(2);
            return null;
        }
        while (this.isTrue(session, functions.get(0))) {
            try {
                functions.get(1).execute(session, null);
            }
            catch (BreakException b) {
                break;
            }
            catch (ContinueException c) {
            }
        }
        return null;
    }

    protected Object doUntil(CommandSession session, Process process, Object[] argv) throws Exception {
        int length;
        String[] usage = new String[]{"until -  until loop", "Usage: until { condition } { action }", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Object o : opt.argObjects()) {
            if (o instanceof Function) {
                functions.add((Function)o);
                continue;
            }
            functions = null;
            break;
        }
        if ((length = opt.argObjects().size()) != 2 || functions == null) {
            process.err().println("usage: until { condition } { action }");
            process.error(2);
            return null;
        }
        while (!this.isTrue(session, (Function)functions.get(0))) {
            try {
                ((Function)functions.get(1)).execute(session, null);
            }
            catch (BreakException e) {
                break;
            }
            catch (ContinueException c) {
            }
        }
        return null;
    }

    protected Object doBreak(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"break -  break from loop", "Usage: break", "  -? --help                    Show help"};
        this.parseOptions(session, usage, argv);
        throw new BreakException();
    }

    protected Object doContinue(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"continue -  continue loop", "Usage: continue", "  -? --help                    Show help"};
        this.parseOptions(session, usage, argv);
        throw new ContinueException();
    }

    private boolean isTrue(CommandSession session, Function function) throws Exception {
        this.checkInterrupt();
        return this.isTrue(function.execute(session, null));
    }

    private boolean isTrue(Object result) throws InterruptedException {
        this.checkInterrupt();
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number && 0 == ((Number)result).intValue()) {
            return false;
        }
        if ("".equals(result)) {
            return false;
        }
        return !"0".equals(result);
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("interrupted");
        }
    }

    private Collection<Object> getElements(Options opt) {
        List<Object> elements = null;
        if (opt.argObjects().size() > 0) {
            Object o = opt.argObjects().remove(0);
            if (o instanceof Collection) {
                elements = (List<Object>)o;
            } else if (o != null && o.getClass().isArray()) {
                elements = Arrays.asList((Object[])o);
            }
        }
        return elements;
    }

    private List<Function> getFunctions(Options opt) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Object o : opt.argObjects()) {
            if (o instanceof Function) {
                functions.add((Function)o);
                continue;
            }
            functions = null;
            break;
        }
        return functions;
    }

    protected static class ContinueException
    extends Exception {
        protected ContinueException() {
        }
    }

    protected static class BreakException
    extends Exception {
        protected BreakException() {
        }
    }

    protected static class ThrownException
    extends Exception {
        public ThrownException(Throwable cause) {
            super(cause);
        }
    }

    protected static class HelpException
    extends Exception {
        public HelpException(String message) {
            super(message);
        }
    }

    protected static class OptionException
    extends Exception {
        public OptionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

