/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.console;

import org.apache.felix.gogo.console.stdio.StdioConsole;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.command.CommandProcessor;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker commandProcessorTracker;
    private StdioConsole console;

    public void start(BundleContext context) throws Exception {
        this.commandProcessorTracker = new ServiceTracker(context, CommandProcessor.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                CommandProcessor processor = (CommandProcessor)super.addingService(reference);
                Activator.this.startConsole(processor);
                return processor;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (Activator.this.console != null) {
                    Activator.this.console.close();
                    Activator.this.console = null;
                }
                super.removedService(reference, service);
            }
        };
        this.commandProcessorTracker.open();
    }

    protected void startConsole(CommandProcessor processor) {
        this.console = new StdioConsole();
        this.console.setProcessor(processor);
        this.console.start();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.console != null) {
            this.console.close();
        }
        this.commandProcessorTracker.close();
    }
}

