/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.console.telnet;

import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.console.telnet.Handler;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.CommandSession;
import org.osgi.service.component.ComponentContext;

public class TelnetShell
extends Thread {
    boolean quit;
    CommandProcessor processor;
    ServerSocket server;
    int port = 2019;
    List<Handler> handlers = new ArrayList<Handler>();

    protected void activate(ComponentContext context) {
        String s = (String)context.getProperties().get("port");
        if (s != null) {
            this.port = Integer.parseInt(s);
        }
        System.out.println("Telnet Listener at port " + this.port);
        this.start();
    }

    protected void deactivate(ComponentContext ctx) throws Exception {
        try {
            this.quit = true;
            this.server.close();
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            int delay = 0;
            block24: while (true) {
                while (!this.quit) {
                    try {
                        this.server = new ServerSocket(this.port);
                        delay = 5;
                        while (!this.quit) {
                            Socket socket = this.server.accept();
                            CommandSession session = this.processor.createSession(socket.getInputStream(), new PrintStream(socket.getOutputStream()), System.err);
                            Handler handler = new Handler(this, session, socket);
                            this.handlers.add(handler);
                            handler.start();
                        }
                    }
                    catch (BindException be) {
                        delay += 5;
                        System.err.println("Can not bind to port " + this.port);
                        try {
                            Thread.sleep(delay * 1000);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    catch (Exception e) {
                        if (this.quit) continue;
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            this.server.close();
                            Thread.sleep(2000L);
                            continue block24;
                        }
                        catch (Exception ie) {}
                        continue;
                        continue block24;
                    }
                }
                break block29;
                break;
            }
            finally {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException e) {}
                for (Handler handler : this.handlers) {
                    handler.close();
                }
            }
        }
    }

    public void setProcessor(CommandProcessor processor) {
        this.processor = processor;
    }
}

