/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.gogo.console.stdio.Console;
import org.apache.felix.gogo.runtime.osgi.OSGiShell;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.command.CommandSession;

public class Launcher {
    static List<URL> classpath = new ArrayList<URL>();
    static File cwd = new File("").getAbsoluteFile();

    public static void main(String[] args) throws Exception {
        Framework framework;
        StringBuffer sb = new StringBuffer();
        String fwkClassName = null;
        PrintStream out = System.out;
        InputStream in = System.in;
        boolean console = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-f")) {
                fwkClassName = args[++i];
                continue;
            }
            if (arg.equals("-cp") || arg.equals("-classpath")) {
                Launcher.classpath(args[++i]);
                continue;
            }
            if (arg.equals("-console")) {
                console = true;
                continue;
            }
            if (arg.equals("-i")) {
                in = new FileInputStream(args[++i]);
                continue;
            }
            if (arg.equals("-o")) {
                out = new PrintStream(new FileOutputStream(args[++i]));
                continue;
            }
            sb.append(' ');
            sb.append(arg);
        }
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        URLClassLoader cl = new URLClassLoader(urls, Launcher.class.getClassLoader());
        Properties p = new Properties(System.getProperties());
        if (fwkClassName == null) {
            framework = Launcher.getFrameworkFactory(cl).newFramework((Map)p);
        } else {
            Class<?> fw = cl.loadClass(fwkClassName);
            Constructor<?> c = fw.getConstructor(Map.class, List.class);
            framework = (Framework)c.newInstance(p);
        }
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        OSGiShell shell = new OSGiShell();
        shell.setThreadio(threadio);
        shell.setBundle((Bundle)framework);
        shell.start();
        CommandSession session = shell.createSession(in, out, System.err);
        session.put("shell", shell);
        session.put("threadio", threadio);
        session.execute(sb);
        out.flush();
        if (framework.getState() == 32) {
            // empty if block
        }
        if (console) {
            Console cons = new Console();
            cons.setSession(session);
            cons.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameworkFactory getFrameworkFactory(ClassLoader cl) throws Exception {
        URL url = cl.getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)cl.loadClass(s).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new Exception("Could not find framework factory.");
    }

    private static void classpath(String string) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(string, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File f;
            String part = st.nextToken();
            if (part.equals(".")) {
                classpath.add(cwd.toURL());
            }
            if (!(f = new File(part)).isAbsolute()) {
                f = new File(cwd, part);
            }
            if (f.exists()) {
                classpath.add(f.toURL());
                continue;
            }
            System.err.println("Can not find " + part);
        }
    }
}

