/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.Pipe;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Job;
import org.apache.felix.service.command.JobListener;
import org.apache.felix.service.command.Process;
import org.apache.felix.service.threadio.ThreadIO;

public class CommandSessionImpl
implements CommandSession,
Converter {
    public static final String SESSION_CLOSED = "session is closed";
    public static final String VARIABLES = ".variables";
    public static final String COMMANDS = ".commands";
    public static final String CONSTANTS = ".constants";
    private static final String COLUMN = "%-20s %s\n";
    protected InputStream in;
    protected OutputStream out;
    protected PrintStream pout;
    protected OutputStream err;
    protected PrintStream perr;
    protected Channel[] channels;
    private final CommandProcessorImpl processor;
    protected final ConcurrentMap<String, Object> variables = new ConcurrentHashMap<String, Object>();
    private volatile boolean closed;
    private final List<JobImpl> jobs = new ArrayList<JobImpl>();
    private JobListener jobListener;
    private final ExecutorService executor;
    private Path currentDir;

    protected CommandSessionImpl(CommandProcessorImpl shell, CommandSessionImpl parent) {
        this.currentDir = parent.currentDir;
        this.executor = Executors.newCachedThreadPool();
        this.processor = shell;
        this.channels = parent.channels;
        this.in = parent.in;
        this.out = parent.out;
        this.err = parent.err;
        this.pout = parent.pout;
        this.perr = parent.perr;
    }

    protected CommandSessionImpl(CommandProcessorImpl shell, InputStream in, OutputStream out, OutputStream err) {
        this.currentDir = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize();
        this.executor = Executors.newCachedThreadPool();
        this.processor = shell;
        ReadableByteChannel inCh = Channels.newChannel(in);
        WritableByteChannel outCh = Channels.newChannel(out);
        WritableByteChannel errCh = out == err ? outCh : Channels.newChannel(err);
        this.channels = new Channel[]{inCh, outCh, errCh};
        this.in = in;
        this.out = out;
        this.err = err;
        PrintStream printStream = this.pout = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, true);
        this.perr = out == err ? this.pout : (err instanceof PrintStream ? (PrintStream)err : new PrintStream(err, true));
    }

    ThreadIO threadIO() {
        return this.processor.threadIO;
    }

    public CommandProcessor processor() {
        return this.processor;
    }

    public ConcurrentMap<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public Path currentDir() {
        return this.currentDir;
    }

    @Override
    public void currentDir(Path path) {
        this.currentDir = path;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.processor.closeSession(this);
            this.executor.shutdownNow();
        }
    }

    @Override
    public Object execute(CharSequence commandline) throws Exception {
        assert (this.processor != null);
        if (this.closed) {
            throw new IllegalStateException(SESSION_CLOSED);
        }
        this.processor.beforeExecute(this, commandline);
        try {
            Closure impl = new Closure(this, null, commandline);
            Object result = impl.execute(this, null);
            this.processor.afterExecute((CommandSession)this, commandline, result);
            return result;
        }
        catch (Exception e) {
            this.processor.afterExecute((CommandSession)this, commandline, e);
            throw e;
        }
    }

    @Override
    public InputStream getKeyboard() {
        return this.in;
    }

    @Override
    public Object get(String name) {
        if (name == null || VARIABLES.equals(name)) {
            return Collections.unmodifiableSet(this.variables.keySet());
        }
        if (COMMANDS.equals(name)) {
            return this.processor.getCommands();
        }
        if (CONSTANTS.equals(name)) {
            return Collections.unmodifiableSet(this.processor.constants.keySet());
        }
        Object val = this.processor.constants.get(name);
        if (val != null) {
            return val;
        }
        val = this.variables.get("#" + name);
        if (val instanceof Function) {
            try {
                val = ((Function)val).execute(this, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return val;
        }
        if (val != null) {
            return val;
        }
        val = this.variables.get(name);
        if (val != null) {
            return val;
        }
        return this.processor.getCommand(name, this.variables.get("SCOPE"));
    }

    @Override
    public Object put(String name, Object value) {
        if (value != null) {
            return this.variables.put(name, value);
        }
        return this.variables.remove(name);
    }

    @Override
    public PrintStream getConsole() {
        return this.pout;
    }

    @Override
    public CharSequence format(Object target, int level, Converter escape) throws Exception {
        StringBuilder sb;
        if (target == null) {
            return "null";
        }
        if (target instanceof CharSequence) {
            return (CharSequence)target;
        }
        for (Converter converter : this.processor.converters) {
            CharSequence s = converter.format(target, level, this);
            if (s == null) continue;
            return s;
        }
        if (target.getClass().isArray()) {
            if (target.getClass().getComponentType().isPrimitive()) {
                if (target.getClass().getComponentType() == Boolean.TYPE) {
                    return Arrays.toString((boolean[])target);
                }
                if (target.getClass().getComponentType() == Byte.TYPE) {
                    return Arrays.toString((byte[])target);
                }
                if (target.getClass().getComponentType() == Short.TYPE) {
                    return Arrays.toString((short[])target);
                }
                if (target.getClass().getComponentType() == Integer.TYPE) {
                    return Arrays.toString((int[])target);
                }
                if (target.getClass().getComponentType() == Long.TYPE) {
                    return Arrays.toString((long[])target);
                }
                if (target.getClass().getComponentType() == Float.TYPE) {
                    return Arrays.toString((float[])target);
                }
                if (target.getClass().getComponentType() == Double.TYPE) {
                    return Arrays.toString((double[])target);
                }
                if (target.getClass().getComponentType() == Character.TYPE) {
                    return Arrays.toString((char[])target);
                }
            }
            target = Arrays.asList((Object[])target);
        }
        if (target instanceof Collection) {
            if (level == 0) {
                sb = new StringBuilder();
                Collection collection = (Collection)target;
                for (Object o : collection) {
                    sb.append(this.format(o, level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                Collection collection = (Collection)target;
                sb.append("[");
                for (Object o : collection) {
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(this.format(o, level + 1, this));
                }
                sb.append("]");
                return sb;
            }
        }
        if (target instanceof Dictionary) {
            HashMap result = new HashMap();
            Enumeration enumeration = ((Dictionary)target).keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                result.put(key, ((Dictionary)target).get(key));
            }
            target = result;
        }
        if (target instanceof Map) {
            if (level == 0) {
                sb = new StringBuilder();
                Map map = (Map)target;
                for (Map.Entry entry : map.entrySet()) {
                    CharSequence key = this.format(entry.getKey(), level + 1, this);
                    sb.append(key);
                    for (int i = key.length(); i < 20; ++i) {
                        sb.append(' ');
                    }
                    sb.append(this.format(entry.getValue(), level + 1, this));
                    sb.append("\n");
                }
                return sb;
            }
            if (level == 1) {
                sb = new StringBuilder();
                Map map = (Map)target;
                sb.append("[");
                for (Map.Entry entry : map.entrySet()) {
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(this.format(entry, level + 1, this));
                }
                sb.append("]");
                return sb;
            }
        }
        if (target instanceof Path) {
            return target.toString();
        }
        if (level == 0) {
            return this.inspect(target);
        }
        return target.toString();
    }

    CharSequence inspect(Object b) {
        Method[] methods;
        boolean found = false;
        Formatter f = new Formatter();
        for (Method m : methods = b.getClass().getMethods()) {
            try {
                String name = m.getName();
                if (!m.getName().startsWith("get") || m.getName().equals("getClass") || m.getParameterTypes().length != 0 || !Modifier.isPublic(m.getModifiers())) continue;
                found = true;
                name = name.substring(3);
                m.setAccessible(true);
                Object value = m.invoke(b, (Object[])null);
                f.format(COLUMN, name, this.format(value, 1, this));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (found) {
            return (StringBuilder)f.out();
        }
        return b.toString();
    }

    @Override
    public Object convert(Class<?> desiredType, Object in) {
        return this.processor.convert(this, desiredType, in);
    }

    public Object doConvert(Class<?> desiredType, Object in) {
        return this.processor.doConvert(desiredType, in);
    }

    @Override
    public CharSequence format(Object result, int inspect) {
        try {
            return this.format(result, inspect, this);
        }
        catch (Exception e) {
            return "<can not format " + result + ":" + e;
        }
    }

    public Object expr(CharSequence expr) {
        return this.processor.expr(this, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Job> jobs() {
        List<JobImpl> list = this.jobs;
        synchronized (list) {
            return Collections.unmodifiableList(this.jobs);
        }
    }

    public static JobImpl currentJob() {
        return (JobImpl)Job.Utils.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobImpl foregroundJob() {
        ArrayList<JobImpl> jobs;
        List<JobImpl> list = this.jobs;
        synchronized (list) {
            jobs = new ArrayList<JobImpl>(this.jobs);
        }
        for (JobImpl j : jobs) {
            if (j.parent != null || j.status() != Job.Status.Foreground) continue;
            return j;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJobListener(JobListener listener) {
        List<JobImpl> list = this.jobs;
        synchronized (list) {
            this.jobListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobImpl createJob(CharSequence command) {
        List<JobImpl> list = this.jobs;
        synchronized (list) {
            boolean found;
            int id = 1;
            block3: do {
                found = false;
                for (Job job : this.jobs) {
                    if (job.id() != id) continue;
                    found = true;
                    ++id;
                    continue block3;
                }
            } while (found);
            JobImpl cur = CommandSessionImpl.currentJob();
            JobImpl jobImpl = new JobImpl(id, cur, command);
            if (cur == null) {
                this.jobs.add(jobImpl);
            } else {
                cur.add(jobImpl);
            }
            return jobImpl;
        }
    }

    class JobImpl
    implements Job,
    Runnable {
        private final int id;
        private final JobImpl parent;
        private final CharSequence command;
        private final List<Pipe> pipes = new ArrayList<Pipe>();
        private final List<Job> children = new ArrayList<Job>();
        private Job.Status status = Job.Status.Created;
        private Future<?> future;
        private Pipe.Result result;

        public JobImpl(int id, JobImpl parent, CharSequence command) {
            this.id = id;
            this.parent = parent;
            this.command = command;
        }

        void addPipe(Pipe pipe) {
            this.pipes.add(pipe);
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public CharSequence command() {
            return this.command;
        }

        @Override
        public synchronized Job.Status status() {
            return this.status;
        }

        @Override
        public synchronized void suspend() {
            if (this.status == Job.Status.Done) {
                throw new IllegalStateException("Job is finished");
            }
            if (this.status != Job.Status.Suspended) {
                this.setStatus(Job.Status.Suspended);
            }
        }

        @Override
        public synchronized void background() {
            if (this.status == Job.Status.Done) {
                throw new IllegalStateException("Job is finished");
            }
            if (this.status != Job.Status.Background) {
                this.setStatus(Job.Status.Background);
            }
        }

        @Override
        public synchronized void foreground() {
            if (this.status == Job.Status.Done) {
                throw new IllegalStateException("Job is finished");
            }
            JobImpl cr = CommandSessionImpl.currentJob();
            JobImpl fg = CommandSessionImpl.this.foregroundJob();
            if (this.parent == null && fg != null && fg != this && fg != cr) {
                throw new IllegalStateException("A job is already in foreground");
            }
            if (this.status != Job.Status.Foreground) {
                this.setStatus(Job.Status.Foreground);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            ArrayList<Job> children;
            Future<?> future;
            Iterator iterator = this;
            synchronized (iterator) {
                future = this.future;
            }
            iterator = this.children;
            synchronized (iterator) {
                children = new ArrayList<Job>(this.children);
            }
            for (Job job : children) {
                job.interrupt();
            }
            if (future != null) {
                future.cancel(true);
            }
        }

        protected synchronized void done() {
            if (this.status == Job.Status.Done) {
                throw new IllegalStateException("Job is finished");
            }
            this.setStatus(Job.Status.Done);
        }

        private void setStatus(Job.Status newStatus) {
            this.setStatus(newStatus, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStatus(Job.Status newStatus, boolean callListeners) {
            Job.Status previous;
            JobImpl jobImpl = this;
            synchronized (jobImpl) {
                previous = this.status;
                this.status = newStatus;
            }
            if (callListeners) {
                JobListener listener;
                List list = CommandSessionImpl.this.jobs;
                synchronized (list) {
                    listener = CommandSessionImpl.this.jobListener;
                    if (newStatus == Job.Status.Done) {
                        CommandSessionImpl.this.jobs.remove(this);
                    }
                }
                if (listener != null) {
                    listener.jobChanged(this, previous, newStatus);
                }
            }
            jobImpl = this;
            synchronized (jobImpl) {
                this.notifyAll();
            }
        }

        @Override
        public synchronized Pipe.Result result() {
            return this.result;
        }

        @Override
        public Job parent() {
            return this.parent;
        }

        public synchronized Pipe.Result start(Job.Status status) throws InterruptedException {
            if (status == Job.Status.Created || status == Job.Status.Done) {
                throw new IllegalArgumentException("Illegal start status");
            }
            if (this.status != Job.Status.Created) {
                throw new IllegalStateException("Job already started");
            }
            switch (status) {
                case Suspended: {
                    this.suspend();
                    break;
                }
                case Background: {
                    this.background();
                    break;
                }
                case Foreground: {
                    this.foreground();
                }
            }
            this.future = CommandSessionImpl.this.executor.submit(this);
            while (this.status == Job.Status.Foreground) {
                this.wait();
            }
            return this.result;
        }

        @Override
        public List<Process> processes() {
            return Collections.unmodifiableList(this.pipes);
        }

        @Override
        public CommandSession session() {
            return CommandSessionImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            try {
                thread.setName("job controller " + this.id);
                ArrayList<Pipe> wrapped = new ArrayList<Pipe>(this.pipes);
                List results = CommandSessionImpl.this.executor.invokeAll(wrapped);
                Throwable pipeException = null;
                for (int i = 0; i < results.size() - 1; ++i) {
                    Throwable e;
                    Future future = results.get(i);
                    try {
                        Pipe.Result r = (Pipe.Result)future.get();
                        e = r.exception;
                    }
                    catch (ExecutionException ee) {
                        e = ee.getCause();
                    }
                    if (e == null) continue;
                    if (pipeException == null) {
                        pipeException = new Exception("Exception caught during pipe execution");
                    }
                    pipeException.addSuppressed(e);
                }
                CommandSessionImpl.this.put("pipe-exception", pipeException);
                this.result = (Pipe.Result)results.get(results.size() - 1).get();
            }
            catch (Exception e) {
                this.result = new Pipe.Result(e);
            }
            catch (Throwable t) {
                this.result = new Pipe.Result(new ExecutionException(t));
            }
            finally {
                this.done();
                thread.setName(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Job child) {
            List<Job> list = this.children;
            synchronized (list) {
                this.children.add(child);
            }
        }
    }
}

