/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.generalchecks.util.SimpleConstraintChecker;
import org.apache.felix.utils.json.JSONParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Http Requests")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class HttpRequestsCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestsCheck.class);
    public static final String HC_NAME = "Http Requests";
    public static final String HC_LABEL = "Health Check: Http Requests";
    private List<RequestSpec> requestSpecs;
    private int connectTimeoutInMs;
    private int readTimeoutInMs;
    private Result.Status statusForFailedContraint;
    private boolean runInParallel;
    private String defaultBaseUrl = null;
    private FormattingResultLog configErrors;

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.requestSpecs = this.getRequestSpecs(config.requests());
        this.connectTimeoutInMs = config.connectTimeoutInMs();
        this.readTimeoutInMs = config.readTimeoutInMs();
        this.statusForFailedContraint = config.statusForFailedContraint();
        this.runInParallel = config.runInParallel() && this.requestSpecs.size() > 1;
        this.setupDefaultBaseUrl(bundleContext);
        LOG.info("Default BaseURL: {}", (Object)this.defaultBaseUrl);
        LOG.info("Activated Requests HC: {}", this.requestSpecs);
    }

    private void setupDefaultBaseUrl(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference("org.osgi.service.http.HttpService");
        boolean isHttp = Boolean.parseBoolean(String.valueOf(serviceReference.getProperty("org.apache.felix.http.enable")));
        boolean isHttps = Boolean.parseBoolean(String.valueOf(serviceReference.getProperty("org.apache.felix.https.enable")));
        if (isHttp) {
            this.defaultBaseUrl = "http://localhost:" + serviceReference.getProperty("org.osgi.service.http.port");
        } else if (isHttps) {
            this.defaultBaseUrl = "http://localhost:" + serviceReference.getProperty("org.osgi.service.https.port");
        }
    }

    public Result execute() {
        FormattingResultLog overallLog = new FormattingResultLog();
        for (ResultLog.Entry entry : this.configErrors) {
            overallLog.add(entry);
        }
        Stream requestSpecsStream = this.runInParallel ? this.requestSpecs.parallelStream() : this.requestSpecs.stream();
        List logsForEachRequest = requestSpecsStream.map(requestSpec -> requestSpec.check(this.defaultBaseUrl, this.connectTimeoutInMs, this.readTimeoutInMs, this.statusForFailedContraint, this.requestSpecs.size() > 1)).collect(Collectors.toList());
        logsForEachRequest.stream().forEach(l -> StreamSupport.stream(l.spliterator(), false).forEach(e -> overallLog.add(e)));
        return new Result((ResultLog)overallLog);
    }

    private List<RequestSpec> getRequestSpecs(String[] requestSpecStrArr) {
        this.configErrors = new FormattingResultLog();
        ArrayList<RequestSpec> requestSpecs = new ArrayList<RequestSpec>();
        for (String requestSpecStr : requestSpecStrArr) {
            try {
                RequestSpec requestSpec = new RequestSpec(requestSpecStr);
                requestSpecs.add(requestSpec);
            }
            catch (Exception e) {
                this.configErrors.critical("Invalid config: {}", new Object[]{requestSpecStr});
                this.configErrors.add(new ResultLog.Entry(Result.Status.CRITICAL, " " + e.getMessage(), e));
            }
        }
        return requestSpecs;
    }

    static class JsonPropertyCheck
    implements ResponseCheck {
        static final String JSON = "JSON ";
        private final String jsonPropertyPath;
        private final String jsonPropertyConstraint;
        private final SimpleConstraintChecker simpleConstraintChecker = new SimpleConstraintChecker();

        public JsonPropertyCheck(String jsonExpression) {
            String[] jsonCheckBits = jsonExpression.split(" +", 2);
            this.jsonPropertyPath = jsonCheckBits[0];
            this.jsonPropertyConstraint = jsonCheckBits[1];
        }

        @Override
        public ResponseCheck.ResponseCheckResult checkResponse(Response response, FormattingResultLog log) {
            JSONParser jsonParser;
            try {
                jsonParser = new JSONParser(response.actualResponseEntity);
            }
            catch (Exception e) {
                return new ResponseCheck.ResponseCheckResult(true, "invalid json response ([" + this.jsonPropertyPath + "] cannot be checked agains constraint [" + this.jsonPropertyConstraint + "])");
            }
            Object propertyVal = this.getJsonProperty(jsonParser, this.jsonPropertyPath);
            log.debug("JSON property [{}] has value [{}]", new Object[]{this.jsonPropertyPath, propertyVal});
            log.debug("Checking [{}] with value [{}] for constraint [{}]", new Object[]{this.jsonPropertyPath, propertyVal, this.jsonPropertyConstraint});
            if (!this.simpleConstraintChecker.check(propertyVal, this.jsonPropertyConstraint)) {
                return new ResponseCheck.ResponseCheckResult(true, "json [" + this.jsonPropertyPath + "] has value [" + propertyVal + "] which does not fulfil constraint [" + this.jsonPropertyConstraint + "]");
            }
            return new ResponseCheck.ResponseCheckResult(false, "json property [" + this.jsonPropertyPath + "] with [" + propertyVal + "] fulfils constraint [" + this.jsonPropertyConstraint + "]");
        }

        private Object getJsonProperty(JSONParser jsonParser, String jsonPropertyPath) {
            Object[] jsonPropertyPathBits = jsonPropertyPath.split("(?=\\.|\\[)");
            Object currentObject = null;
            for (int i = 0; i < jsonPropertyPathBits.length; ++i) {
                String jsonPropertyPathBit = jsonPropertyPathBits[i];
                if (jsonPropertyPathBit.startsWith("[")) {
                    int arrayIndex = Integer.parseInt(jsonPropertyPathBit.substring(1, jsonPropertyPathBit.length() - 1));
                    if (currentObject == null) {
                        currentObject = jsonParser.getParsedList();
                    }
                    if (!(currentObject instanceof List)) {
                        throw new IllegalArgumentException("Path '" + (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Object[])jsonPropertyPathBits, (String)"", (int)0, (int)i), (CharSequence)"<root>") + "' is not a json list");
                    }
                    currentObject = ((List)currentObject).get(arrayIndex);
                } else {
                    String propertyName;
                    String string = propertyName = jsonPropertyPathBit.startsWith(".") ? jsonPropertyPathBit.substring(1) : jsonPropertyPathBit;
                    if (currentObject == null) {
                        currentObject = jsonParser.getParsed();
                    }
                    if (!(currentObject instanceof Map)) {
                        throw new IllegalArgumentException("Path '" + (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.join((Object[])jsonPropertyPathBits, (String)"", (int)0, (int)i), (CharSequence)"<root>") + "' is not a json object");
                    }
                    currentObject = currentObject.get(propertyName);
                }
                if (currentObject != null || i + 1 >= jsonPropertyPathBits.length) continue;
                throw new IllegalArgumentException("Path " + StringUtils.join((Object[])jsonPropertyPathBits, (String)"", (int)0, (int)(i + 1)) + " is null, cannot evaluate left-over part '" + StringUtils.join((Object[])jsonPropertyPathBits, (String)"", (int)(i + 1), (int)jsonPropertyPathBits.length) + "'");
            }
            return currentObject;
        }
    }

    static class ResponseHeaderCheck
    implements ResponseCheck {
        static final String HEADER = "HEADER ";
        private final String headerName;
        private final String headerConstraint;
        private final SimpleConstraintChecker simpleConstraintChecker = new SimpleConstraintChecker();

        public ResponseHeaderCheck(String headerExpression) {
            String[] headerCheckBits = headerExpression.split(" +", 2);
            this.headerName = headerCheckBits[0];
            this.headerConstraint = headerCheckBits[1];
        }

        @Override
        public ResponseCheck.ResponseCheckResult checkResponse(Response response, FormattingResultLog log) {
            List<String> headerValues = response.actualResponseHeaders.get(this.headerName);
            String headerVal = headerValues != null && !headerValues.isEmpty() ? headerValues.get(0) : null;
            log.debug("Checking {} with value [{}] for constraint [{}]", new Object[]{this.headerName, headerVal, this.headerConstraint});
            if (!this.simpleConstraintChecker.check(headerVal, this.headerConstraint)) {
                return new ResponseCheck.ResponseCheckResult(true, "header [" + this.headerName + "] has value [" + headerVal + "] which does not fulfil constraint [" + this.headerConstraint + "]");
            }
            return new ResponseCheck.ResponseCheckResult(false, "header [" + this.headerName + "] ok");
        }
    }

    static class ResponseEntityRegExCheck
    implements ResponseCheck {
        static final String MATCHES = "MATCHES ";
        private final Pattern expectedResponseEntityRegEx;

        public ResponseEntityRegExCheck(Pattern expectedResponseEntityRegEx) {
            this.expectedResponseEntityRegEx = expectedResponseEntityRegEx;
        }

        @Override
        public ResponseCheck.ResponseCheckResult checkResponse(Response response, FormattingResultLog log) {
            if (!this.expectedResponseEntityRegEx.matcher(response.actualResponseEntity).find()) {
                return new ResponseCheck.ResponseCheckResult(true, "response does not match [" + this.expectedResponseEntityRegEx + ']');
            }
            return new ResponseCheck.ResponseCheckResult(false, "response matches [" + this.expectedResponseEntityRegEx + "]");
        }
    }

    static class ResponseTimeCheck
    implements ResponseCheck {
        static final String TIME = "TIME ";
        private final String timeConstraint;
        private final SimpleConstraintChecker simpleConstraintChecker = new SimpleConstraintChecker();

        public ResponseTimeCheck(String timeConstraint) {
            this.timeConstraint = timeConstraint;
        }

        @Override
        public ResponseCheck.ResponseCheckResult checkResponse(Response response, FormattingResultLog log) {
            log.debug("Checking request time [{}ms] for constraint [{}]", new Object[]{response.requestDurationInMs, this.timeConstraint});
            if (!this.simpleConstraintChecker.check(response.requestDurationInMs, this.timeConstraint)) {
                return new ResponseCheck.ResponseCheckResult(true, "time [" + response.requestDurationInMs + "ms] does not fulfil constraint [" + this.timeConstraint + "]");
            }
            return new ResponseCheck.ResponseCheckResult(false, "time [" + response.requestDurationInMs + "ms] fulfils constraint [" + this.timeConstraint + "]");
        }
    }

    static class ResponseCodeCheck
    implements ResponseCheck {
        private final int expectedResponseCode;

        public ResponseCodeCheck(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        @Override
        public ResponseCheck.ResponseCheckResult checkResponse(Response response, FormattingResultLog log) {
            if (this.expectedResponseCode != response.actualResponseCode) {
                return new ResponseCheck.ResponseCheckResult(true, response.actualResponseCode + " (expected " + this.expectedResponseCode + ")");
            }
            return new ResponseCheck.ResponseCheckResult(false, "[" + response.actualResponseCode + " " + response.actualResponseMessage + "]");
        }
    }

    static interface ResponseCheck {
        public ResponseCheckResult checkResponse(Response var1, FormattingResultLog var2);

        public static class ResponseCheckResult {
            final boolean contraintFailed;
            final String message;

            ResponseCheckResult(boolean contraintFailed, String message) {
                this.contraintFailed = contraintFailed;
                this.message = message;
            }
        }
    }

    static class Response {
        final int actualResponseCode;
        final String actualResponseMessage;
        final Map<String, List<String>> actualResponseHeaders;
        final String actualResponseEntity;
        final long requestDurationInMs;

        public Response(int actualResponseCode, String actualResponseMessage, Map<String, List<String>> actualResponseHeaders, String actualResponseEntity, long requestDurationInMs) {
            this.actualResponseCode = actualResponseCode;
            this.actualResponseMessage = actualResponseMessage;
            this.actualResponseHeaders = actualResponseHeaders;
            this.actualResponseEntity = actualResponseEntity;
            this.requestDurationInMs = requestDurationInMs;
        }
    }

    static class RequestSpec {
        private static final String HEADER_AUTHORIZATION = "Authorization";
        String method = "GET";
        String url;
        Map<String, String> headers = new HashMap<String, String>();
        String data = null;
        String user;
        Integer connectTimeoutInMs;
        Integer readTimeoutInMs;
        Proxy proxy;
        List<ResponseCheck> responseChecks = new ArrayList<ResponseCheck>();

        RequestSpec(String requestSpecStr) throws ParseException, URISyntaxException {
            String[] requestSpecBits = requestSpecStr.split(" *=> *", 2);
            String requestInfo = requestSpecBits[0];
            this.parseCurlLikeRequestInfo(requestInfo);
            if (requestSpecBits.length > 1) {
                this.parseResponseAssertion(requestSpecBits[1]);
            } else {
                this.responseChecks.add(new ResponseCodeCheck(200));
            }
        }

        private void parseResponseAssertion(String responseAssertions) {
            String[] responseAssertionArr;
            for (String clause : responseAssertionArr = responseAssertions.split(" +&& +")) {
                if (StringUtils.isNumeric((CharSequence)clause)) {
                    this.responseChecks.add(new ResponseCodeCheck(Integer.parseInt(clause)));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)clause, (CharSequence)"TIME ")) {
                    this.responseChecks.add(new ResponseTimeCheck(clause.substring("TIME ".length())));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)clause, (CharSequence)"MATCHES ")) {
                    this.responseChecks.add(new ResponseEntityRegExCheck(Pattern.compile(clause.substring("MATCHES ".length()))));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)clause, (CharSequence)"HEADER ")) {
                    this.responseChecks.add(new ResponseHeaderCheck(clause.substring("HEADER ".length())));
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)clause, (CharSequence)"JSON ")) {
                    this.responseChecks.add(new JsonPropertyCheck(clause.substring("JSON ".length())));
                    continue;
                }
                throw new IllegalArgumentException("Invalid response content assertion clause: '" + clause + "'");
            }
        }

        private void parseCurlLikeRequestInfo(String requestInfo) throws ParseException, URISyntaxException {
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption("H", "header", true, "");
            options.addOption("X", "method", true, "");
            options.addOption("d", "data", true, "");
            options.addOption("u", "user", true, "");
            options.addOption(null, "connect-timeout", true, "");
            options.addOption("m", "max-time", true, "");
            options.addOption("x", "proxy", true, "");
            String[] args = this.splitArgsRespectingQuotes(requestInfo);
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("header")) {
                String[] headerValues;
                for (String headerVal : headerValues = line.getOptionValues("header")) {
                    String[] headerBits = headerVal.split(" *: *", 2);
                    this.headers.put(headerBits[0], headerBits[1]);
                }
            }
            if (line.hasOption("method")) {
                this.method = line.getOptionValue("method");
            }
            if (line.hasOption("data")) {
                this.data = line.getOptionValue("data");
            }
            if (line.hasOption("user")) {
                String userAndPw = line.getOptionValue("user");
                this.user = userAndPw.split(":")[0];
                byte[] encodedUserAndPw = Base64.getEncoder().encode(userAndPw.getBytes());
                this.headers.put(HEADER_AUTHORIZATION, "Basic " + new String(encodedUserAndPw));
            }
            if (line.hasOption("connect-timeout")) {
                this.connectTimeoutInMs = Integer.valueOf(line.getOptionValue("connect-timeout")) * 1000;
            }
            if (line.hasOption("max-time")) {
                this.readTimeoutInMs = Integer.valueOf(line.getOptionValue("max-time")) * 1000;
            }
            if (line.hasOption("proxy")) {
                int proxyPort;
                String proxyHost;
                String curlProxy = line.getOptionValue("proxy");
                if (curlProxy.contains("@")) {
                    throw new IllegalArgumentException("Proxy authentication is not support");
                }
                if (curlProxy.startsWith("http")) {
                    URI uri = new URI(curlProxy);
                    proxyHost = uri.getHost();
                    proxyPort = uri.getPort();
                } else {
                    String[] curlProxyBits = curlProxy.split(":");
                    proxyHost = curlProxyBits[0];
                    proxyPort = curlProxyBits.length > 1 ? Integer.parseInt(curlProxyBits[1]) : 1080;
                }
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            }
            this.url = line.getArgList().get(0);
        }

        String[] splitArgsRespectingQuotes(String requestInfo) {
            ArrayList<String> argList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(requestInfo);
            while (regexMatcher.find()) {
                argList.add(regexMatcher.group());
            }
            return argList.toArray(new String[argList.size()]);
        }

        public String toString() {
            return "RequestSpec [method=" + this.method + ", url=" + this.url + ", headers=" + this.headers + ", responseChecks=" + this.responseChecks + "]";
        }

        public FormattingResultLog check(String defaultBaseUrl, int connectTimeoutInMs, int readTimeoutInMs, Result.Status statusForFailedContraint, boolean showTiming) {
            FormattingResultLog log = new FormattingResultLog();
            String urlWithUser = this.user != null ? this.user + " @ " + this.url : this.url;
            log.debug("Checking {}", new Object[]{urlWithUser});
            log.debug(" configured headers {}", new Object[]{this.headers.keySet()});
            Response response = null;
            try {
                response = this.performRequest(defaultBaseUrl, urlWithUser, connectTimeoutInMs, readTimeoutInMs, log);
            }
            catch (IOException e) {
                log.add(new ResultLog.Entry(statusForFailedContraint, urlWithUser + ": " + e.getMessage(), (Exception)e));
            }
            if (response != null) {
                ArrayList<String> resultBits = new ArrayList<String>();
                boolean hasFailed = false;
                for (ResponseCheck responseCheck : this.responseChecks) {
                    ResponseCheck.ResponseCheckResult result = responseCheck.checkResponse(response, log);
                    hasFailed = hasFailed || result.contraintFailed;
                    resultBits.add(result.message);
                }
                Result.Status status = hasFailed ? statusForFailedContraint : Result.Status.OK;
                String timing = showTiming ? " " + FormattingResultLog.msHumanReadable((long)response.requestDurationInMs) : "";
                log.add(new ResultLog.Entry(status, urlWithUser + timing + ": " + StringUtils.join(resultBits, (String)", ")));
            }
            return log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response performRequest(String defaultBaseUrl, String urlWithUser, int connectTimeoutInMs, int readTimeoutInMs, FormattingResultLog log) throws IOException {
            Response response = null;
            HttpURLConnection conn = null;
            try {
                URL effectiveUrl = this.url.startsWith("/") ? new URL(defaultBaseUrl + this.url) : new URL(this.url);
                conn = this.openConnection(connectTimeoutInMs, readTimeoutInMs, effectiveUrl, log);
                response = this.readResponse(conn, log);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return response;
        }

        private HttpURLConnection openConnection(int defaultConnectTimeoutInMs, int defaultReadTimeoutInMs, URL effectiveUrl, FormattingResultLog log) throws IOException, ProtocolException {
            HttpURLConnection conn = (HttpURLConnection)(this.proxy == null ? effectiveUrl.openConnection() : effectiveUrl.openConnection(this.proxy));
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            int effectiveConnectTimeout = this.connectTimeoutInMs != null ? this.connectTimeoutInMs : defaultConnectTimeoutInMs;
            int effectiveReadTimeout = this.readTimeoutInMs != null ? this.readTimeoutInMs : defaultReadTimeoutInMs;
            log.debug("connectTimeout={}ms readTimeout={}ms", new Object[]{effectiveConnectTimeout, effectiveReadTimeout});
            conn.setConnectTimeout(effectiveConnectTimeout);
            conn.setReadTimeout(effectiveReadTimeout);
            conn.setRequestMethod(this.method);
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
            if (this.data != null) {
                conn.setDoOutput(true);
                byte[] bytes = this.data.getBytes();
                log.debug("Sending request entity with {}bytes", new Object[]{bytes.length});
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                    wr.write(bytes);
                }
            }
            return conn;
        }

        private Response readResponse(HttpURLConnection conn, FormattingResultLog log) throws IOException {
            long startTime = System.currentTimeMillis();
            int actualResponseCode = conn.getResponseCode();
            String actualResponseMessage = conn.getResponseMessage();
            log.debug("Result: {} {}", new Object[]{actualResponseCode, actualResponseMessage});
            Map<String, List<String>> responseHeaders = conn.getHeaderFields();
            StringWriter responseEntityWriter = new StringWriter();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    responseEntityWriter.write(inputLine + "\n");
                }
            }
            catch (IOException e) {
                log.debug("Could not get response entity: {}", new Object[]{e.getMessage()});
            }
            long requestDurationInMs = System.currentTimeMillis() - startTime;
            Response response = new Response(actualResponseCode, actualResponseMessage, responseHeaders, responseEntityWriter.toString(), requestDurationInMs);
            return response;
        }
    }

    @ObjectClassDefinition(name="Health Check: Http Requests", description="Performs http(s) request(s) and checks the response for return code and optionally checks the response entity")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Http Requests";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Request Specs", description="List of requests to be made. Requests specs have two parts: Before '=>' can be a simple URL/path with curl-syntax advanced options (e.g. setting a header with -H \"Test: Test val\"), after the '=>' it is a simple response code that can be followed ' && MATCHES <RegEx>' to match the response entity against or other matchers like HEADER, TIME or JSON (see defaults when creating a new configuration for examples).")
        public String[] requests() default {"/path/example.html", "/path/example.html => 200", "/protected/example.html => 401", "-u admin:admin /protected/example.html => 200", "/path/example.html => 200 && MATCHES <title>html title.*</title>", "/path/example.html => 200 && MATCHES <title>html title.*</title> && MATCHES anotherRegEx[a-z]", "/path/example.html => 200 && HEADER Content-Type MATCHES text/html.*", "/path/example.json => 200 && JSON root.arr[3].prop = myval", "/path/example-timing-important.html => 200 && TIME < 2000", "-X GET -H \"Accept: application/javascript\" http://api.example.com/path/example.json => 200 && JSON root.arr[3].prop = myval", "-X HEAD --data \"{....}\" http://www.example.com/path/to/data.json => 303", "--proxy proxyhost:2000 /path/example-timing-important.html => 200 && TIME < 2000"};

        @AttributeDefinition(name="Connect Timeout", description="Default connect timeout in ms. Can be overwritten per request with option --connect-timeout (in sec)")
        public int connectTimeoutInMs() default 7000;

        @AttributeDefinition(name="Read Timeout", description="Default read timeout in ms. Can be overwritten with per request option -m or --max-time (in sec)")
        public int readTimeoutInMs() default 7000;

        @AttributeDefinition(name="Status for failed request constraint", description="Status to fail with if the constraint check fails")
        public Result.Status statusForFailedContraint() default Result.Status.WARN;

        @AttributeDefinition(name="Run in parallel", description="Run requests in parallel (only active if more than one request spec is configured)")
        public boolean runInParallel() default true;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{hc.name}: {requests}";
    }
}

