/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.generalchecks.util.SimpleConstraintChecker;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheck.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class JmxAttributeCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(JmxAttributeCheck.class);
    public static final String HC_NAME = "JMX Attribute";
    public static final String HC_LABEL = "Health Check: JMX Attribute";
    private Result.Status statusForFailedContraint;
    private List<AttributeConstraintConfig> attributeConstraintConfigs;

    @Activate
    protected void activate(Config config, Map<String, Object> rawConfig) {
        this.statusForFailedContraint = config.statusForFailedContraint();
        this.attributeConstraintConfigs = AttributeConstraintConfig.load(config, rawConfig);
        LOG.info("Activated JMX Attribute HC with statusForFailedContraint={} and attribute constraint config(s):", (Object)this.statusForFailedContraint);
        for (AttributeConstraintConfig attributeConstraintConfig : this.attributeConstraintConfigs) {
            LOG.info(attributeConstraintConfig.toString());
        }
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        for (AttributeConstraintConfig attributeConstraintConfig : this.attributeConstraintConfigs) {
            this.checkAttributeConstraint(resultLog, attributeConstraintConfig);
        }
        return new Result((ResultLog)resultLog);
    }

    private void checkAttributeConstraint(FormattingResultLog resultLog, AttributeConstraintConfig attributeConstraintConfig) {
        resultLog.debug("Checking {}", new Object[]{attributeConstraintConfig});
        try {
            MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(attributeConstraintConfig.mbeanName);
            if (jmxServer.queryNames(objectName, null).size() == 0) {
                resultLog.warn("MBean not found: {}", new Object[]{objectName});
            } else {
                Object value = jmxServer.getAttribute(objectName, attributeConstraintConfig.attributeName);
                resultLog.debug("{} {} returns {}", new Object[]{attributeConstraintConfig.mbeanName, attributeConstraintConfig.attributeName, value});
                boolean matches = new SimpleConstraintChecker().check(value, attributeConstraintConfig.attributeValueConstraint);
                String baseMsg = "JMX attribute " + attributeConstraintConfig.mbeanName + " -> '" + attributeConstraintConfig.attributeName + "': Value [" + value + "] ";
                if (matches) {
                    resultLog.add(new ResultLog.Entry(Result.Status.OK, baseMsg + "matches constraint [" + attributeConstraintConfig.attributeValueConstraint + "]"));
                } else {
                    resultLog.add(new ResultLog.Entry(this.statusForFailedContraint, baseMsg + "does not match constraint [" + attributeConstraintConfig.attributeValueConstraint + "]"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("JMX check {} failed: {}", new Object[]{attributeConstraintConfig, e.getMessage(), e});
            resultLog.healthCheckError("JMX attribute check failed: {}", new Object[]{attributeConstraintConfig, e});
        }
    }

    private static class AttributeConstraintConfig {
        public static final String PROP_MBEAN = "mbean";
        public static final String PROP_ATTRIBUTE = "attribute";
        public static final String SUFFIX_NAME = ".name";
        public static final String SUFFIX_VALUE_CONSTRAINT = ".value.constraint";
        final String mbeanName;
        final String attributeName;
        final String attributeValueConstraint;

        private static List<AttributeConstraintConfig> load(Config config, Map<String, Object> rawConfig) {
            ArrayList<AttributeConstraintConfig> attributeConstraintConfigs = new ArrayList<AttributeConstraintConfig>();
            attributeConstraintConfigs.add(new AttributeConstraintConfig(config.mbean_name(), config.attribute_name(), config.attribute_value_constraint()));
            int attributeCounter = 2;
            while (AttributeConstraintConfig.hasConfig(rawConfig, attributeCounter)) {
                attributeConstraintConfigs.add(new AttributeConstraintConfig(rawConfig, attributeCounter));
                ++attributeCounter;
            }
            return attributeConstraintConfigs;
        }

        private static String getAttributePropName(int attributeCounter) {
            return PROP_ATTRIBUTE + attributeCounter + SUFFIX_NAME;
        }

        private static boolean hasConfig(Map<String, Object> rawConfig, int attributeCounter) {
            return rawConfig.containsKey(AttributeConstraintConfig.getAttributePropName(attributeCounter));
        }

        public AttributeConstraintConfig(String mbeanName, String attributeName, String attributeValueConstraint) {
            this.mbeanName = mbeanName;
            this.attributeName = attributeName;
            this.attributeValueConstraint = attributeValueConstraint;
        }

        public AttributeConstraintConfig(Map<String, Object> rawConfig, int attributeCounter) {
            String propNameAttribute = AttributeConstraintConfig.getAttributePropName(attributeCounter);
            String defaultMBeanName = (String)rawConfig.get("mbean.name");
            String mBeanName = (String)rawConfig.get(PROP_MBEAN + attributeCounter + SUFFIX_NAME);
            this.mbeanName = (String)StringUtils.defaultIfBlank((CharSequence)mBeanName, (CharSequence)defaultMBeanName);
            this.attributeName = (String)rawConfig.get(propNameAttribute);
            this.attributeValueConstraint = (String)rawConfig.get(PROP_ATTRIBUTE + attributeCounter + SUFFIX_VALUE_CONSTRAINT);
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.mbeanName, this.attributeName, this.attributeValueConstraint})) {
                throw new IllegalArgumentException("Invalid JmxAttributeCheck config for property " + this.mbeanName + " -> " + propNameAttribute + ": " + this.toString());
            }
        }

        public String toString() {
            return "JMX attribute " + this.mbeanName + " -> '" + this.attributeName + "': Constraint: " + this.attributeValueConstraint;
        }
    }

    @ObjectClassDefinition(name="Health Check: JMX Attribute", description="Checks the value of a single JMX attribute.")
    static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check.")
        public String hc_name() default "JMX Attribute";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="MBean Name", description="The name of the MBean to retrieve the attribute to be checked from.")
        public String mbean_name() default "";

        @AttributeDefinition(name="Attribute Name", description="The name of the MBean attribute to check against the constraint.")
        public String attribute_name() default "";

        @AttributeDefinition(name="Attribute Constraint", description="Constraint on the MBean attribute value. If simple value, uses equals. For strings constraints like 'CONTAINS mystr', 'STARTS_WITH mystr' or 'ENDS_WITH mystr' can be used, for numbers constraints like '> 4', '= 7', '< 9' or 'between 3 and 7' work.")
        public String attribute_value_constraint() default "";

        @AttributeDefinition(name="Status for failed constraint", description="Status to fail with if the constraint check fails")
        public Result.Status statusForFailedContraint() default Result.Status.WARN;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "JMX MBean {mbean.name} Attribute '{attribute.name}' constraint: {attribute.value.constraint}";
    }
}

