/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.util.regex.Pattern;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Bundles Started")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Config.class, factory=true)
public class BundlesStartedCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(BundlesStartedCheck.class);
    public static final String HC_NAME = "Bundles Started";
    public static final String HC_LABEL = "Health Check: Bundles Started";
    private BundleContext bundleContext;
    private Pattern includesRegex;
    private Pattern excludesRegex;
    boolean useCriticalForInactive;

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.includesRegex = Pattern.compile(config.includesRegex());
        this.excludesRegex = StringUtils.isNotBlank(config.excludesRegex()) ? Pattern.compile(config.excludesRegex()) : null;
        this.useCriticalForInactive = config.useCriticalForInactive();
        LOG.debug("Activated bundles started HC for includesRegex={} excludesRegex={}% useCriticalForInactive={}", new Object[]{this.includesRegex, this.excludesRegex, this.useCriticalForInactive});
    }

    public Result execute() {
        String excludedMsg;
        FormattingResultLog log = new FormattingResultLog();
        Bundle[] bundles = this.bundleContext.getBundles();
        log.debug("Framwork has {} bundles in total", new Object[]{bundles.length});
        int countExcluded = 0;
        int relevantBundlesCount = 0;
        int inctiveCount = 0;
        for (Bundle bundle : bundles) {
            String bundleSymbolicName = bundle.getSymbolicName();
            int bundleState = bundle.getState();
            if (!this.includesRegex.matcher(bundleSymbolicName).matches()) {
                LOG.debug("Bundle {} not matched by {}", (Object)bundleSymbolicName, (Object)this.includesRegex);
                continue;
            }
            if (this.excludesRegex != null && this.excludesRegex.matcher(bundleSymbolicName).matches()) {
                LOG.debug("Bundle {} excluded {}", (Object)bundleSymbolicName, (Object)this.excludesRegex);
                ++countExcluded;
                continue;
            }
            ++relevantBundlesCount;
            boolean bundleIsLogged = false;
            if (bundleState != 32) {
                if (bundleState == 8 && BundlesStartedCheck.isLazyActivation(bundle)) {
                    LOG.debug("Ignoring lazily activated bundle {}", (Object)bundleSymbolicName);
                } else if (StringUtils.isNotBlank((CharSequence)bundle.getHeaders().get("Fragment-Host"))) {
                    LOG.debug("Ignoring bundle fragment: {}", (Object)bundleSymbolicName);
                } else {
                    String msg = "Inactive bundle {} {}: {}";
                    Object[] msgObjs = new Object[]{bundle.getBundleId(), bundleSymbolicName, BundlesStartedCheck.getStateLabel(bundleState)};
                    LOG.debug(msg, msgObjs);
                    if (this.useCriticalForInactive) {
                        log.critical(msg, msgObjs);
                    } else {
                        log.warn(msg, msgObjs);
                    }
                    bundleIsLogged = true;
                    ++inctiveCount;
                }
            }
            if (bundleIsLogged) continue;
            log.debug("Bundle {} {}: {}", new Object[]{bundle.getBundleId(), bundleSymbolicName, BundlesStartedCheck.getStateLabel(bundleState)});
        }
        String baseMsg = relevantBundlesCount + " bundles" + (!this.includesRegex.pattern().equals(".*") ? " for pattern " + this.includesRegex.pattern() : "");
        String string = excludedMsg = countExcluded > 0 ? " (" + countExcluded + " excluded via pattern " + this.excludesRegex.pattern() + ")" : "";
        if (inctiveCount > 0) {
            log.info("Found  " + inctiveCount + " inactive of " + baseMsg + excludedMsg, new Object[0]);
        } else {
            log.info("All " + baseMsg + " are started" + excludedMsg, new Object[0]);
        }
        return new Result((ResultLog)log);
    }

    private static boolean isLazyActivation(Bundle b) {
        return "lazy".equals(b.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private static String getStateLabel(int state) {
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "" + state;
    }

    @ObjectClassDefinition(name="Health Check: Bundles Started", description="Checks the configured path(s) against the given thresholds")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Bundles Started";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Includes RegEx", description="RegEx to select all relevant bundles for this check. The RegEx is matched against the symbolic name of the bundle.")
        public String includesRegex() default ".*";

        @AttributeDefinition(name="Excludes RegEx", description="Optional RegEx to exclude bundles from this check (matched against symbolic name). Allows to exclude specific bundles from selected set as produced by 'Includes RegEx'.")
        public String excludesRegex() default "";

        @AttributeDefinition(name="CRITICAL for inactive bundles", description="By default inactive bundles produce warnings, if this is set to true inactive bundles produce a CRITICAL result")
        public boolean useCriticalForInactive() default false;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Bundles started includes: {includesRegex} excludes: {excludesRegex}";
    }
}

