/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.apache.felix.hc.generalchecks.util.ScriptEnginesTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ScriptHelper {
    public String getFileContents(String url) {
        try {
            String content;
            URLConnection conn = new URL(url).openConnection();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                content = reader.lines().collect(Collectors.joining("\n"));
            }
            return content;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read URL " + url + ": " + e, e);
        }
    }

    public ScriptEngine getScriptEngine(ScriptEnginesTracker scriptEnginesTracker, String language) {
        ScriptEngine scriptEngine = scriptEnginesTracker.getEngineByLanguage(language);
        if (scriptEngine == null) {
            throw new IllegalArgumentException("No ScriptEngineFactory found for language " + language + " (available languages: " + scriptEnginesTracker.getLanguagesByBundle() + ")");
        }
        return scriptEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalScript(BundleContext bundleContext, ScriptEngine scriptEngine, String scriptToExecute, FormattingResultLog log, Map<String, Object> additionalBindings, boolean logScriptResult) throws ScriptException, IOException {
        SimpleBindings bindings = new SimpleBindings();
        ScriptHelperBinding scriptHelper = new ScriptHelperBinding(bundleContext);
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        bindings.put("scriptHelper", (Object)scriptHelper);
        bindings.put("osgi", (Object)scriptHelper);
        bindings.put("log", (Object)log);
        bindings.put("bundleContext", (Object)bundleContext);
        if (additionalBindings != null) {
            for (Map.Entry<String, Object> additionalBinding : additionalBindings.entrySet()) {
                bindings.put(additionalBinding.getKey(), additionalBinding.getValue());
            }
        }
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setBindings(bindings, 100);
        scriptContext.setWriter(stdout);
        scriptContext.setErrorWriter(stderr);
        try {
            log.debug(scriptToExecute, new Object[0]);
            Object scriptResult = scriptEngine.eval(scriptToExecute, (ScriptContext)scriptContext);
            this.appendStreamsToResult(log, stdout, stderr, scriptContext);
            if (scriptResult instanceof Result) {
                Result result = (Result)scriptResult;
                for (ResultLog.Entry entry : result) {
                    log.add(entry);
                }
            } else if (scriptResult != null && logScriptResult) {
                log.info("Script result: {}", new Object[]{scriptResult});
            }
            Object object = scriptResult;
            return object;
        }
        finally {
            scriptHelper.ungetServices();
        }
    }

    private void appendStreamsToResult(FormattingResultLog log, StringWriter stdout, StringWriter stderr, SimpleScriptContext scriptContext) throws IOException {
        scriptContext.getWriter().flush();
        String stdoutStr = stdout.toString();
        if (StringUtils.isNotBlank(stdoutStr)) {
            log.info("stdout of script: {}", new Object[]{stdoutStr});
        }
        scriptContext.getErrorWriter().flush();
        String stderrStr = stderr.toString();
        if (StringUtils.isNotBlank(stderrStr)) {
            log.critical("stderr of script: {}", new Object[]{stderrStr});
        }
    }

    class ScriptHelperBinding {
        private final BundleContext bundleContext;
        private List<ServiceReference<?>> references;
        private Map<String, Object> services;

        public ScriptHelperBinding(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        public <ServiceType> ServiceType getService(Class<ServiceType> type) {
            ServiceReference ref;
            Object service;
            Object object = service = this.services == null ? null : this.services.get(type.getName());
            if (service == null && (ref = this.bundleContext.getServiceReference(type.getName())) != null && (service = this.bundleContext.getService(ref)) != null) {
                if (this.services == null) {
                    this.services = new HashMap<String, Object>();
                }
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.add(ref);
                this.services.put(type.getName(), service);
            }
            return (ServiceType)service;
        }

        public <T> T[] getServices(Class<T> serviceType, String filter) throws InvalidSyntaxException {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(serviceType.getName(), filter);
            Object[] result = null;
            if (refs != null) {
                ArrayList<Object> objects = new ArrayList<Object>();
                for (int i = 0; i < refs.length; ++i) {
                    Object service = this.bundleContext.getService(refs[i]);
                    if (service == null) continue;
                    if (this.references == null) {
                        this.references = new ArrayList();
                    }
                    this.references.add(refs[i]);
                    objects.add(service);
                }
                if (objects.size() > 0) {
                    Object[] srv = (Object[])Array.newInstance(serviceType, objects.size());
                    result = objects.toArray(srv);
                }
            }
            return result;
        }

        public void ungetServices() {
            if (this.references != null) {
                for (ServiceReference<?> ref : this.references) {
                    this.bundleContext.ungetService(ref);
                }
                this.references.clear();
            }
            if (this.services != null) {
                this.services.clear();
            }
        }
    }
}

