/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.lang.management.ManagementFactory;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="CPU")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=false)
public class CpuCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CpuCheck.class);
    public static final String HC_NAME = "CPU";
    public static final String HC_LABEL = "Health Check: CPU";
    private long cpuPercentageThresholdWarn;

    @Activate
    protected void activate(Config config) {
        this.cpuPercentageThresholdWarn = config.cpuPercentageThresholdWarn();
        LOG.debug("Activated CPU HC: cpuPercentageThresholdWarn={}%", (Object)this.cpuPercentageThresholdWarn);
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        double processCpuLoad = Double.NaN;
        try {
            processCpuLoad = this.getProcessCpuLoad();
        }
        catch (Exception e) {
            log.add(new ResultLog.Entry(Result.Status.HEALTH_CHECK_ERROR, "Could not get process CPU load: " + e, e));
        }
        if (Double.isNaN(processCpuLoad)) {
            log.info("No CPU load available yet", new Object[0]);
        } else {
            String loadStr = String.format("%.1f", processCpuLoad);
            Result.Status status = processCpuLoad < (double)this.cpuPercentageThresholdWarn ? Result.Status.OK : Result.Status.WARN;
            log.add(new ResultLog.Entry(status, "Process CPU Usage: " + loadStr + "%"));
        }
        return new Result((ResultLog)log);
    }

    public double getProcessCpuLoad() throws MalformedObjectNameException, ReflectionException, InstanceNotFoundException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
        AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
        if (list.isEmpty()) {
            return Double.NaN;
        }
        Attribute att = (Attribute)list.get(0);
        Double value = (Double)att.getValue();
        if (value == -1.0) {
            return Double.NaN;
        }
        return value * 100.0;
    }

    @ObjectClassDefinition(name="Health Check: CPU", description="Checks for high CPU load")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "CPU";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="CPU usage threshold for WARN", description="in percent, if CPU usage is over this limit the result is WARN")
        public long cpuPercentageThresholdWarn() default 95L;
    }
}

