/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import javax.script.ScriptEngine;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.apache.felix.hc.generalchecks.util.ScriptEnginesTracker;
import org.apache.felix.hc.generalchecks.util.ScriptHelper;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheck.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class ScriptedHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptedHealthCheck.class);
    public static final String HC_LABEL = "Health Check: Script";
    private String language;
    private String script;
    private String scriptUrl;
    private BundleContext bundleContext;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ScriptEnginesTracker scriptEnginesTracker;
    private ScriptHelper scriptHelper = new ScriptHelper();

    @Activate
    protected void activate(BundleContext context, Config config) {
        this.bundleContext = context;
        this.language = config.language().toLowerCase();
        this.script = config.script();
        this.scriptUrl = config.scriptUrl();
        if (StringUtils.isNotBlank(this.script) && StringUtils.isNotBlank(this.scriptUrl)) {
            LOG.info("Both 'script' and 'scriptUrl' (=()) are configured, ignoring 'scriptUrl'", (Object)this.scriptUrl);
            this.scriptUrl = null;
        }
        LOG.debug("Activated Scripted HC " + config.hc_name() + " with " + (StringUtils.isNotBlank(this.script) ? "script " + this.script : "script url " + this.scriptUrl));
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        boolean urlIsUsed = StringUtils.isBlank(this.script);
        String scriptToExecute = urlIsUsed ? this.scriptHelper.getFileContents(this.scriptUrl) : this.script;
        log.info("Executing script {} ({} lines)...", new Object[]{urlIsUsed ? this.scriptUrl : " as configured", scriptToExecute.split("\n").length});
        try {
            ScriptEngine scriptEngine = this.scriptHelper.getScriptEngine(this.scriptEnginesTracker, this.language);
            this.scriptHelper.evalScript(this.bundleContext, scriptEngine, scriptToExecute, log, null, true);
        }
        catch (Exception e) {
            log.healthCheckError("Exception while executing script: " + e, new Object[]{e});
        }
        return new Result((ResultLog)log);
    }

    @ObjectClassDefinition(name="Health Check: Script", description="Runs an arbitrary script in given scriping language (via javax.script). The script has the following default bindings available: 'log', 'scriptHelper' and 'bundleContext'. 'log' is an instance of org.apache.felix.hc.api.FormattingResultLog and is used to define the result of the HC. 'scriptHelper.getService(classObj)' can be used as shortcut to retrieve a service.'scriptHelper.getServices(classObj, filter)' used to retrieve multiple services for a class using given filter. For all services retrieved via scriptHelper, unget() is called automatically at the end of the script execution.'bundleContext' is available for advanced use cases. The script does not need to return any value, but if it does and it is a org.apache.felix.hc.api.Result, that result and entries in 'log' are combined then).")
    static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check.")
        public String hc_name() default "Scripted Health Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Language", description="The language the script is written in. To use e.g. 'groovy', ensure osgi bundle 'groovy-all' is available.")
        public String language() default "groovy";

        @AttributeDefinition(name="Script", description="The script itself (either use 'script' or 'scriptUrl').")
        public String script() default "log.info('ok'); log.warn('not so good'); log.critical('bad') // minimal example";

        @AttributeDefinition(name="Script Url", description="Url to the script to be used as alternative source (either use 'script' or 'scriptUrl').")
        public String scriptUrl() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Scripted HC: {hc.name} (tags: {hc.tags}) {scriptUrl} language: {language}";
    }
}

