/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ScriptEnginesTracker.class})
public class ScriptEnginesTracker
implements BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEnginesTracker.class);
    private static final String ENGINE_FACTORY_SERVICE = "META-INF/services/" + ScriptEngineFactory.class.getName();
    private final Map<String, ScriptEngineFactory> enginesByLanguage = new ConcurrentHashMap<String, ScriptEngineFactory>();
    private final Map<Bundle, List<String>> languagesByBundle = new ConcurrentHashMap<Bundle, List<String>>();
    private BundleContext context;

    @Activate
    public void activate(BundleContext context) {
        this.context = context;
        this.context.addBundleListener((BundleListener)this);
        this.registerInitialScriptEngineFactories();
    }

    @Deactivate
    public void deactivate() {
        this.context.removeBundleListener((BundleListener)this);
        this.enginesByLanguage.clear();
        this.languagesByBundle.clear();
    }

    public ScriptEngine getEngineByLanguage(String language) {
        ScriptEngineFactory factory = this.enginesByLanguage.get(language.toLowerCase());
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        return engine;
    }

    public Map<Bundle, List<String>> getLanguagesByBundle() {
        return this.languagesByBundle;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2 && event.getBundle().getEntry(ENGINE_FACTORY_SERVICE) != null) {
            this.registerFactories(event.getBundle());
        } else if (event.getType() == 4) {
            this.unregisterFactories(event.getBundle());
        }
    }

    private void registerInitialScriptEngineFactories() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.context.getBundles()) {
            if (bundle.getState() != 32 || bundle.getEntry(ENGINE_FACTORY_SERVICE) == null) continue;
            this.registerFactories(bundle);
        }
    }

    private void registerFactories(Bundle bundle) {
        List<ScriptEngineFactory> scriptEngineFactoriesForBundle = this.getScriptEngineFactoriesForBundle(bundle);
        for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactoriesForBundle) {
            this.registerFactory(bundle, scriptEngineFactory);
        }
    }

    private void unregisterFactories(Bundle bundle) {
        List<String> languagesForBundle = this.languagesByBundle.get(bundle);
        if (languagesForBundle != null) {
            for (String lang : languagesForBundle) {
                ScriptEngineFactory removed = this.enginesByLanguage.remove(lang);
                LOG.info("Removing ScriptEngine {} for language {}", (Object)removed, (Object)lang);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ScriptEngineFactory> getScriptEngineFactoriesForBundle(Bundle bundle) {
        URL url = bundle.getEntry(ENGINE_FACTORY_SERVICE);
        InputStream ins = null;
        ArrayList<ScriptEngineFactory> scriptEngineFactoriesInBundle = new ArrayList<ScriptEngineFactory>();
        try {
            ins = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            for (String className : ScriptEnginesTracker.getClassNames(reader)) {
                try {
                    Class clazz = bundle.loadClass(className);
                    ScriptEngineFactory spi = (ScriptEngineFactory)clazz.newInstance();
                    scriptEngineFactoriesInBundle.add(spi);
                }
                catch (Throwable t) {
                    LOG.error("Cannot register ScriptEngineFactory {}", (Object)className, (Object)t);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to load factories as defined in {}", (Object)ENGINE_FACTORY_SERVICE, (Object)ioe);
        }
        finally {
            this.closeQuietly(ins);
        }
        return scriptEngineFactoriesInBundle;
    }

    private void closeQuietly(InputStream ins) {
        if (ins != null) {
            try {
                ins.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void registerFactory(Bundle bundle, ScriptEngineFactory factory) {
        LOG.info("Adding ScriptEngine {}, {} for language {}, {}", new Object[]{factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion()});
        String scriptLang = factory.getLanguageName().toLowerCase();
        this.enginesByLanguage.put(scriptLang, factory);
        List<String> languages = this.languagesByBundle.get(bundle);
        if (languages == null) {
            languages = new ArrayList<String>();
            this.languagesByBundle.put(bundle, languages);
        }
        languages.add(scriptLang);
    }

    static List<String> getClassNames(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() <= 0) continue;
            int indexOfHash = line.indexOf(35);
            if (indexOfHash >= 0) {
                line = line.substring(0, indexOfHash);
            }
            line = line.trim();
            classNames.add(line);
        }
        return classNames;
    }
}

