/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Memory")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Config.class, factory=false)
public class MemoryCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryCheck.class);
    public static final String HC_NAME = "Memory";
    public static final String HC_LABEL = "Health Check: Memory";
    private long heapUsedPercentageThresholdWarn;
    private long heapUsedPercentageThresholdCritical;

    @Activate
    protected void activate(Config config) {
        this.heapUsedPercentageThresholdWarn = config.heapUsedPercentageThresholdWarn();
        this.heapUsedPercentageThresholdCritical = config.heapUsedPercentageThresholdCritical();
        LOG.debug("Activated Memory HC: heapUsedPercentageThresholdWarn={}% heapUsedPercentageThresholdCritical={}%", (Object)this.heapUsedPercentageThresholdWarn, (Object)this.heapUsedPercentageThresholdCritical);
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        log.debug("Free memory: {}", new Object[]{FormattingResultLog.bytesHumanReadable((double)freeMemory)});
        long currentlyAllocatedByJVM = runtime.totalMemory();
        log.debug("Currently allocated memory: {}", new Object[]{FormattingResultLog.bytesHumanReadable((double)currentlyAllocatedByJVM)});
        long usedMemory = currentlyAllocatedByJVM - freeMemory;
        log.debug("Used memory: {}", new Object[]{FormattingResultLog.bytesHumanReadable((double)usedMemory)});
        long maxMemoryAvailableToJVM = runtime.maxMemory();
        double memoryUsedPercentage = (double)usedMemory / (double)maxMemoryAvailableToJVM * 100.0;
        Result.Status status = memoryUsedPercentage < (double)this.heapUsedPercentageThresholdWarn ? Result.Status.OK : (memoryUsedPercentage < (double)this.heapUsedPercentageThresholdCritical ? Result.Status.WARN : Result.Status.CRITICAL);
        String message = String.format("Memory Usage: %.1f%% of %s maximal heap used", memoryUsedPercentage, FormattingResultLog.bytesHumanReadable((double)maxMemoryAvailableToJVM));
        log.add(new ResultLog.Entry(status, message));
        return new Result((ResultLog)log);
    }

    @ObjectClassDefinition(name="Health Check: Memory", description="Checks for high CPU load")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Memory";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Heap used threshold for WARN", description="in percent, if heap usage is over this limit the result is WARN")
        public long heapUsedPercentageThresholdWarn() default 90L;

        @AttributeDefinition(name="Heap used threshold for CRITICAL", description="in percent, if heap usage is over this limit the result is CRITICAL")
        public long heapUsedPercentageThresholdCritical() default 99L;
    }
}

