/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.PreprocessorInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.whiteboard.Preprocessor;

public class PreprocessorHandler
implements Comparable<PreprocessorHandler> {
    private final PreprocessorInfo info;
    private final ServletContext context;
    private final BundleContext bundleContext;
    private volatile Preprocessor preprocessor;

    public PreprocessorHandler(BundleContext bundleContext, ServletContext context, PreprocessorInfo info) {
        this.bundleContext = bundleContext;
        this.context = context;
        this.info = info;
    }

    @Override
    public int compareTo(PreprocessorHandler other) {
        return this.info.compareTo(other.info);
    }

    public ServletContext getContext() {
        return this.context;
    }

    public PreprocessorInfo getPreprocessorInfo() {
        return this.info;
    }

    public int init() {
        ServiceReference serviceReference = this.info.getServiceReference();
        this.preprocessor = (Preprocessor)this.bundleContext.getService(serviceReference);
        if (this.preprocessor == null) {
            return 5;
        }
        try {
            this.preprocessor.init((FilterConfig)new FilterConfigImpl(this.preprocessor.getClass().getName(), this.getContext(), this.getPreprocessorInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.error(this.getPreprocessorInfo().getServiceReference(), "Error during calling init() on preprocessor " + this.preprocessor, e);
            this.preprocessor = null;
            this.bundleContext.ungetService(serviceReference);
            return 4;
        }
        return -1;
    }

    public boolean destroy() {
        if (this.preprocessor == null) {
            return false;
        }
        try {
            this.preprocessor.destroy();
        }
        catch (Exception ignore) {
            SystemLogger.error(this.getPreprocessorInfo().getServiceReference(), "Error during calling destroy() on preprocessor " + this.preprocessor, ignore);
        }
        this.preprocessor = null;
        this.bundleContext.ungetService(this.info.getServiceReference());
        return true;
    }

    public void handle(@Nonnull ServletRequest req, @Nonnull ServletResponse res, @Nonnull FilterChain chain) throws ServletException, IOException {
        this.preprocessor.doFilter(req, res, chain);
    }

    public boolean dispose() {
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.info.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PreprocessorHandler other = (PreprocessorHandler)obj;
        return this.info.equals(other.info);
    }
}

