/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Hashtable;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.service.PerBundleHttpServiceImpl;
import org.apache.felix.http.base.internal.service.SharedHttpServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public final class HttpServiceFactory
implements ServiceFactory<HttpService> {
    public static final String HTTP_SERVICE_CONTEXT_NAME = "org.osgi.service.http";
    public static final long HTTP_SERVICE_CONTEXT_SERVICE_ID = -1L;
    private static final String FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES = "org.apache.felix.http.shared_servlet_context_attributes";
    private static final String OBSOLETE_REG_PROPERTY_ENDPOINTS = "osgi.http.service.endpoints";
    private volatile boolean active = false;
    private final BundleContext bundleContext;
    private final boolean sharedContextAttributes;
    private final Hashtable<String, Object> httpServiceProps = new Hashtable();
    private volatile ServletContext context;
    private volatile ServiceRegistration<HttpService> httpServiceReg;
    private final HandlerRegistry handlerRegistry;
    private volatile SharedHttpServiceImpl sharedHttpService;

    public HttpServiceFactory(BundleContext bundleContext, HandlerRegistry handlerRegistry) {
        this.bundleContext = bundleContext;
        this.handlerRegistry = handlerRegistry;
        this.sharedContextAttributes = this.getBoolean(FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES);
    }

    public void start(ServletContext context, @Nonnull Hashtable<String, Object> props) {
        this.httpServiceProps.clear();
        this.httpServiceProps.putAll(props);
        if (this.httpServiceProps.get("osgi.http.endpoint") != null) {
            this.httpServiceProps.put(OBSOLETE_REG_PROPERTY_ENDPOINTS, this.httpServiceProps.get("osgi.http.endpoint"));
        }
        this.context = context;
        this.sharedHttpService = new SharedHttpServiceImpl(this.handlerRegistry);
        this.active = true;
        this.httpServiceReg = this.bundleContext.registerService(HttpService.class, (ServiceFactory)this, this.httpServiceProps);
    }

    public void stop() {
        this.active = false;
        if (this.httpServiceReg != null) {
            this.httpServiceReg.unregister();
            this.httpServiceReg = null;
        }
        this.context = null;
        this.sharedHttpService = null;
        this.httpServiceProps.clear();
    }

    public HttpService getService(Bundle bundle, ServiceRegistration<HttpService> reg) {
        if (this.active) {
            SharedHttpServiceImpl sharedHttpSvc = this.sharedHttpService;
            ServletContext servletCtx = this.context;
            boolean sharedCtxAttrs = this.sharedContextAttributes;
            if (this.active) {
                return new PerBundleHttpServiceImpl(bundle, sharedHttpSvc, servletCtx, sharedCtxAttrs);
            }
        }
        return null;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<HttpService> reg, HttpService service) {
        if (service instanceof PerBundleHttpServiceImpl) {
            ((PerBundleHttpServiceImpl)service).unregisterAll();
        }
    }

    public long getHttpServiceServiceId() {
        return (Long)this.httpServiceReg.getReference().getProperty("service.id");
    }

    private boolean getBoolean(String property) {
        String prop = this.bundleContext.getProperty(property);
        return prop != null ? Boolean.valueOf(prop) : false;
    }
}

