/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.whiteboard.PerBundleServletContextImpl;
import org.apache.felix.http.base.internal.whiteboard.SharedServletContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.service.http.context.ServletContextHelper;

public class WhiteboardContextHandler
implements Comparable<WhiteboardContextHandler> {
    private final ServletContextHelperInfo info;
    private final ServletContext webContext;
    private final Bundle httpBundle;
    private final Map<Long, ContextHolder> perBundleContextMap = new HashMap<Long, ContextHolder>();
    private volatile PerContextHandlerRegistry registry;
    private volatile ServletContext sharedContext;

    public WhiteboardContextHandler(@NotNull ServletContextHelperInfo info, @NotNull ServletContext webContext, @NotNull Bundle httpBundle) {
        this.webContext = webContext;
        this.info = info;
        this.httpBundle = httpBundle;
    }

    @NotNull
    public BundleContext getBundleContext() {
        return this.httpBundle.getBundleContext();
    }

    @NotNull
    public ServletContextHelperInfo getContextInfo() {
        return this.info;
    }

    @Override
    public int compareTo(@NotNull WhiteboardContextHandler o) {
        return this.info.compareTo(o.getContextInfo());
    }

    public boolean activate(@NotNull HandlerRegistry registry) {
        boolean activate;
        this.registry = new PerContextHandlerRegistry(this.info, registry.getConfig());
        this.sharedContext = new SharedServletContextImpl(this.webContext, this.info.getName(), this.info.getPath(), this.info.getInitParameters(), this.registry);
        boolean bl = activate = this.getServletContext(this.httpBundle) != null;
        if (!activate) {
            this.registry = null;
            this.sharedContext = null;
        } else {
            registry.add(this.registry);
        }
        return activate;
    }

    public void deactivate(@NotNull HandlerRegistry registry) {
        registry.remove(this.info);
        this.registry = null;
        this.sharedContext = null;
        this.ungetServletContext(this.httpBundle);
        this.perBundleContextMap.clear();
    }

    @Nullable
    public ServletContext getSharedContext() {
        return this.sharedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExtServletContext getServletContext(@Nullable Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        Long key = bundle.getBundleId();
        Map<Long, ContextHolder> map = this.perBundleContextMap;
        synchronized (map) {
            ContextHolder holder = this.perBundleContextMap.get(key);
            if (holder == null) {
                ServletContextHelper service;
                ServiceObjects so;
                BundleContext ctx = bundle.getBundleContext();
                ServiceObjects serviceObjects = so = ctx == null ? null : ctx.getServiceObjects(this.info.getServiceReference());
                if (so != null && (service = (ServletContextHelper)so.getService()) != null) {
                    holder = new ContextHolder();
                    holder.servletContextHelper = service;
                    holder.servletContext = new PerBundleServletContextImpl(bundle, this.sharedContext, service, this.registry);
                    this.perBundleContextMap.put(key, holder);
                }
            }
            if (holder != null) {
                ++holder.counter;
                return holder.servletContext;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServletContext(@NotNull Bundle bundle) {
        Long key = bundle.getBundleId();
        Map<Long, ContextHolder> map = this.perBundleContextMap;
        synchronized (map) {
            ContextHolder holder = this.perBundleContextMap.get(key);
            if (holder != null) {
                --holder.counter;
                if (holder.counter == 0L) {
                    this.perBundleContextMap.remove(key);
                    if (holder.servletContextHelper != null) {
                        ServiceObjects so;
                        BundleContext ctx = bundle.getBundleContext();
                        ServiceObjects serviceObjects = so = ctx == null ? null : ctx.getServiceObjects(this.info.getServiceReference());
                        if (so != null) {
                            so.ungetService((Object)holder.servletContextHelper);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public PerContextHandlerRegistry getRegistry() {
        return this.registry;
    }

    private static final class ContextHolder {
        public long counter;
        public ExtServletContext servletContext;
        public ServletContextHelper servletContextHelper;

        private ContextHolder() {
        }
    }
}

